<?php

if ( ! function_exists( 'ocdi_import_files' ) ) {
  function ocdi_import_files() {
    return array(
      array(
        'import_file_name'             => 'Classic',
        'categories'                   => array( 'Classic Site' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/demo.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-classic.jpg',
        'preview_url'                  => 'https://tectxon.themetechmount.com/tectxon-classic/',
        'has_slider'                   => true,
      ),
	array(
        'import_file_name'             => 'Overlay',
        'categories'                   => array( 'Overlay Site' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/demo.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-overlay.jpg',
        'preview_url'                  => 'https://tectxon.themetechmount.com/tectxon-overlay/',
        'has_slider'                   => true,
      ),
	  array(
        'import_file_name'             => 'Infostack',
        'categories'                   => array( 'Infostack Site' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/demo.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-infostack.jpg',
        'preview_url'                  => 'https://tectxon.themetechmount.com/',
        'has_slider'                   => true,
      ),
	  array(
        'import_file_name'             => 'RTL',
        'categories'                   => array( 'RTL Site' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/rtl-demo.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-rtl.jpg',
        'preview_url'                  => 'http://tectxon.themetechmount.com/tectxon-rtl',
        'has_slider'                   => true,
      ),
	   array(
        'import_file_name'             => 'Demo2',
        'categories'                   => array( 'Demo2 Site' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/demo2.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-demo2.jpg',
        'preview_url'                  => 'https://themetechmount.com/wordpress/tectxon/demo2/',
        'has_slider'                   => true,
      ),
	   array(
        'import_file_name'             => 'Demo3',
        'categories'                   => array( 'Demo3 Site' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/demo3.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-demo3.jpg',
        'preview_url'                  => 'https://themetechmount.com/wordpress/tectxon/demo3/',
        'has_slider'                   => true,
      ),
	  array(
        'import_file_name'             => 'Elementor',
        'categories'                   => array( 'Elementor Demo' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/elementor.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-infostack.jpg',
        'preview_url'                  => 'https://themetechmount.com/wordpress/tectxon/elementor/',
        'has_slider'                   => true,
      ),
	   array(
        'import_file_name'             => 'Advanced',
        'categories'                   => array( 'Advanced Demo' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/advanced.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-advanced.jpg',
        'preview_url'                  => 'https://themetechmount.com/wordpress/tectxon/tectxon-advanced/',
        'has_slider'                   => true,
      ),
	   array(
        'import_file_name'             => 'Demo4',
        'categories'                   => array( 'Demo4' ),
        'local_import_file'            => plugin_dir_path( __FILE__ ) . 'demo-content/demo4.xml',
        'import_preview_image_url'     => plugin_dir_url( __FILE__ ) . 'demo-content/images/layout-demo4.jpg',
        'preview_url'                  => 'https://themetechmount.com/wordpress/tectxon/demo4',
        'has_slider'                   => true,
      ),
    );
  }
}
add_filter( 'ocdi/import_files', 'ocdi_import_files' );

// Automatically assign "Front page", "Posts page" and menu locations after the importer is done
// Import Revolution Slider if plugin is active
if ( ! function_exists( 'tecxon_demo_after_import' ) ) {
  function tecxon_demo_after_import($selected_import) {
  	// Assign menus to their locations.
  	$main_menu = get_term_by( 'name', 'Main menu', 'nav_menu' );
    $footer_menu = get_term_by( 'name', 'Footer menu', 'nav_menu' );

  	set_theme_mod( 'nav_menu_locations', array(
  		'tm-main-menu' => $main_menu->term_id,
        'tm-footer-menu' => $footer_menu->term_id,
  		)
  	);
	
	// Import custom configuration
	$content = file_get_contents($selected_import["local_import_file"] );
		
	if ( false !== strpos( $content, '<wp:theme_custom>' ) ) {
		preg_match('|<wp:theme_custom>(.*?)</wp:theme_custom>|is', $content, $config);
		if ($config && is_array($config) && count($config) > 1){
			$config = unserialize(base64_decode($config[1]));
			if (is_array($config)){
				$configs = array(
						'page_for_posts',
						'show_on_front',
						'page_on_front',
						'posts_per_page',
						'sidebars_widgets',
					);
				foreach ($configs as $item){
					if (isset($config[$item])){
						if( $item=='page_for_posts' || $item=='page_on_front' ){
							$page = get_page_by_title( $config[$item] );
							if( isset($page->ID) ){
								$config[$item] = $page->ID;
							}
						}
						update_option($item, $config[$item]);
					}
				}
				if (isset($config['sidebars_widgets'])){
					$sidebars = $config['sidebars_widgets'];
					update_option('sidebars_widgets', $sidebars);
					// read config
					$sidebars_config = array();
					if (isset($config['sidebars_config'])){
						$sidebars_config = $config['sidebars_config'];
						if (is_array($sidebars_config)){
							foreach ($sidebars_config as $name => $widget){
								update_option('widget_'.$name, $widget);
							}
						}
					}
				}						
			}
		}
	}
			
    // Configure permalinks
    global $wp_rewrite;
  	$wp_rewrite->set_permalink_structure( '/%postname%/' );
    flush_rewrite_rules();

    // Import Slider Revolution
    if ( class_exists( 'RevSlider' ) ) {
		
// List of slider backup ZIP that we will import
	$slider_array	= array(
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/tectxon-corprate-slider.zip',
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/tectxon-classic-slider.zip',
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/overlay-classic-slider.zip',
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/tectxon-shop-mainslider.zip',
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/home-maincorporate-slider.zip',
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/classic-main-slider.zip',
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/mainslider-creative-homeslider.zip',
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/slider-1.zip',
		plugin_dir_path( __FILE__ ) . 'demo-content/sliders/Tectxon-Demo4--Home-Slider.zip',
	);

        $slider = new RevSlider();

        foreach($slider_array as $filepath){
          $slider->importSliderFromPost(true,true,$filepath);
        }

        echo ' Slider processed';
    }
	
	
	/**** Breacrumb NavXT related changes ****/
	$breadcrumb_navxt_settings						= array();
	$breadcrumb_navxt_settings['hseparator']		= '<span class="tm-bread-sep"> &nbsp; &ndash; &nbsp;</span>';  // General > Breadcrumb Separator
	$breadcrumb_navxt_settings['Hhome_template']	= '<span typeof="v:Breadcrumb"><a rel="v:url" property="v:title" title="Go to %title%." href="%link%" class="%type%"><i class="themifyicon ti-home"></i>&nbsp;&nbsp;Home<span class="hide">%htitle%</span></a></span>';  // General > Home Template
	$breadcrumb_navxt_settings['Hhome_template_no_anchor']	= '<span property="itemListElement" typeof="ListItem"><span property="name">%htitle%</span><meta property="position" content="%position%"></span>';  // General > Home Template
	
	// Getting existing settings
	$bcn_options    = get_option('bcn_options');
	if( !empty($bcn_options) && is_array($bcn_options) ){
		// options already exists... so merging changes with existing options
		$breadcrumb_navxt_settings = array_merge($bcn_options, $breadcrumb_navxt_settings);
	}
	update_option( 'bcn_options', $breadcrumb_navxt_settings );

	/**** START - Edit "Hello World" post and change *****/
	$hello_world_post = get_post(1);
	if( !empty($hello_world_post) ){
		$newDate = array(
			'ID'		=> '1',
			'post_date'	=> "2014-12-10 0:0:0" // [ Y-m-d H:i:s ]
		);
		
		wp_update_post($newDate);
	}
	

	
	
  }
}
add_action( 'ocdi/after_import', 'tecxon_demo_after_import' );

function tectxon_demo_before_import( $selected_import ) {
	$theme_options = array();
	
	$theme_options['Classic']	= 'eNrVPWtz2ziS31OV_4BTaqviWlPmS8-xfetNcnNXtXls4tTe1lWKBYmQxDFFcknKjjeTH7R_Y3_ZdeNFkKJoxbETO56MSaDRaDQa3Y1Gg6FTd-BPvxTTybRXXFxEyTyN07z3SzEdTXvPFosBc3x8G057Mb1ONyW--NPeVRQyfHTG095iE8cBFgQsZmuWlEXvFzp1pl-iqS2arhgNGWD9Cg0chSkorzOOY1ww6FZRKfABGTS8pMmcBeUKsHF6CklQyBZ0E3MaHCCigNokpPl1jWjP9gaDUCHTMNYyZ3XAhbcYLMb45trT3iym84uoWAWzTVmmdT44M_zhKOF1GaczGgczgF_m6SYJcbgj5CGMJFrTJR8JoJTNeVEUGoXAkpxljJZGGTAyS4uojNLEKHXgNy1LOl8hY40KHH70T7NcJ-i8ObzRYlwimA4dRknC8sdENExenKLcROuliXxcXJUDicF8U5Tp2lwwcF3AyQsDmPqSRjhuEM9yJUlwnJHNMQHgkkEtTOZcIkVCKZL-hQ91QddRfI1gQMfbjCXkA024HDoeCAuwcZNZFZALTc7pKl3TQ_Ir4LyE3wU0sAqgcyFHd0nziAqGjJCZy01McyXMJftcXFplDm0WaW6OB_pH6izFOaDaGfBWuJRgdNaKRctVKevcscIYs7JkuVVkdB4lnIXQwG7j-iAcDkZDxRMaxxaSKlYyRyqm1xeUSGFYpukyZkK-bE7JhaWxAtGw6C5W6SXL9axpCMsYOyB9ZttiQoY1IN0YSRyxGbU9DgXUr5xcMHUKDEvP3GRr4nCizkE24zjarMnf2Gz37AF1ZzA38SH5bxZfsjKa3zB_gGUoif7GufPt3XPnD7597mzXDt1h9_Qgx9xHyzGvQ9p9-_445j1ejnXImHePMuY_Wo65HTLm3aOMDX4yx77PDrn2z-Ha8FFzrdN63xPXXFzhhP_Upend0mB2sGtwG3YNnaFHbxSyYjO7mWP7-Yb3XCJf0PUmy1g-pwW7jaDdwgyMnTEdL24UNPS6wXd8mGz7GU71bm45fFwnvWTl4zOY3t1yax8lBm3F5lxcc2v4ELnVPfCdw3N9PbwyzWZpiTvYjIahRIBcIuqoDe6ahTC-wGCHKcljNWgZkAnKqMRefjTDvnNBjrrFAWhcXMxobpkRiEaQSIIEs2WgpW0stqYYDlLbSQHTHRpxbKBkVZZZMT06Ktm8_JwmfR6igpfVGtqV_Xm6VlVWSEt6dJVZUhsecdBCVR9xvMURbnFjem3xCcLBzJb937LlfkEY4FmSWtX77aMxfDXK3XZzZaqd91eDVziNFUfNXDAeCqcBouIwBr4w9OCPCqZx2BVNwpjlQTRHyumUByRHqFpmOc2vZUvkYLS4VpE9WcmFn16xXCJdMxVEWFCyoBbN8_TKCtOrpAouiCaosqCrQkUmLudQRPj_rdlmNouZkgzVotG3fEV6SRlZwNiNWMNey4iCeZwW7LvH5dfHtcnudFQYAm2MSpJtzrsYTuu8O1sgatwNQIVLGj5cMN2sk6CKLqOWDYZaluKUlqAB-drIGb3I0ihRUWjHFerYnewCtKrwoAGPlqRYpVdcXNGicppNHckaUdKlMJAqA6oh4TiDORDx3D50Pf_QGxza_cn4QIm7bNixfvwGUAM_8lniXCfwnzsYwO--OzhQ0iAbx2xRcgyiHLo43sRkHtOiOEEYrpfovOydHsfR6XGkqoSIwczNL6wUKo-i07-l-QUwlqzSTV5MyWtQbuC5lWTct21iEQd_Hx8BlqdP2nBlqzRhAtMLGsdkSv7okOeO7x0QfzC0RuPJiLc-PtrEpw0-5ehV6GGMYCb-r1xcW0U6BytkYaiw-IQFsxIFFjToSe_XV-fkjPz149vzVz1SrGgGZcU_NjRnPYINTnqbPJ7-wfV-__333qd6dx0C5rfA7JAtkN8VHoYola6lC_uRZZ0GaWLCdRulyfAebNJ92Fwi5MocumQ5EZ7N91omFHW5DvhP33YOhK4y2VdfZ0N1MKAWkoZ7rGGrQYcXPriFF77gf250UzXf9tokP2APc9ixifHvn32oS8J5vlnPHuZmGRfonGZRSWPJtB8QztqDicgCzcTLiF3JtmBe0O4pN8dY3oomDEPJCDjAC_7jPmq5S0sMFRSfpRaDjyQzD3-0odDdohmoWkueJKmhfpQgyH2fNHTKcx_ww_CgRJA56O58rgzEC1qyZZpfk7N8voouGdjlrRYlXaoWPp5OLhvA6KxqYFDWJTfb0VwiYqEayjsoLUhVTsAQsVxc9jU2mtNNuUpz1R3w5IwXNMnzVC5AfUoce6BP9kS1OSHN7YUBssv5QrdI_bUP1ESCGcF1EQcKw0M5DP9mI-d52H-RgbcP3A324YhzKP4Dd3R4oFSGbGig2u3h83P3ZWpkbWhOqSrlp4G0CZdCqgys7NBwA6671unDOdfosgujb1dpro0_nSptJLjEcx0orIkvvLOazPF9XCfoEQs8WM71yT04f0hEPxPDkbk9P6g_uc_ksrKmn4P6Oa-vhKOAyb-4DlRKkfCtcfdaUyyBXDCTrUW-B-qOWuvdWmbSBrn_0uLSIWZTE7LnpFa6xGQ9L_0qhtBgUH2kvt3QswUDpbzSexBkAS8JoiQT-23EeQ6LmsA-LyTnK3A1XqGj3u8rFSRa4LJRgcRKuzmqp6K8lgEGEGVhMebWCiiM1TRWsE1D59ZrAjoDbSiCKjthZixOr5owlRhgTWCqY5jfXFwLlI35UAswbqBpVAQCd6ncrDlyl8nyy2jOZulnsnJPerh37ZGIZ62d6JgNFHCNKd9PtlwiQ-ksArZcMFhlbALOqpMef2GhlW5KVDMNIC5nXCdGTh5Uo4qConWPrPyT3h8d18Mt9IiMXCeOLTazrSMrr4RqxQXcMrJXaxrdYmiw1tGiWTQu72d8OI4_sc90ncUMNYscods2wlXOxMq1h61jPAtDMHLFt48yTsHxAhGysii5n2ES11wn_xUtyhUpykPyl7QgZ8mSxaw4JB8_nLVNK4-o6DU0BHk9pgQ4sDjpPeud_gpeCaHkrxuwx1txHZqz0hLrgEdkjo_oqVrmcuXUXCJHQxCZ4-z0ZZSD2iZvQFGx_PgoOz1euQpztgrApRWxnY8FeZtMyfORPTrA2JTljD3n-Gjl6sCO8jhqgZ2Bz3t5u1jAlBG-2zmP1gw7XCLQ06k3tW1y9rpPzlMCKgxe3r0mGi06qhKtjCl2h6cNDQHsoHVDM9SbAxGuCLi61emDHjoHtg5eR6D2hKpZ03wZJcqfFca-qY52mpvRNlxc09g0PUHPOVBN65aqs1wnz98J3owz2rJDx52AbRscDofQ6-hAujTIlYKlysFdOat0zdIk1kcqAu-ueBoyb82WFKEs9Hxznk8sjbm71XxHqA0BaZQg8GOL3IjDrbtzMfc4P3W192QybQcW3C8psIDOS9wbYPy0khBfJIxzNni7gFs2y9X-HoU6zNMMj2i65_CeYiDfMX0dgTfHv5dkAVdya-8ZaQdumZGx6_pcInyBPq1udlfb45tCw7YODZdpdhdcJ5ZKwqTMKxETuq5gGc1pqTmmj3WcSiVpO6KOzR-WVtkvLDf84VlmyMIW6Qmch3fXQG-odpDsPj6SvcdHsv_4SB48PpKHj4_k0eMjefz4SJ48YJLdHabEfsA02_Iu5FwiTctGdLF2qKQvTVaAGFxculdcJ6s6fxe_2seLuTnRZ3H-s4ezhbO0fd7Sd1wnB9pjFVtkOdCtXFwfQOYHfuDrDFwiE_qGHIkm7A9k4d2kMHCviuFPlTtmjqkjijFSF1v346zbBN993mm3gO7i7OQ-MlwiRbeYe1wiTyG-f-JcXBn67RT9vZZ6JfC-d-j6I_g7MY7lXFy_yb36HPpCihVREkZHzuvJq9iXzAK-eUHwG8xN4IetVHbcXDA2V4TfHFTHknA0P-dpdi3iizoZXDApfaGKyb__RTBEPN_kOQawrxnNPxEdQuXRY8CKZy-feqf6lW8GP2HAtE_O4phwXFwFyRmGmlnYf_oEQQUNaLZ0tHqLLH0OoezOkAfUouTGdC_vfk7gouSecr2-bcHtuafH8OIMqBbSEEfrqDQ3rp4jquUZVMATPeVhRZDwCLY-DhtLTJijsU7zKqgOQ3z_6uwlef32_Sv5zgGNZBOJX-2ksXqWfpaaWG7j1ZmSW9UrDPzONMinVWWYjyuo-tAwpOzYJkwQspJGcbFTeXh8TspA5EoCE2jOqtM74OAHLFErx-QXSBOFrgseinNlxjJL6CxmoT7GBHkQKR9SOM70C9dxYk3C40v5iAk7dCkLz-my4DOJSiwqNGbeGQqPECvkkMxziZj6BIScSCl2L8QbYvsqzOLWSJAYDJzU_D_Xb4EEAjFEpsPQbTBAWg2mrUfBGBPMGVUzexN73W9n7zZcJz2Jdxe3utncNlnSQamNop21dgOqydZmfZOlzV622Ykp5Fmal4s0jtIgy9PfQKOpFaEOIN6JYvLSKJ6Y7XAh6tXji8WoVHYFxbVHzmIYamiSWEHIympxoTp_LwqJpKLYRqyaKX0w4RnGlTZA8duGrrQL5rfpU89WzEi6VIz6wwnZQmsOflgJsjIQH2pR-QnOFpAxMrfi6xu6Zmq-mw3u5B6Hvu9QbKJS3XLced9hWL_vkKRl5x0OvO0QWRmYW87ur2ph0YZH_DWCGd-HNdDmRRzJtXZvPLEVT2aM5Z38GNT5IdfzDnbwzHRrU8hv9OxkhbsXK8ZVeuItmCE-FFINZC9u0Ly4O26I1NH6yX9cJ1u8_RbPsFo8f5G471NYxoo76UVcJ29Gdd7M43QT3iV3_P24A1xc-Ds44uTPmyguHwJf7uAGVRmtu5eUdFoa5sb02bTNGdfAbvTqPLsGHyXLmOF1p2BWJltZXFzupANYWN5akCxbwOTvtFxcaCUERLu1qjAYFmqis6cZXQfg_ea0NvXmN8WUPE12Qtf08oeLKBYOXDAycVeLuxAtGCVbZ-X13d43dPmCm4F3thBmsFOeODiM0ZwheWWNz5AldtRyT1gdMooWO2bMwNmcM9QfLM_T3Lf9YBYtuxjpOOLo0FTiHfp9olYqz5AsrPTGy5xG4vw3qK6tIRi7QChcIq_ev3_7Xi1xDSivYOukZzwQXkUFyYDJZE2vyYpeMgKGOiFr2NWGJM1JyGLYq4d98mdGik3OSJmS-YrNL8h1uslJkbEYhrPsK2p1Z_U0TlxcXCe6Cvv7KffEoHMr4xL1gGMH-r5kPUStLov5Krs1gd1_oa6NY6PjlXf6Ji1XePNxgYw9PoKS4-z0Q5rn14dktilJXCLrYQcEsxjKSeT4CEaBij55FzNYs6TMrwld0ighVxFm-oGIkzBaLBhGoMgFu75K87DoY8abWnBFFDJ1M6OZwFqrl3NcXKufVPVcXOGtmYh71Hc6g1aoXDAFKWvA4hqpKJKmon6jZdgCgbs77Qma6PwKWMm2gcuk_ypN-TY2n28P0xjAbJbxDM8miNERu1S73xoEjkzYU1Rdhd6c-8ra8C05XCdJml2RWxok1PAoMNdUehTbkMqGglxcPdObipvQotkBaVGLYA-s7h5Y8UwmjuYXeyP19uNcMLYDjZjcgFYclsmldzW3RBqiJYxGFZUzJt2qbJLayboNiCxPw828tDLApJaD9ilcXN6PcGostF5WczvvmxCysq1Xrx1uk5S1bTZ-mQcFqcyBpig13C0MTXIbgQFlAr8_4nUq8sJcMFYuQh3Dqlxcx2LFwmiOw-hSJd9uEgsT74QeVjYdL2LXYdqqeWQb8zg_HR_ha71RwTIeIDjVlStH1ckrn73Tj29evnpPXrx98-H8_ccX5__z9g0oSYcD-xqRvlwi2gPVCRaHa0xp5kmJ3LgCYwlzyUBdfijhudwkLPwPQOUjKtU__628xDp7bvx0h3MP5q9GwjfZwPZD6Nvlwe36jqqRAuc22TUvCnD0xAd8XCcjQPanaI0am2zy-LlmFP-oTF-kd9EsKjiLoOl_itS2k3dpBg4UUmkfwt_o0IUHFx88ePDwwYcHHx8G8DDAhyE8DPFhBA8jfBjDwxgfJvBcMH-j3sEvT588fTJLw-svT5_ID-BMiQ2lXCLJWjx_ffqkLwXrkPQrKYM2PBVOUDklPUln75B0ZeHVMSokyOUpGdrZZ6g38uigbCDKavlzU-LyUpNO8Sy9bigyXDB0oTPmpbzLK9kBsKsF_4gDXCKl2yMWxLreNrGe6JVLyJQ8G4_He5Feo1wnwUBvLDrHn36b6sEJk1wiPSV0VoAOLRnva8GH9Ad4JvAHBNx8tS5QwVVJjlPCH1HB_u9zC-AOqoK_iwLVcp3-83btils1S2_T6hub4OzioeOca-cvW9Lii9kMo1wiiylIeJTwyZ7hNzuwufKjswW_61KZnwle6DVdN7cBxLf-6tJkE9oxoIt4s5QwWQsM7hN1r7hp0ohI_aRBhoQ0fI1cMDSDWw31PlI2U5Q4ZnzEMr1OvutD77bODCT1HIrJa-70FrX4ww6WYL9GG3PzXFznCwJiqVX53fzbLAjIvWuDDoXzVywvlF_eBK3TYZttaoMUTTQdtqRDu_SY1h8lfEMsvS0P7dWSaw-Uoer-6YB_nK76bLa8dcFvChmXt8e2utk6z4XdgsJrJk74cFpq2C2xA2jpokLV7GHkdvUwavbArWd7ByN72NaBP_H3HIIh7Tt6cFuHMBh0DIHf7lI91MSmvQ9_0NrH0N6_j6KM1mkC5nBXH85o0taHM_Y6OIVX8_AynQ758J2D-GdcMGpx_YiLnhlXk-f66nqC4aEYX9WTtb9tV-qmaEj43abGkaRRi55FUdK8bHxVvgHCkrBx_VTkaHSQONkaQCBducoNFK6W2UrkCYg4TsHTWWacYyjZNKSX-t9CWKdhVTnc_sq9qpvIL2yJUJ0o48eu1Ycs0GmWSWxVvfgklv4oBf_OmO5PX54W6Sy63bAt0UDu-goFhRufHdHrJqghBXLfXjSYVXNmNR2-_OxSCGwK1FwnSNOsgvn6_4Wt9i8';
	$theme_options['Infostack']	= 'eNrVPWtz2ziS31OV_4BV6q7iOlPmS89xfJtNcrNXtZPkEqf2pq6mWJAISRxTJIuE7HhT-e_XjRdBipIVx07sOBmTQANoNBr9QoNDp_4gnH6pppNpr7pIsnme5mXvl2o6mvaeLRYD5oX4Npz2Unqdbzi-hNPeVRIzfPTG095ik6YRFkQsZWuW8ar3C5160y_J1JVNV4zGDHr9Cg083VPErwvRx1wwulslXFz2B2jQ-JJmcxbxFfQm8KkUQjFb0E0qcPBcMIkKarOYltcNpAM3GAxi3ZmBcZYlawIugsVgMcY33532ZimdXyTVKpptOM-bdPBm-CO6hNdlms9oGs1cMH5Z5pssxumOkIYwk2RNl2Im0KVqLoqS2CoEkpSsYJRbZUDIXCKvEp7kmVXqwW_KOZ2vkLBWBU4_-Zc9Egzent5oMZFEhwGTLGPlY0IaFi_NkW-S9dLufFxclwOK0XxT8XxtAfg-9CkKI1h6ThOcN7BcJ18pFDxv5IqeXDBwyaAWFnORI6IUUf9cIqa6oOskvUYwwONdwTLykWaCD71cMJgFyLgpnBrIhybndJWv6TH5Ffq8hN8VNHAqwHOhZndJy4RKgoyQmMtNSkvNzJx95g4voc1cIi_t-cD4iJ2jKQdYewPRCrcSzM5ZsWS54qrOH-seU8Y5K52qoPMkEySEBm4X1QfxcDAaaprQNHUQVbmTRadyeUOJiWKGZZ4vUyb5yxWYXFw4pldAGjbdxSq_ZKVZNQPhWHOHTp-5rlxckGEDyDRGFEdsRt1AQAH2Ky9CmQLTMis32Vo4XFyoc-DNNE02a_JPNtu9eoDdS1ib9Jj8naWXjFwn8xvWD3oZKqS_ce1Cd_fahYNvXzvXd2N_uH95kGL-o6VYsIfbQ_f-KBY8Xort4bHgHnksfLQU8_fwWHCPPDb4yRT7Pj3kuz-HasNHTbW92vueqOZLI_ynbs3glgpzD7kGtyHX0BsG9EYmqzazmyl2mG14L_wFQ2-KgpVzWrHbMNot1MDYG9Px4kZGQ6sbbMeHSbafYVTvppZcJzzpJeOPT2EGd0utQ4QYtJXOuaHW8CFSa__Ed07PD830eF7Mco4ebEHjWHWALOppB3fNYphfZJHD5uSxnrQKyEQ84TjKjybYd27I0X52XDAcFzNaOnYEohUkUiDRbBkZbhtL1xTDQdqdlDD7QyOeC5isOC-q6ckJZ3P-Oc_6XCJEBS-rNbTj_Xm-1lVOTDk9uSocJQ1PBGilq09Ev9UJurgpvXbEAuFkZsv-n8XysCAM0CzLnfr99tEYsRuVt93emdrz_mrRCpexpqgdwEPmtEB0HMbqL44D-KODaQJ2RbM4ZWWUzBFzOhUByRGKlllJy2vVEimYLK51ZE9VCuanV6zK10wHERaULKhDyzK_cuL8KquDC7IJiiwYqtKRics5FBHxX2e2mc1SpjlDt2iNrV4RX8ITBwi7kXs46JhRNE_zin33vMLmvDbFnc4KQ6CtWSm07XWX0-lcXHdvC0TPuwWo-1KKD0A36yyqo8soZaOh4aU0pxwkoNgbJaMXRZ5kOgrt-VIc-5NdgE4dHrTgUZNUq_xKCFoUTrOpp0gjS_YJDMTKgmpxOK5gCUg8d4_9IDwOBsdufzI-0uyuGu7ZP2ELqNU_0ln1T-CvPxjA774_ONLcoBqnbMFFD4LJYOTTTUrmKa2qFwhcIsQSnfPe2WmanP2eb0pyXsJQLCZ-SP4O7xX5yMrLZM7I-zK_TGJW_uX0BGBPTzbpWWs6JSp_M5o3giX8P752qnwO2sLBkF71R_f4BMBW0DoV5oNA5rTiZZ4tz04TDS_ZvljlGQOQk-TsnKYX5DxcJ28-gwHMyfT0RLUhp6BxMzMOS50s75255LkXBkckHAzJaDwZAThAne2azh4-CztgdrAY0GCFZ1wiWrIbJsNxVNlevTSx4fbrpsnwHlTTfagkpMochmQlkQbO9yoo5Hi1HcRP3_WOpMiyydfcbkN9PqD3k4F7rNGrwR5jfHALY3wh_txorRq6HeQrP2BDc7jHlwnvn3woS-J5uVnPHqbPjBt0TouE01QR7QdEtQ4gXCKSwBDxMmFXqi1NU1R_2tqxtrfGCRqG0r1AcSzpj-7UcpeUGGoosUodeh9RZgH-GEVhhkU1ULdWNAHFVIsfzQjK_VOKVBvwA3EmHnEEmYPsLudaQbyinC3z8pq8LOer5JJVU7LVgtOlbhHiIeWyBYw2qwEGYc2F9kwWCYv1VN5DaUXqcgKKiJVqrLHVnG74Ki_1cECTl6KgjV6gUwKaS-INQnPAXCer7QVpexkWyC4bDK0j_c890gsJagT3RRrpHh7Kmfg3K7kgwPGrAox-oG50CEW8Y_kXrNLhkRYZqqHV1W5DXxy_L3MrecNQSldpqxO4TZoUSmRg5R4JNxCya50_nOONfXph9O1cIs138WevSBtJKomUBwp74osYrMFzwv0EOeJsylRQfXIPxh9cItEv5HRUis8PGk-5m4JX1vRz1HVADsxRweJfXFxHOrNI2tboxDYESyTBVGuZ9oGyo9F6t5SZdEEevrUEd8jVNIgcuKi1LLFJL0q_yim0CNScaei25GzFQCivjA-CJBAlUZIV0u3GPs9hU5N_5mVMzldgarxBQ73f11wiSLbAbaPjibV08_RIFb9OtYmQZAtQHLCLmyBt_eY3a1wiOgMhKEMqO2FmLM2v2jD16mNNZEthWNbS8JFroabjD-hbCm3mKd9VOr-z_DNZ-S9A0aZpjyRcImfthYnYQIEQlOr9xVZcXCifJUANXDCrdUwkKPSiXCdeWOzkG47SpQUk2OuFlZEH1SiZoGjdI6vwRe8_PD9Aj3ZExhPP7f2xc2b8SkpU3LcdM3uzpsktpgZbHBWZQ1N-P_PDefyVfabrXCJlKFDUDP2uGa5KJjesO-yc48s4Bt1Wffss0xzsLWAhp0iy-5kmhlv-K1nwFan4MflHXpGX2ZKlrDomnz6-7FpWEQcxe2gI_HpKCVBg8aL3rHf2KxgjhJL_2YAabkdQ5rRk3ClVqOUEgx_0TO9utXMacaMhsMxpcfY6KUFak7cgn1h5elKcna583XOxijDEgvuDfKrIu2xKno_c0RFGphxvHHinXCcr3wRYtKHRiBcNQjHKu8UCo03CyTlP1gwHXCIw0lkwdV3y8rc-RnxAcsHL-9-I6RbtU9WtiijuD05bEgLIQZv6ZTjQmMooRSSkrEkeDNAmcE3oOgFpXCdFzZqWyyTTZqzU8W1xtFPLjLbh2jqmbVwwBt6RbtpUUHtHCsKd4O0oo6sG9PwJqLTB8XAIo46OlCWDVKlYru3albfK1yzPUnOgXCL73RVGQ-Kt2ZJcIpSDBm8psomVDve3mu-IsCEgTTIEfmwBG-V73pllecDpqW-MJptoO3pBN0mDRXTO0SXAMG7NIaFMFxdkCHYBd_jItVuPTB2XeYEHNPvX8J5CH9-xfHvibV54L6kCvqLWwSvSDdyxXCJj3w9l1AJNWdPsrrzim1wiwq6JCPO8uIvzSs1hiuc1i0lZV7GClpQbiplDHa8WSUaP6EPzhyVVDovGDX94jhmSsIN7XCLv4d00MH7UDpT9x4dy8PhQDh8fyoPHh_Lw8aE8enwojx8fypMHjLK_Q5W4DxhnV92EXFzkOW8FFRtnSebKZA2IwaV7NbLqY3f5q3u-mJmTfJbHPgcYW7hK28csfX9yZCxW6Vwiq4luZfpAZ2EURqHJH7Khb0iNaMP-QBLeTeaCsKoY_tSZY_ac9kQxRvpa62GU9dvgu4853Q7QXZSd3Ec-pBwWU07U4cP3L5yvQr97Wf-grV4zfBgc--EI_k2s0zg_bFOvuYah5GKNlIIxAfNm6iqOpXKAb94Q4v5yG_hhC5Ud93_tHRG2XCe1Z0t4hp7zvLiW8UWTA-AC5q90Mfl3hPiF-K43JiZyKoLG0BmetPzROzOvwgf8A-OkffIyTYnoolwiJcMIM4v7p7Py7OkTBJfDo8YygeotjMwRhFY5QxFLS7IbE7yC-zlzS7J7yu76tr12oDuPkcUZYC0ZIU3WCbd91sCT1TJPYR6JDE91ThFlXCJ4bQ7AxqpcJ8zKWOdlHU-HKX548_I1-e3dhzfqXVwwWuklqn_tRGP1LP-shLDy4PVxkl_X6x7EZWlgTadOLR_XUM2pYTTZc22YKGacJmm1U24EYk14JJMvgQi0ZPV5HVDwI5boTWPTC7iJwtCViML5KlWZZXSWstgcXFwCP8gkD8UcL82LEG9yO8Lja_WIKTp0qQrP6bISK4nyK6lMz2IwZB7KNYVUZkvC9Lcf1EIqtnsl37C3r1Ijbs0EkcGYScP088MOSEAQo2MmAt0FA6g1YLpGlISxwbxRvbI3kdf_dvJuUzJQ_e6i1n4ydy2Wsk0as-gmrduCapO1Xd8maXuUbXJi7niRl3yRp0keFWX-XCdINL0j9NnDe1lMXlvFE7sdbkSze0K5GbXIrqGE9ChZClONbRRrCFVZby4U5x9kIVFYVNsd62ZaHkxETnEtDZD9tqFr6YIZbebAs7NnRF0JRvPFhGJhJIc4pwReGcgvtOiMBG8LyJqZX9P1LV0zvd7tBndygcNcXHSoNgnX1xt3XnQYNi86ZDnfe3kDrzkkTgHqVpD7q95YtGUMf01gxQ8hDbR5lSZqr90bTVxcTZMZY-Veegya9FD7eQc5RC66s6nUx3l2ksI_iBTjOiHxFsSQXwipXCdyEDVoWd0dNWSyaPPQfy9ZgsM2z7DePP9Qfd9cJ7OMNXXyi720GTVpM0_zTXyX1AkPow5Q4XdGS_K3TZLyh0CXO7g6xZP1_i2ljJaWurFtNqNzxg2wG626wG3AXCfZMmV4zyma8Wwrb8uf7AGWmrcRHysWsPg7NRdqCQnRra3qHiwNNTH50oyuI7B-S9pYevtjYpqfJjuhG3L540WSSgNcMIm4q8VdsBbMkq0Lfn23Fw19seFmYJ0tpBrcy08CHOZor5C6qyZWyJHOtPIJ6_NF2WLHill9ttcM5Qcry7wM3TCaJct9hPQ8eWpoC_E98n2id6rIiayc_MZbnFaq_DeIrq0pWF4gFJE3Hz68-6C3uAFUd69NmjOeBa-SihRAZLKm12RFLxkBRZ2RNXi1MclLErMUfPW4T_7GSLUpGeE5ma_Y_IJcXOPdu6pgKUxn2dfYmsGaiZu4T0wVjvdTbobB4E4hOOoBxw7MRclmdFpfDwt1PmsG3n-l74tjo9NVcPY25ytYDrJAwp6eQMlpcfYxL8vrYzLbcJKpevCAYBVjtYiiP4JRoKpP3qcM9izh5TWhS5pk5CrBJD9gcRJcJ4sFK2FG5IJdX-VlXFz1MdlNb7gqiZm-i9HOXW3UqzVu1E_qeiHw1kzGPZqezqATKkJGKlqwuEdqjJSqaN5hGXZAoHdnLEG7u7AG1rxt9WXjf5Xnwo0t59vTtCYwmxVcIrmzDWINxC6199uAwJlJfYqiqzLOeai1jXDJBUpK7cq00iijlkWBaabKotiG1DoU-OqZcSpu6hbVDnCL3gQH9Oof0Csex6TJ_OLgToPDKIDtQFwiZjd0K8_J1Na7mjsyA9GRSqOOylmL7tQ6SXuyfguiKPN4M-dOAT3p7WBsCl-MI40aB7WX03bnQxtCVXaNGnTDbTLecLPxkzzISLwEnJLcMrcwNCl0BAaVCfz-hBeoyCsLWJsIzR5WfJ3KHQuzOY2TS513u8kczLmTcljr9LOnT1owXdVcIrqNKZx_nJ7ga7NRxQoRIDgzlStP16lLnr2zT29fv_lAXr17-_H8w6dX5__97i0ISU9cMIemI3MptAeiEzSOkJhKzROO1LgCZQlryUBcXH7k8Mw3GYv_Al2F2JUeX_zWVmKTPDd-s8O7B_XXQOGbdGD3-fPtUuB2fUDVyn7z2-SaVxUYevLLvZMRdPbXZI0Sm2zK9LkhlPiaTF9mdtFcIqkEiaDpf8qsthfv8wIMKMTSPYZ_ybEPDz4-BPAQ4EMIDyE-DOBhgA9DeBjiwwgeRvgwhocxPkzgAf4lvaNfnj55-mSWx9dfnj5RX76ZEhdKZX61fP769ElfMdYx6ddcXAZtRBacxHJKegrP3jHZl4DX7FF3glSekqFbfIZ6K4UOygayrJE6NyW-KLXxlM_K6oZcIgvAFHpjUSqGvFIDXDC5OvofCUDEdHvGElk_2EY2kKMKDpmSZ-Px-CDUG_hkGOhN5eD40-8SPbhgiqWnhM4qkKGcibEWYkr_Bs8E_lwwg9uvzgUKuDq_cUrEIwrY_33uXDDcUV3wuyzQLdf5v27XrrpVs_w2rb6xCa4uHjzOhXT-ssUtoVxczTipipQCh1wnmVjsGfg1F9hcXNvRxUJcXHOp1c8Er_DappvfAhKuv74m2Yb2LOgq3SwVTNEBg36iGRWdJtMRaZ40qJCQgW8ggGpwq6HxI1UzjYlnx0cc2-oUXh9at01iIKrnUEx-E0Zv1Yg_7CAJjmu1sZ3nJl0QEEud2u4WH2VBQGFdW3joPn_F8krb5W3QJh6u3aYxSdnE4OEqPIxJjxn9SSYcYmVtBaivlkJ6IA_VN04H4qt09fey1YULcUnIuq49dvVd1nkp9RYUXjN5wofL0ujdkR5AxxB1V-0RRv6-EUbtEYT27B5g5A67BghcJ-GBU7C4fccIfucUBoM9UxAXu_QIDbbpHiMcdI4xdA8fo-LJOs9AHe4awxtNusbwxsEeSuGtPLxHZ0I-wnOQ3_9vxPUTwXp2XFxNnevrmwmWhWJ9Tk_V_rldaZqiXCIR15paR5JWLVoWFaclb31OvgXCsrh181TmaOxBcbI1gUiZcrUZKE0tu5XME5BxnEpksswExZCzaUwvzf8EYZ3HdeVw-_P2um6iPq0lQ3WyTBy71p-uQKNZ5a_V9fJbWOYzFOIDY2Y8c11aprOYdsOuRAPl9VUaCh2fHdHrNqjFBcpvr1rEahizBo9QfWgpBjJF-tujeVHDfP1_-bL3qg';
	$theme_options['Overlay']	= 'eNrVPWtz2ziS31OV_4BV6q7iOlPmS89xfJtNcrNXtZPkEqf2pq6mWJAISRxTJIuE7HhT-e_XjRdBSqIVx07seDImgQbQaDT6hQZDp_4gnH6pppNpr7pIsnme5mXvl2o6mvaeLRYD5oX4Npz2Unqdbzi-hNPeVRIzfPTG095ik6YRFkQsZWuW8ar3C5160y_J1JVNV4zGDHr9Cg083VPErwvRx1wwulslXFz2B2jQ-JJmcxbxFfQm8KkUQjFb0E0qcPBcMIkKarOYltcNpAM3GAxi3ZmBcZYlawIugsVgMcY33532ZimdXyTVKpptOM-bdPBm-CO6hNdlms9oGs1cMH5Z5pssxumOkIYwk2RNl2Im0KVqLoqS2CoEkpSsYJRbZUDIXCKvEp7kmVXqwW_KOZ2vkLBWBU4_-Zc9Egzent5oMZFEhwGTLGPlY0IaFi_NkW-S9dLufFxclwOK0XxT8XxtAfg-9CkKI1h6ThOcN7BcJ18pFDxv5IqeXDBwyaAWFnORI6IUUf9cIqa6oOskvUYwwONdwTLykWaCD71cMJgFyLgpnBrIhybndJWv6TH5Ffq8hN8VNHAqwHOhZndJy4RKgoyQmMtNSkvNzJx95g4voc1cIi_t-cD4iJ2jKQdYewPRCrcSzM5ZsWS54qrOH-seU8Y5K52qoPMkEySEBu4uqg_i4WA01DShaeogqnJcJ4tO5fKGEhPFDMs8X6ZM8pcrMLlwTK-ANGy6i1V-yUqzagbCseYOnT5zXbkgwwaQaYwojtiMuoGAAuxXXoQyBaZlVm6ytXC4UOfAm2mabNbkn2y2f_VcMLuXsDbpMfk7Sy8ZT-Y3rB_0MlRIf-Pahe7-tQsH3752ru_G_rB7eZBi_qOlWNDB7aF7fxQLHi_FOngsuEceCx8txfwOHgvukccGP5li36eHfPfnUG34qKnWqb3viWq-NMJ_6tYMbqkwO8g1uA25ht4woDcyWbWZ3Uyxw2zDe-EvGHpTFKyc04rdhtFuoQbG3piOFzcyGlrdYDs-TLL9DKN6P7U84UkvGX98CjO4W2odXCLEoK10zg21hg-RWt0T3zs9PzTT43kxyzl6sAWNY9UBsqinHdw1i2F-kUUOm5PHetIqIBPxhOMoP5pg37khR93sXDA4Lma0dOwIRCtIpECi2TIy3DaWrimGg7Q7KWG6QyOeC5isOC-q6ckJZ3P-Oc_6XCJEBS-rNbTj_Xm-1lVOTDk9uSocJQ1PBGilq09Ev9UJurgpvXbEAuFkZsv-n8XysCAM0CzLnfr99tEYsRuVt93emdrz_mrRCpexpqgdwEPmtEB0HMbqL44D-KODaQJ2RbM4ZWWUzBFzOhUByRGKlllJy2vVEimYLK51ZE9VCuanV6zK10wHERaULKhDyzK_cuL8KquDC7IJiiwYqtKRics5FBHxf2e2mc1SpjlDt2iNrV4RX8ITBwi7kXs42DGjaJ7mFfvueYXNeW2KO50VhkBbs1Jo2-sup7Nz3b0tED3vFqDuSyk-XDDdrLOoji6jlI2GhpfSnHKQgGJvlIxeFHmS6Si050tx7E_2ATp1eNCCR01SrfIrIWhROM2mnlwijSzpEhiIlQXV4nBcXMESkHjuHvtBeBwMjt3-ZHyk2V017Ng_YQuo1T_SWfVP4D9_MIDffX9wpLlBNU7ZgoseBJPByKeblMxTWlUvEESIJTrnvbPTNDn7Pd-U5LyEoVhM_JD8Hd4r8pGVl8mckfdlfpnErPzL6QnAnp5s0rPWdEpU_mY0bwRL-H987VT5HLSFgyG96o_d4xNcMFtB61SYDwKZ04qXebY8O000vGT7YpVnDEBOkrNzml6Q85y8-QwGMFwn09MT1YacgsbNzDgsdbK8d-aS514YHJFwMCSj8WQE4FwwdbZvOh18Fu6A2cNiQIMVnoloyW6YDMdRZQ02G-qwtREyBqpbM02G96CY7kMhIU3mMCQriTRvvlc9Ib-rzSB--q53JAWWTb7mZmuQGXeTgXussatBhyk-uIUpvhB_brRVDd0O8pQfsJk57PBkwvtcJx9Kknhebtazh-kx4wad01wi4TRVRPsBMa0DiIgkMES8TNiVakvTFJWftnWs7a1xsrYawEv6ozO1Txjj4Z61Sju0PqLMAvwxasIMi0qgbq1oAmqpFj-aEZTzp9SoNt8H4kQ84ggyB9ldzrWCeEU5W-blNXlZzlfJJaumZKsFp0vdXCLEI8plCxgtVgMMwpoL3ZksEhbrqbyH0orU5QQUESvVWGOrOd3wVV7q4YAmL0VBG71AXCcERA02mdSne7J2_3r4DZi2BTYySmFy7I9BKwyCI72MoERwV6SRbv9QzsO_WcUFAY5fFWDwA22j_fRoRldQRihYq_V-u16cti9zK1fDEEdXaSMT2EvaEEpGYGWHSBsIYbXOH85pRpdcIhh9uwzzXfzplGEjSSWR4UBBLn0RgzXYTHibIDicTZmK98E9WHuIhCPWvF_ISam8nh86qvI0Bd-s6eemeAg9zSgVMMLFdaSTiqRZjf5rQ6pEEky1lhkfKDgarTv9vMku4H3unu8dy__A3RseGWaRi2twOXCNa2lir4Eo_Spn0aJRc7Kh25KzFQOhvDIeCFJBlERJVkinG_s8hz1O_pmXMTlfganxBg31fl8LIdkCd5GOJtbyzdMjVfy6jjJIjTF3VIyrCdlWc36zJqIzaCbjKnthZizNr9owNR9gTWSLY8CpNBzlYkrUAlQbiB0dhEAHUyg1Tzmw0gOe5Z_Jyn8B-jZNeyQRiWsvTNgGCoT4VO8vtoJD-SwBolwwWK1sXCJBqBc98cJiXCffcJQ5LSDBZS-stDyoRnkFReseWYUvev_h-QG6tSMynnhu74-9M-NXUs6OXCc7Z_ZmTZNbTA22PGo0h6b8fuaH8_gr-0zXRcpQwKgZ-rtmuCqZlOTucOccX8YxaLzq22eZ5mB2AQs5RZLdzzQx5vJfyYKvSMWPyT_yirzMlixl1TH59PHlrmUVwRCzh4bAr6eUXDAFFi96z3pnv4JVQij5nw0o53YYZU5Lxp1SxVtOMAJCz_QmVzunETwaAsucFmevkxKkN3kLYoqVp1wnxdnpytc9F6sI4yy4P8inirzLpuT5yB0dYXjK8caBd3qy8k2URZsfjaDRIBSjvFssMOQkfJ3zZM1wIAIjnQVT1yUvf-tj2AcEGLy8_42YbtFMVd2qsGJ3hNqSEEAO2tQ0w4HGVAYrXCIhbE0GYYCWgvEeFgkIPSlq1rRcXCaZAvGk5m-LI1vfNJAabcO1VU3bEgy8I920qac6RwrCveDtUKOrBvR8MKS9wfFwCKOOjpR9g1SpWK4N3JW3ytcsz1Jzqlwi-90XS0PirdmSXCKUUBGlSClW2tzfar5cJ8yGgDTJEPixxW3k-dbd2ZuHBB6M-WQTbU8v6C9psIjOOToKGMutOSSUOeOCDME-4B3uSD0GMnVcXOYFntJ0r-E9RUC-Y_k6wm5eeC_5Ar6i1sErsht4x4qMfT-UwQu0aE2zu3KPbwoMuyYwzPPiLg4tNYcpntcsJmVdxQpaUm4oZix-rxZJRo_ok_OHJVUOC8oNf3iiGZJwB_dE3sO7bmDcqT0o-48P5eDxoRw-PpQHjw_l4eNDefT4UB4_PpRcJw8YZX-PKnEfMM6uug65yHPedYRh7k3WgBhcXLpXI6s-fZe_ds8X03OSz_L051wwYwtXSQZAB4Nj_dft-5MjY7FKF1lNdCvdBzoLozAKTRKRDd2VtzfZhv2BJLybBAZhVTH8qdPH7Dl1RDFG-m7rYZT12-D7T9fcHaD7KDu5j6RIOSxmnqjDiO9fOF-FfjtZ_6CtXjN8GBz74Qj-TqxjOT9sU6-5hqHkYo2UgjFx82b-Ko6lEoFv3hDiEnMb-GELlT2XgO0dEbZcJ9WxJTxDz3leXFzL-KJJBXAB81e6mPw7QvxCfNcbExM5FUFj6AwPXFz-6J2ZV-ED_oFx0j55maZEdFGRkmGEmcX901l59vQJgsvhUWOZQPUWRuYIQqucoYilJdmNeV7B_ZzBJdk9JXl921470J3HyOIMsJaMkCbrhNs-a-DJanX4FIk0T3VOEWVcInhtzsHGqlwnTM5Y52UdT4cpfnjz8jX57d2HN-pdXDBaWSaqf-1EY_Us_6yEsPLg9XGSX9frHsSNaWBNp84vH9dQzalhNNlzbZgoZpwmabVXbgRiTXgkMzCBCLRk9bEdUPAjluhNY9MLuInC0JWIwvkqX5lldJay2JxfAj_IXFwPxRwvzYsQb3I7wuNr9YiZOnSpCs_pshIrifIrqUzPYjBkHso1hVSCS8L0ByDUQiq2eyXfsLevUiNuzQSRwZhJw_Tzwx2QgCBGx0wEehcMoNaA2TWiJIwN5o3qlb2JvP63k3ebkoHqdx-1usm8a7GUbdKYxW7Sui2oNlnb9W2StkfZJlwnJpAXeckXeZrkUVHmf4JE0ztCnz28l8XktVU8sdvhRjS7XCeUm1GL7BpKSI-SpTDV2EaxhlCV9eZCcf5BFhKFRbXdsW6m5cFEJBbX0lww2W8bupYumNhmDjx39oyoK8FoEquKhZEc4pwSeGUgP9OiExO8LSBrZn5N17d0zfR6txvcyS0Oc9uh2iRcXN9x3HvbYdi87ZDlvPMGB951SJwC1K0g91e9sWjLGP6awIofQhpo8ypN1F67N5q4miYzxspOegya9FD7eQ85REK6s6nUF3r2ksI_iBTjOi_xFsSQnwmpXCdyEDVoWd0dNWTOaPPQv5MswWGbZ1hvnn-ovu-TWcaaOvlFXCdtRk3azNN8E98ldcLDqANU-J3Rkvxtk6T8IdDlDu5P8WTdvaWU0dJSN7bNZnTOuAF2o1UXuA34JFumDC87RTOebaVv-ZMOYKl5G_GxYgGLv1dzoZaQELu1Vd2DpaEmJm2a0XUE1m9JG0tvf1FM89NkL3RDLn-8SFJpXDAgEfe1uAvWglmydcGv7_a2oS823Ayss4VUg538JMBhjvYKqQtrYoUc6Uwrn7A-X5Qt9qyY1Wd7zVB-sLLMy9ANo1my7FwipOfJU0NbiHfI94neqVwiNbJy8huvcloZ898guramYHmBUETefPjw7oPe4gZQXcA2yc94FrxKKlJcMJHJml6TFb1kBBR1Rtbg1cYkL0nMUvDV4z75GyPVpmSE52S-YvMLco0X8KqCpTCdZV9jawZr5m_iPjFVON5PuSAGgzuF4KgHHDswtyWb0Wl9SyzUaa0ZeP-VvjSOjU5XwdnbnK9gOcgCCXt6AiWnxdnHvCyvj8lsw0mm6sEDglWM1Vwiiv4IRoGqPnmfMtizhJfXhC5pkpGrBJP8gMVJnCwWrIQZkQt2fZWXcdXHZDe94aokZvpKRjt3tVGv1rhRP6nrhcBbMxn3aHo6g51QETJS0YLFPVJjpFRF8yrLcAcEenfGErS7C2tgzdtWXzb-V3ku3Nhyvj1NawKzWSGSO9sg1kDsUnu_DQicmdSnKLoq45yHWtsIl1xcoKTUrkwrjTJqWRSYZqosim1IrUOBr54Zp-KmblHtXDC36E1wQK_-Ab3icUyazC8O7jQ4jALYDiRidkO38pxMbb2ruSMzEB2pNOqonLXoTq2TtFwn67cgijKPN3PuFNCT3g7GpvDFONKocVB7OW13PrQhVOWuUYPdcJuMN9xs_C4PMhIvAackt8wtDE0KHYFBZQK_P-E9KvLKAtYmQrOHFV-ncsfCbE7j5FLn3W4yB3PupBzWOv3s6ZMWzK5qEd3GFM4_Tk_wtdmoYoUIEJyZypWn69Rdz97Zp7ev33wgr969_Xj-4dOr8_9-9xaEpFwngEPTkbkb2gPRCRpHSEyl5glHalxcgbKEtWQgLj9yeOabjMV_ga5C7EqPL35rK7FJnhs_3OHdg_proPBNOnD3-fPtUuD2fUXVyn7z2-SaVxUYevLzvZMRdPbXZI0Sm2zK9LkhlPikTF9mdtFcIqkEiaDpf8qsthfv8wIMKMTSPYa_ybEPDz4-BPAQ4EMIDyE-DOBhgA9DeBjiwwgeRvgwhocxPkzgAf4mvaNfnj55-mSWx9dfnj5Rn7-ZEhdKZX61fP769ElfMdYx6ddcXAZtRBacxHJKegrP3jHpSsBr9qg7QSpPydAtPkO9lUIHZQNZ1kidmxJflNp4ymdldUORBWAKvbEoFUNeqQGAXFw7-h8JQMR0e8YSWT_YRjaQowoOmZJn4_H4INQb-GQY6E3l4PjT3yV6cMEUS08JnVUgQzkTYy3ElP4Nngn8AQa3X50LFHB1fuOUiEcUsP_73AG4o7rgd1mgW67zf92uXXWrZvltWn1jE1xcXTx4nAvp_GWLW0K5mnFSFSkFDk8ysdgz8GsusLm2o4uFuOZSq58J3uS1TTe_BSRcXH99ebIN7VnQVbpZKphiBwz6iWZUdJpMR6R50qBCQga-gVwwqsGthsaPVM00Jp4dH3Fsq1N4fWjdNomBqJ5DMflNGL1VI_6whyQ4rtXGdp6bdEFALHVqu1t8mQUBhXVt4aH7_BXLK22Xt0GbeLh2m8YkZRODh6vwMCY9ZvRcJ5lwiJW1FaC-WgrpgTxU30MdiE_T1R_NVhcuxCUh61wi_djVN1xc56XUW1B4zeQJHy5Lo3dHelwwO4aou2qPMPK7Rhi1RxDac_dcMCN3uGuAcBIeOAWL2_eM4O-cwmDQMQVxsUuP0GCb3WOEg51jDN3Dx6h4ss4zUIf7xvBGk11jeOOgg1J4Kw_v0ZmQj_Ac5D8C0IjrXCeC9ey4mjrX1zcTLAvF-qaeqv1zu9I0RUVcIq41tY4krVq0LCpOS976pnwLhGVx6-apzNHoQHGyNYFImXK1GShNLbuVzBOQcZxKZLLMBMWQs2lML82_hLDO47pyuP2Ne103Ud_XkqE6WSaOXesvWKDRrPLX6nr5QSzzNQrxlTEznrk4LdNZTLvhrkQD5fVVGgodnz3R6zaoxQXKb69axGoYswaPUH1tKQYyRfoDpHlRw3z9f132_f8';
		$theme_options['RTL']	=  'eNrVPGtz3EZy31Wl_4Bbl6usCrHEa58mmXPpkks-xL46yZWkUirU7O7sLkwsgAOwpHiyPkiyZMeVP3FRfHrYkk6WXY6_5ldg_0265wEMsLvgklwiJVISRWCmp6enp6e7p6cHpG_Znf6dpN_rN5J9LxiGfhg3Pk76nX7jg_G4RU0H39r9hk-OwnmKL06_ceiNKD6a3X5jPPd9FwtcXOrTGQ3SpPEx6Zv9O17f4E2nlIwoYL0LDVww78QPB8R3B2S4P4nDeTBCeEZEq9_wZmTCUBv9hqCDFXkjpRBwxjSiJFXKgJIoTLzUCwOl1ITfJE3JcIqUKRUwiMT7s9oTdF4evT3ujHucaujQCwIaXyaiYUb9EBnvzSYq8m5RDiS6w3mShjMVwIIpojBYmKNxiP0TpOgOG8GYzDz_CMFcMP1nEQ20GyRIWDO730DuzCO9XDCyoMlNMg1nZEv7PeA8gN8JNNAT6H4siD4gsUf4ODvIo8ncXCdsQCaMN6W3Uz2Noc04jFUyoX-kTpcMAarNFmtlwlwwvYDqU-pNpqmos7oSo0_TlMZ6EpGhFzDOQANjFTNbo3ar05Y8Ib6vI6lcXMIZUj5rDqdEzPEkDFwnPuViYzBK9vUcKxA9XCLx_jQ8oHE-GTmErowdkH5gGIwslD4FKG-MJHbogBg2gwLqp6aLaw2Glc9cXG9p4nCiboLI-b43n2n_SgfrZw-o-wTmxt_S_on6BzT1hsfMH2BpC6JPOHeOsX7unNbJ586wjJHVrp8e5Jh1aTlm10i7Y5wfx-zLy7EaGbPPUcacS8sxq0bG7HOUsdZ75tjb2SHLeD9cXGtfaq7VWu9z4prFndP3ujTtUxrMGna1TsOuttm2ybFClswHx3NsM9_wXFzkC7qeRxGNhyShpxG0U5iBrtkl3fGxgjaEGvAdLybb3odTvZ5bJtthTmh6-Qymfbbc2kSJQdvBPE3DIOdW-1wicqt-4OuHB-hFYMFNvRRL3_VcMN9yAXWOHd94QGJdDQRAjyM6JnM_lcNAEHcwcXPp6PKt5CSmR3L7x2HqIxSmAbinaRol_e3tlA7T22HQTKfAX3iZzqBd2hyGM1mlD32SJN5w-zDShQLbZtCJhNhmqJNt3JX65Ehnc4TjGUyaX0STzcIhwLYg1Iv308dF2AISG-TqYpKb5bsKu3AmC6ZC6eHUS_nUWSUQFiZxS_hGIxv-MMo6AnZKgpFPY9cbXCLlBCi7w2B9bxCT-Ei0RA56Yz5vvbySLV9ySJNwRuW-f0y0MdFJHIeH-ig8DIp4XDBvgloGukpkMOFgCEUa-18fzAcDn0rhkC0qfYtXpFdLPR0YO2cMsuwVI3KHfpjQtx6XUx7XPDrTUVnG0qgE2eq88-GsnHdzCUSOuwIocQlbBaDzWeAWgVJUjG47lyU_JCloPbY2Ykr2o9ALZEDVtLgGtXrrXDD1XCJQp8Cj8k-m4aGbhtFcMPXToG8K1vCSOp2BVClQFQnHGYyBiI-MLct2tuzWltHsda9JcRcNa9aPUwGq4Ec-C_wa_LNaLfjdtFrXpDSIxj4dpwwDGwEg3Zn7GlNLuwjC1BIZpo29Hd_bWzzMflxcfJO90rKX2St4eaYtHsL794tvFve17Onia81ytOxN9iT7NXv2m51taLKzPff3KqOK0WznnXag4j_SmZ6EQzAbOsbikltYMEhRvEDf7Tay7xb3s-fZ0-xNQ0umJIKi5E9zEtOGhvC7jXns9z-07C-__LJxq9xbjTQ4K2DWCAKiE6q31k70VLjjbIVxXCJbEae-PlwiKTneWJyHkUArOYQuaawNwlRw6G1MBsqgEFD2t2mY17gSUXlYXlww0KSYHpTwHO6yhoBaNR5t6xQe7Zj9qXWJmNhLvm204bzA3l-7ZkPgnD_7UG-MhvF8NriYG09cXKBDEnkp8QXT3kFoaAMmXCILciYeePRQaBzi-7HsnVnZYn3LYozpiHAydMZcJ2A-KynlsppoSyg2TStMMdJMbfybW4W8Wzx4LVoLpgShpI-MDtwUAYegmOOh7G9xL_srGMfsyeIrsJIvFvfASP4vWMXn_aWGKZmIhjZgzh5nr7OfFt8CAoBmCLLvsp_g5XXeHH3HvDmo6JRvXCLGHmW63YbhsI55l39d3JN0_Lx4BHiBrOfZC0lKV8FF5uk0jOUwHJUaieJ_4P97fSnE_OS5PDem0crPy3i1OjPVHYACss4_Qs9F_hjXJIfBoOAK8V2J4aKcHJ_Y3Nk29p9E4JB7B9TdhCPmFv8HHmP7mlQeoqGCar0Tzg6pXCdhehRJmnNOySrpnIHm586FUB5YWaPrWkyLzcKLc1pQZyE6XCdXbpaBf2uVW4dziSUGEFgTd1hnXFzmoJHd6fQEsekUlIoOviuXLuet_cF5hMkHyTaILviBpr2NxG4b3W0kSDdbxm3T6TYjPkSRXVwi---1z7d73q3YJTIxmpHbbvlg1ZFyk4BcXOwfuTK3he-7cO9Z0jkuBxOtO4ZUK6XW6xVQbxXk5quOCQ6f6JyQ6nwXglma60LNqDPASu_yIVQYVB6pOIAuVHBCQW1P8_0psoCVuF4Qid2yw8zCA9xFaYsHTJuDKfh-8VADNf8qe7n4Sms2pabirXF1yahgoQRN2WuSHolQAUi8iGTpU6DWz014Dpvv9gQWq1xc45IBKE0eHlkLM6B-eFiFKUQCa1xcVWvDXFznzgTCecEYrCUoJBlLCAMuB-2e2IHS-MAb0kF4W5tau8yKwpbz9eJb3PEyUwxsQw6-hg3vo8W3Dc1zUYfu5qEZKGBaV7zvVkMldEY8H6EKe-UyNu422Asd6eE8RU1VAWLyuKskkUE1ajkomjW0qbPLRvdbepvMXCKf4kLFUrfYHGPHafih_Qkucfj1ofWP8A8bfegYSrN8B72SY-kh1-zd9kqOLR4Ce7in8KxgjhqgkgxSynZFuCqahkvDPiPe_J1p2xps5TWzC9u0W1JNLA9vGlMuEl17tUh8x3wocMUW3wifaHE_e83CHi_h_SEGP7Tsp6tXmltcJ2bAjETwE-_T-Hy4wHzCN0j2o-wH8Oq-AsF-s8WH8Q1I9xN4l15cJ4wEvcRXwovNHkMBLARQHN_C1K4QEDZ7-SpHF22HaMDO8W7jg8ZeEb_Z2SZ70r8UC1cE-OpjxcpcIlwn4I-X7UY73w_wEIXLtFwn4E2nwi212nkcZ-yB5uLaArg98QLpuXKzXtUoa61HZxmuajuqPp9tXpNNy4antlwnVN1rwKtBP0N0aFo9MFWtrXYbeu1cXBPOC3IloaF0ZafmFKQvDPz8iIPjXRcvQ-bN6IQglI4-bszyVIVttpaarwmlISDxAgS-bNEafth0ds7kBuePVu4MqUxbgwWXnQRzyTDFXVwwmoBCQhyeiMzYYK8DXrE_Lvb0KNSjOIzwvKR-Ds8p7vEW01cTbDOdczlstwS3Np6R1cArZqRrWQ6PWKCLmjc7q43wceFgIw8Hp2F0FseHUsKEzEsR47ouoRGJSZpzLD9jMQuVlNsReYx9sbTKZqG49jvP0kIWrpAe17x4Kfj5_mgNydblI9m-fCQ7l4_k1uUjuX35SO5cXD6Su5eP5N4FJtlaY0qMC0yzIe7YjcMwrQQLS-dI-WW8ApD4_vk6WcWZO_-1eryYKOPdpqMNnS2cpeWTlabVu5Z7rHyLLAa6lHgDyBzXcZ08nUeFPiY5ogr7Dll4NmkLzKui-LdI5FLHVBPFwF0_Jl6NNuOsVQVff8RprFwwXcfZ3jllKPKeMeVEHC-8_dxZXCKAWyv9G632QuYde8tyOvDTU87gMBhVZmB5Gh0uyBITl6QNJB5cJ2YJ-GJrjTU3X1WRd6qDqpF5VA9S2KMjnviFKWecUIMHWYfzOAaq9CNK4ls8_Pgo-yl7rf3fM80yzK6WhxJZSBZw44nJrcZe_sr2fLcwtthkhxs8aPlicZ9lpiln8M-aV69gK04UGqo8GrxEZ354IC1Nm4XQvOC4TfYJl9jmiV2s93PK6jrZGttwXCePQcUBUM1FxPdmXqpuV22TVwsl47JcXEtgDUtHD-azQXH2h-aXYcJkjFkYK7FmGAMG4bNcJ9lfiqSLH_HURnCAtZNZJsVZldxOY_UgvC3UsdjLi7Mh1EGyXmJgF49BhvVcIpWvW0CVR4pxZdOQZGK2hsvzHGGsBAchT9eAUTewRK4alS0gOARQJizOZoncYBqQgU9H-ZEjTDtP4BAy8En-wrQXX4_w-DvxiBk4ZFwiCm-SScImDBWYl-SYWWcoI1xcenDk16H9JIw9mkhu8vkS0nWdvyG2u9zmLY0EicGoSMm5s5wVkEAgxr_yGPMqGCCtBLOqR84YFczsFDN2HHutk7N3mZO2wLuOW_VsXjVZwvsojWI1a40KVJWt1foqS6u9LLMTk7WjME7Hoe-FbhSHX4DickdcMOz5iXR-sufs6OxnPHqSy_RcJzxLzX6V7mGBAxdbfsDs8AVcJzV1AcUURkx9GPZIJbeAEJXFQmP5WQ95ThXoiF-17G_81OtnsBjPlruQCOTq77Gk4WLto1AuQxe6BLPY8mPFlZhxEEIr5t8aiMaSeyxdHyWoxb_5ITMMzCUgZYwmHvZnb_Bwf4nPON3VlmdyoVwiv3iQzL1U3hBcXHvxoF2-eBCEae1lCrx24OkRGF7G97ty3ZGKN3zXAyHYhEew-rIfs6d4kn-uXFwxJFcGlMa1HGmVOVwiFvwahrCEdH2eiC-_rGWGtREzkEomKSxx8RT84F_aKMayEUNInJwdQ3i6qO6HoL3Au9EjPFOp44y92VJC7-IhupGoKt7ZYupKJoX7tSzqlFk09MP56CyZ5GwmPoAWltIj0KegSH_FRIiLwJwzuNuUerP6FSacnIpJUn283C51S2DHeoG4O1LgvWDiU7yI5A7SYCkry-rVXDBzS12KmEVjkIC1Ng29Xg6x2o4VGBTb1cuzpymZueAFx6Q09YnwpVQj1lsLrQiXxVbg1zIJWh7PrWt4FhIGg6WzKD062wuBFlt8A3Dqxtw8bmbFLiqTNlxchgy7m6RcIn93DW_YZR59SHwajMhxK45xEkamyrC4bsdkWOfxCbGZLs5keYs1Mq3grEo1qlkax2HsGI478CZ17DPNfqNq8mqsYU8ykeWHJnp47EVUuYpPpuGXhiC3z7iWoQzz137JHks1mIPO6MibzxRoIBjE7G-Lr3mM5WdwGV7gtvs1GICHmPz2HLxOMAX3wVR-je-PMVXuBbS4h-9NvH7wePEge4V3Bx9xJM9ZqOa-WgKwP6Av0pSDyikq57qiwsmrXCL85Np7u3YHFOgRk74LHKDJ74WWo__y7p0jc3-DMKaJuCFvYfHO1N5D70dDIy82FmDqvwdP6DXYfKj6Tw0vi2R_2dkG0J1oL_tv2IHc07L_0jC9cPFcMOYWswwFFOL5BVTVU7w6yj2qXzSRcvtcIvueP77E_VwiStfTxYOmxu6j_JBnXgLYE5a4iNdQoeYZArwETEDI0-y77A3I1cvsFXojMuOZbfQEUHNnO9qTKz_xRlTep6nmDpfqhRSV6ntFPdO3M8ojV-WNa2sllIuiGlVgcbEWFAmrXrp8hLvYJQjcuGPQ4KiKzimA5epRLzIp9B-GIYtQxMPlYSoDGAxcIhCPZAlE6YgeyMBGCQJHxl0f1KFJHndxpGPAoi2MJOEh8QxcXDcgitXBjFxcYXWWIaW7A5L-QW5Kj0OLVu_QS-UK21wwq7UBVjxL873h_sZI7c04gO1AMQfHoOWHnGJdHw51nj6qc-tVxFWVSdcL4yjDEVYFXCKKw9F8mOoRYJLLIXf_LNYP9z91NKN6NTrjqBCiclWv9mq4eZCWYiX4RVwiFKQ0Bpq8UPGMMbh8c-olGp4QaPD781wwBq9dV4ClG1fGME1nPl-xMJqdkXcg78PPAx0TJrmSl87F3tUrFZhV1eyoAvNvb-1s42u5UUIjFuXZyyunpqwT13Mbe59_-rt_-KN2_bNPb9z84-fXb_7zZ5-CojUZsJMjyq_zNvZugIuRTuFRE_6GllwiNw7JkQZzSZOmdiOF53Qe0NFvXDCVg6hk_-y3dOjL7DnWvrbOyb6WyDiRkV2dQHC6HMZ1n4ZV0hetKsuGSQJe50gcDgGy33oz1NraPPY_ypmFrmHS5Kl5JPISxiZo-vc8LXH3D2EE3hzzYLbgx9uy4MHCBxsebHxw4MHBhxY8tPChDQ9tfOjAQwcfuvDQxYcePMCP17j28dUrV68MwtHRnatXXCIyQvnpawaU8gR5_nz36pWmEK4trVlIGrRhaYycyr7WEHQ2trS6DMoyRokEudzX2kZ0G-qVHEgoa_GyUu5jX7NYqUpcJ38WW1wwKFJcMPJCs8tKWZeHogNg1wr8HQaIlC6PmBNr2cvE2rxXJiF97YNut7sR6SV6Aozj-7xz_NtcXKV-cMKESPc1MkhAj6aU9TVmQ_oQnjX4AwKuvur7qOSKBNW-xh5Ryf7bRzrAXSsK_p0XyJaz8M-na5ecqll4mlZcJ2yCs4tcJ8lDpqHvLEmLw2dz5CWRT0DCvYBN9lwwNln72FxcOurRmF34KUwQGKc_lNw3qwLEXCI18mprFdpUoBN_PhEw0QoY3LQWIUtDQaSVD5JEGC-HLxGApnCpYb6pFc0kJaYaztJVz5NtQdHDLTMDSb0Jxdq_MMc3KYWL1rAE-1XaqDv5Ml9Y_FwwSvXC92YfuUFA5mErdEicv8fyRPrmVdAyHYbapjRI3iSnwxB05G49XsnwArY7Fx6XjfZqwrQHylBxS7jFPszH7ywpN2bYN96VK_ZdQ94_HsbcbkHhEeUHuDgtJew63wWs6KJAVe2hY9X10Kn2wKzn6g46RntVB07P2XAIirSv6cFaOYRWq2YI7Oqa7KEkNqv7cFor-2gbm_eRpN4sDMAcruvD5LfCq32YXbuGU3iJEW8T5vGnPMJaOZLxmOipoT2RnSGvligeivJFQVH7xXJl3hQNCbuXVjlxVmrRs8D4X1r5UH4FhAajyu1fnm1TQ2JvaVwwrnDlCjeQu1pqK57ewaNFCctUGjCO9cQXx3j4j5exw_Hi8yHo_4o8Ql5v5tfNef5Q3q69Kt1DbNASCYV7lDVnAlVQZbLEFjupjKnkc-Z04D1L_IrJiM5CV34lNYwKmLv_D5mAD1g';
	$theme_options['Demo2']	='eNrdPWtz3LiR313l_4DMVqpWFXHE1zxX0sWxfU6qdm2fLVduK-ViYYaYGa44JENyNFa8_kH3N_LLrhsvghwO9VhNXCLFWq1JoAE0Go1-oUHTqTvwp1-L6WTaKy6jZJ7Gad77oZiOpr3vbDazGcO34bQX0-t0U-LLeNpbbOJ4G4W8zpHvARYELGZrlpRF7wc6daZfo6ktmq8YDRn0_A0aOKq3oLzOeB-DaW-7ikrRH6BCwyuazFlQrqA3jlPBq7yqSmPq-IA6XDAlIc2va_g7Q9fzfdWnhrGWOasDLrzFYDHGN9ee9mYxnV9GxSqYbcoyTfZ1Ca_LOJ3ROJgB_DJPN0mIsx4hOWFC0Zou-YSgS9mcF0WhUQiUyVnGaGmUAT2ztIjKKE2MUgf-pmVJ5yukr1GB04_-YY4EgzenN1pMBO1hwChJWP6UkIbFi1Nkn2i9NDsfV-WAYjDfFGW6NlwwXFwX-uSFwC1JSSOcN3BpuZIoOM7I5j0B4JJBLSzmXCJFRCmi_pVPdUHXUXwtUfywmUWXihWRhJvMqlwwXFxcML-gq3RNj8kb6O8K_i5oUlgF4LiQM7uieUQFMUZIyOUmppqRS_altMoc2izS3JwL0FwwMbMU1VwwY2fAW-FugplZKxYtV6Wsc0eqx5iVJcutXCKj8yjh5IMGdhvFB-FwMBoqetA4thBVsZl5p2JpfYGJZIRlmi5jJnjL5phcXFq616Giv14uXW0ZE29srGENbpVesRaJ5Fww9itcJ0CxAtPSqzbZWTRA94JdpvvXDNB6ASsSH5M_s_iKldH8hlWDXga2fZ8V88f7V8wf3H3FKqLtXxSkk_ufRFwn-3B08p4YnTx7P528A_KT_yjphPJnTrOopLEkUQvJXFy_g2QHZK3BE2Mt1_730Gn4xOjUqYQPRFwnV5jT_xnyfOAejJmKzewx0gkItMkyls9pwR5-93ltBKvspk6uQisZ7L0Oat1sAt-ZXFyP1QjeTyloC17EkpVPRZZ3bD9vfJjtB22F-6xpNHyEW6973ntn5_p6dmWazdISXcyMhqHsQPMleqBrFkabdWBQw2TfsZq9DJwEZVTiKI-DXh37bty9_tDzYkZzywwKwNghW9BNXFyqKSBIMFtWwRyYQUjzS4zQKC9PwHRHKxwbMFmVZVZMT05KNi-_pEmfB4_gZbWGdmV_nq5VlRXSkp5sM0sKvBMOWqjqE95vcYKeZ0yvLb4kOJnZsv9LtrxdXFwEaJakVvV-_1wwCd9-0glubsUR4GV7WuNxWuEyVhQ1Q2vIjgaICo0Y_YWhB39UfIvDrmgSxiwPojliTqc8XFw4Qlkyy2l-LVtcIgWjxbUKtslKzu50y4p0zZRvv6BkQS2a5-nWCtNtUvn8ognKKBiqUDGDqzkUEf5_a7aZzWLt_6sWjbHlK-JLysgCwm7ErvVaZhTM47Rgv3lefn1em-xBZ4VRycasJNrmuovptK67swOi5t1cMFR9Sf0GoJt1ElSxXyDhMBhqXopTWoLM43sjZ_QySyPBxRhcXHOFZHFcJ_tcMK0qOGTA43xQqnZLBhzegGqwMi5VDqN9bx-Dqjr2Bsd2fzI-UnwtG3ZsFL8B1OgfCSr7XCfwnzsYwN99d3Ckll02jtmi5D1wboKRTzcxmce0KM4QhMsfOi9756dxdP5zusnJRQ5DsZC4PvkzvBfkI8uvojkj7_P0KgpZ_rvTE4A9PdnE543p5KjWq9GABH8r11aRzkEjWBhRKz5jwaxEBgKJdtZ7A7KJUPI_mxSmTYoVzaCw-PuG5vCKLc56mzye_t71fv31197n-ngdK-63wOxZbGCoFZ4bKBnb-2E2ddQ4sqxTQ0xMuG4tMRkeQEkcQjkgVeYwJMuJMC5-q6pAlpT8yn_6tnMkhIdJvvp-qAVvkeE13NNyPgdeh_N5D-t3wf_caB9qaj1SL7TDtBt2uFT-4QmGMiOc55v17PE5oreKMT50TOgWBEQSaAJeRWwr29I4Rh2k9Wq1hRVO0NAd2Eq0C9qju7LcXCcJhgqKr1CL8kWUmYc_WhnoYVHUV60lTZLUEDGKCaR7JbWZMpcH_FwwOCgRZA7yOZ8rJfCSlmyZ5tfkRT5fRVesmJKdFiVdqha44eiyAex6BjAI5JKr6mgRsVBN5T2UFqQqXCegbFguxxobzemmXFyluRoOaPKCFzTR89TReH1JHNvTp1xcotpcXJCmTW-A7DOE0ERRv_aRWkhQFbgv4kD18FgOhe-syDwPxy8yMLGBusFtKOIci__ANBweKZEhGxpd7Ter-fnzMjWSGDSlVJUyxlC8c7NBigys7JZuILvW6aMJs7nDhw2zuTb-dIq0kaASP_OnsFwnvvLBBM_5eF469iWy5QpkiQWWquAu08rbte62aR5msLyVIReydeqaht4mw7SC4gQ4Fww89wRQdU7s4QmiYwE-ljOwvzj-qJ-JScoEGIXBZHxoBMTA0vfjrLSmX4L6MamveKdcMN64vA5UAo4wr9GjrMmdQIBp8WMr2VJrvl8KTdogb7_1OPeI1daYNBe94s7agleyxlxcBF76TUyhQSFjqjVCScQLBkJ7pf0QJAEvCaIkE04w9nkBm578FZaSXFysWEJeo7He7ysRJVrgtlLxvEr6OWqkoryWXj-wutAoc2sFGMZqHStYrQg9jHSdhtGVdiPX1tU8XDCnzrN0kgsxCrlXCA4mrTeQ6S4GpNkId761DmtF6B1awjmsleMsrEUMnqRRuuWUtpKU1PDDhI4qzUy5oT2yytni7D6bRjrQ1qY46Z2_eX1BXr57-_HTjxd_efsGHGUKfjKQ6lxcmRcGLQM6A_1cImJDVcJQA2bG4nTbhKl2DtYEpoIbKrdNAUbJAuwFEN4qkpImMmfOkd658O5n6Reycs_AiInjHol4XtyZjj1BAVdC8v1sXCfClc5cIuAkXDCr9HfA1-Wsx19YaKWbEiV3A4ivw5mR-QfVuPZQtIZV8c96f3BcXI_4g-GIjFwnji1iXDCtMyu3QluNXCetM3u9ptE9pgZrj0aCRePyMPPDefyRfaHrLGbIaXKGbtsMgUuFsEMV0zLHF2GILHr3WcYp2LLAQ1YWJYeZJsaT_jtalCtSlMfkx7QgL5Ili1lxTD59fNG2rNkKeFWLnSHwK4gQsU-_g61mRI5OIyVaRAh0DhKi1HLnBINV9FxcSUa5dWqBsSGwzGl2_irKYW-TtyDbWX56kp2frlxc1XO2CsBLOMf9QT4V5F0yJd-P7NERht4sZ-w5p1wnK1cHxJQRVwuIDXw-yrvFAsNp7zKQ2hfRmuFABEY696a2TV781FwnFykBqQ8v739cIrpbtP1ltzI22h1mN0QEkIPWlfNwoMU-FxcB11A6MxFdsqF2yRYRaAoha9Y0X0aJ0tHCfmrKo70aerQL19TPTePac45U07py7xzJ8_eCN8OothzQcVwnYA4MjodDGHV0JK1EpErBUuUzrJxVumZpEuujIdHvvjAkEm_NlhShLHQmcp6xLA0gd6f5ngglAoJWReBcJ5ZF4HSc-7qHOfd1tcFp0mxPL-iBKrBcMLQ4elsYda4YxBdZ6Zwe3j7glvBDFTFBng7zNMOTpu4lfHypDR2pao5_kNQGV1Lr1ivSDtyyXCJj1_VFQAi9XDDd7KECDjcF1G0dUC_T7CEOXhWHSZ5XLCZEXcEymtNSU0wfWjmVRNJqRJ3373IkcuEFzCGOo82a_JXNHla8DH9zMmVnpPgegU7btUP3Bg51WrlcJ3Ae3y0G7YLuQdl9eih7Tw9l_-mhPHh6KA-fHsqjp4fy-OmhPHnEKLt7VIn9iHG25WXLRZqWjXjszm2rBiDGlg5qZFVZC1UUbHe-mGIUfWHhLY0tXFyl3ROsvjs50har8JDlRHdSlqAzP_ADX1wnQpnQN2SWNGH_hSR8mMQPkfyNP1UKnDmnjiDGSF2ZvR1l3Sb4_hNkuwV0H2VcJ4dI7BTDYsaOPMH57QuHXFyK1m9cJ-vfaqtXDO8Pj9Wv3XcGRzpVok69-hr6gosVUhJGnzXUc3BxLJm-fPOG4Hejm8CPW6jsuVvseu7Qm1Sp3LVJdWwJR9NznmbXXCK8qNMrENOXqpj88_8IRojnmzzH-PU1o_lnoiOoPHgMveJp1efeuX7lzuBnjJf2yYs4JryvguQMI80s7D9_hqACB1RbOli9g1auXFwxpXeGPJ4WJTcmyXkH2HB85ANlyN1tw93Sp8fo4gywFtwQR-uoNB1XzxHV8tQuKFbpNpBnFUHCA9j6XDBxLHvCrJd1mlcxdZjih9cvXpGf3n14Ld85oJG-I_tXnjRWz9IvUhJLN14dKblVveqB38gG_rSqRPlxBVWfGkaUHduECUJW0igu9goPj69JGYgUUyACzVl13gkU_IglaueY9AJuojB0wUNxrky8ZgmdxSzUB7_AD1wiiUYyxwv9wmVcXKnuM72Sj5gCRZcqGkuXBV9JFGJRoXvmgyHzCLZCCsnMoYgViupiISXbvRRv2Ns3oRZ3ZoLIYOCkZv-5fgskIIghMh2FboMB1GowbSMKwphgzqha2YOQt4swd1wnc9tiSQOlNot20toNqCZZm_VNkjZH2SVcJ2bCZ2leLtI4SoMsT38BiaZ2hDp_eC-KySujeGK2w42od48vNqMS2RUUlx45i2GqoYliBSErq82F4vyDKCQSi2K3Y9VMyYMJz8uupAGy3y50JV0wY1Aferb2jKibFw-RKtlCSw5-VgnsMBBfglEZHc4OkDEzt6LrW7pmar2bDR7kOoq-tlFsolJfCtt3bWNYv7aRpGXnVRS8tBFZGahbTu5vamPRhkX8LYIVvw1poM3LOJIb8GA0sRVNZozlnfQY1Okh9_MecvB8fmtTyI9cMO0lhXsrUoyrhM97EEN8iaSayK2oQfPi4aghknHrB_-dZPFut3mG1eb5UfZ9SGYZK-qkl520GdVpM4_TTfiQ1PFvRx2gws9giJM_baK4fAx0eYCLYGW07t5S0mhpqBvTZtM6Z1xcA7vRqvPsGnyULGOGF2Ix22tcJ-_NnXRcMAvNWwuSZQtY_L2aC7WEgGjXVlUPhoaa6Hx0RtcBWL85rS19IS0XUx5P9kLX-er1l4zh4dqcqfO4fc3-hfzFewfzXZ4_79lsPO_emtOY4efRujeafVwnwkDbj5dRLCyjQ9MEZsfWWXn9sPdJXU6cGZitC2EfdG40Dg5zNFlX3lTkrGuJUIN0lqvTV9FiDysbfTaZGQUry_M0920_mEXLLkI6jjhTNbVbh-KbKBbjybaFld54Wde4o3EHmb4zBcM9hlwi8vrDh3cflOzTgPJSvc6vx5PyVVSQDIhM1vSarOgVI2DBJGQN7n5I0pyELGZgs_bJnxgpNpjFmpL5is0vyTXevCwyFsN0ln2FrR6snhGMAkRX4Xj_lmuHMLiVcY56xEEVfU22HrtXdw99lSidpDkr1GcBsNHpyjt_m5YrWA6yQMKenkDJaXb-Mc3z62My25QkkfXgGsIqhnIReX8Ew2NFn7yPGexZUubXhC5plJBthBmQwOIkjBYLhqE5csmuMbu46GMmoNpwRRQydQlIzkpH1Gr1co1r9ZOqngu8NRMBoboLOGiFCpCRsgYs7pEKI6lD65enhi0Q6PZqE9nszq-AFW8bfZn4b9OUO_35fHeaxgRmM56cvQNiDMSu1JcEaxA4M2FooOgqdNTCVx4jjyRwlKQ9XCJyboOEGqoQc3ClKtyFVMaF71T7cLvd9lUzsfvUhvwJNyRmzkm37KbxUT8BW6ndsn94zzzJEC3qI3NRoI39W8wbewY5mNw070l93qoZHx1-M5pcXFdYWByNE21W34THBJOGwcRY5nR9E1wiXh0R3a6iQ4AoBBoFKSW2c0tkklpCv1WRVYM_rUp9qmiE24DI8jTczEsLTDVL7VxcbRe6fBxhmFqoaK1mSMY3IWRl26heO9wmKWuhEszgRJ4vc8ApSg2TGcPLXFyd4aFcMIG_P-ElQ_LSXDBW1ky9h1W5joVwceu3RDaJhcmTQmUo8-P8-bMGTFs1P53AVNzP4jJFvVHBMh7kOdeVK0fVyWvPvfNPb1-9_sCvZlxcfPj08uIv796CPHc4sK870tekeyDlgRe5cJcWCSmRGlvQ67CWDCT7xxKey03Cwt9BVz52pcavbnz4TfLc-BUZ51wwmrqGwp3UdXtcIsH9chn3fWXXSGN0m-SaFwXYpOIrz5MRdPbHaI3KhWzy-HtNKP5Fo75I0aNZVAixUhT_JdITz96nGdh6iKV9DL_RsQsPLj548ODhgw8PPj4M4GGAD0N4GOLDCB5G-DCGhzE-TOABfqPe0Q_Pnz1_NkvD66_Pn8mvL02JDaVcIk9ePH97_qwvGeuY9CsugzY8nVFgOSU9iWfvmHRlUtZ7VJ0gladkaGdfoN7IhYSygSir5UBOictLTTzFs3QQoMhcMNCFzpiX8iG3clwwIFdL_yMOiJjuzlgg63q7yHpiVM4hU_LdeDy-Feo1fBIM1sdicPzpt4keXFwwydJTQmcFyNCS8bEWfEq_h2cCf4DBzVfrEgVcXJWoOiX8EQXs_35vAdxRVfCzKFAt1-k_7teuuFez9D6t7tgEVxcPjudcXDp_3eEWX6xmGBVZTIHDo4Qv9gxcXLBLbK5M_mzBrytV6meC19xNK9NtXDDx8I1Ka29COwZ0EW-WEiZrgUGXVo-K_p3uiNRPi2RYT8PXEEA1uNNQu7yymcLEMWNcXJZpIHMHFQ3xOjEQ1QsoJj9x-7yoxZD2kATHNdqYfn6dLjz2AqVW5Vwi8K8HISB3BAw8VJ9vsLxQLkQTtI6HbbapTVI00XjYEg_tfeDVjCjhvru0tjzUV0txNRQPz_RB4oB_DrH6qLq8OMMvexmfNBjb6r73PBd6CwqvmTg-xGWp9W4JZ6VliKqr5ggjt2uEUXMErj3bBxjZw7YB_Il_yykY3L5nBP_uROIX9NQINbZpH8MftI4xvMMYRRmt0wTU4b4xnNGkbQxn7HVQCm9X4n1IHZ2SYVe7eTYTcdYzQ4AyN0NdMTEsFB9vnva32XwxXCIoF-XVYJSnhF_d_pu4lAkKEVMePpOvQupqy8EBVc1VIHFcXK0-Md0mCi0MHHDnQxVgdA85iIfhV57qzFCwUllzHSx8YNIXdz5cMD265GcghKqGlWlqKfULhplsL6-K5AztPpVnUpA46otcIlUyneFZOTsmjRbwi5KU0B1cMDz9bimea-nbUknFF0xg-JZK1PLFnirhfXV3ntArfofG7ELRiFsD0rJRMlUywi8VHxhhSFGJNgO_idjIIDBq0YjEMHnZ-OclGiAsCRu3xUVKVQs3qk4mO7waSKu9sviFVW22Emk9XCK6WPDssxnfHCjEaEiv9L-Nsk7DqnK4-89dqLqJ_K6fCCBLeMCfnwWJb7WpYp48UX3gB90mmYpa1Ytm-mM9_KOHulv90QiRlKbbDdvShWSMoFBQ6PruOYNqghpyQG6wokHDmjuj8fDlXCfn8AsCgfrkcZpVMN_-H0f_a7o';
	$theme_options['Demo3']	= 'eNrdPWtv3DiS3wPkP3B6cECCtdp69XMc32YzudkFZpNB4mBvsAgEdovdrbFekNR-bJAfdH9jf9lW8SVKLbXbjj1jXzwZS2SRrCoWq4rFokLn7siffynns_mgPI_SZRZnxeCHcj6ZD75fhbOJy_BtPB_E9DrbVvjizweXUcjLnel8sNrGcYAFAYtZwtKqHPxA5878SzS3RdMNoyGDXr9CA0f1FFTXOe9jBN1tokr0B2jQ8IKmSxZUG-iN41PyKq-u0lg6gEsJQGlIi-sG7rZrh-5Y9alhrHXBmoCrMf7gm2vPB4uYLs-jchMstlWVNdlhj52xR3mX8LqOswWNgwXAr4tsm4ZI9QRZCQRFCV1zgqBL2ZwXRaFRCJwpWM5oZZQBP_OsjKooS41SB37TqqLLDfLXqEDyo3-ZI8HgneQh72HAKE1Z8ZSQhsmLMxSfKFmbnU_rckAxWG7LKksMXDDXhT55IUhLWtEI6QYprTYSBceZ2LxcJ1wwXFwzqIXJXFxliChF1L9wUlc0ieJrSfeHbJFVmZJF5OE2t2oIF0DO6CZL6BH5CTq8gN8lTUurBCRXkrQLWkRUcGOCnFxcb2OqJbliV5VVFdBmlRUmMcAERM1SbAOUnRFvhcsJSLM2LFpvKlnnTlSPMasqVlhlTpdRyvkHDewulo_C8WgyVgyhcWwhqmI1807F3PoCE8mRdZatYyaEy-aYnFu617GaXDA9X7raMghvraxxA26TXbAOdeRcMPYbXCdAvQJk6Wmbdc3a-_KSxmH_rAFir2FO4iPyVxZfsCpa3jBv0MvYtu8yZ77bP2f-6PZzVrOtf1qQU-6T45S3R7p9--E45T09Ttn9nPIeUKb8R8op1ENLmkcVjSWTOpjm7lmI3gOK1-jJiZdr_zGcGv9BnHpAo_xA3HKFf_3_xQ6OHk6oyu3iD-PUaB-ngEXbPGfFkpZ9GssZ33kdOp0etval9koWus7gA-7n101-8WNahN_kGfezyuFb4jWrno5i9_ZwaXqHNaj323u5JLbVmkvjR8Gl9vrbT3kvfa6v6auyHNYEbj5zGoayA72McW-asDDaJoHBD1OEfUW9DKkEVVThKI-FYzetvn4ZgJ5XC1pYZsBcMMYO2Ypu40qRgCDBYl0HeoCCkBbnGL1RG0ABsz-S4diAyaaq8nJ-fFxcsWV1laVDHliCl00C7arhMktUlRXSih5f5pbUe8cctFTVx7zf8hg3pTG9tvikIDGL9fC3fH1YzAR4lmZW_X734AlfgnJ_3F6OE8DL9rTp47zCaaw5aobdUCANEBU2MfoLQw_-qNgXh93QNIxZEURLxJzOeRhxgvpkUdDiWrZEDkaraxWIk5VcXODpJSuzhKlt_4qSFbVoUWSXVphdpnU4QDRBPQVDlSqccLGEXCLC_28ttotFrEMDqkVrbPmK-JIqsoCxW7FuvQ6KgmWcleyb6fKbdG3ze6UKI5YtqiTa5rwLcjrn3dkBUXS3XDBVX9LKAeg2SYM6JowKI9DKbRVntAKtx9dGweh5nkWpih07rtAs7qwP0KrjRgY80oN6db9mwOENqJYo41QVMNoL-8j1_CNvdGQPZ9OXSq5lwz0LxW8BtfpHhsr-Cfznjkbwe-iOXqppl41jtqp4D1xcmmDkk21MljEty1cIwvUPXVaD05M4Ov012xbkrIChWEhcXJ_8Fd5L8pEVF9GSkV-K7FwiClnx3ckxwJ4cb-PTFjkFmnY9mjOBufpnlVhltgSTYGG0rfzcPT4BsA20jrlzwJE5KatcIkvXp1wnkYIX8p1vspQByHF0ekbjc3KWkbdXYFMrMj85lm3ICZjTVI_DYivNBqc2eeH43kvij8ZkMp1NXDAcoE77yNkjUH4HTI8sAQ82eGShVPjgh8XcUePIsoaYNaOZMxPqJhPkGCZo1_RcXGZFmBesrK1MyJLMM63QNsdQd3kMVgKsj3fs2q5zbI-Pb7Q_QLE_Hvu3tUHInSUMzApcIryYb7VIyFW-LNwjxzvyprjqXgolZXKyue4aHMeFpeGe2n53tMfXHnu397VX_M-Nvqjm16Pd-O5xI_fsd13_4VmGCiRcXBbbZPEI974HxTj3ctB-EA5cIgs0By9cInYp29I4RoOnjXi9jhVO0NB3JkpVCObj7qhPAeNZmzFFHZYeUWYe_mjToIdFxV-3ljxJM0PPKCmQuzlpOpVvPuJcJ9FBhSBL2DEUS2UU3tCKrbPimrwulpvogpVzstOiomvVwscTw3UL2PUMYFDLFbeX0SpioVwi5RcoLUldTsD4sEKONTWa0221yQo1HPDkNS9oo-epM_rmlDgj7XjJ6v4JcRswfW4XOkTqr_1SzSRYDFxcGHGgengsx9O99mys3Tz-M7QdYc48D8cvc3Dogb1BP0eaIRNUExLWaN3vt_PD73VmZFBo5qgq5VuChAm3QqoJrNyj0kZcXF8lj1wnmueO7zeaB76T7e6P40wEl3jCAYV18IUPVntUk9lIXCJbbUB_WNtcIhYCNXkYR2_C3y3EyYIleeX4k2EuqJTpNwqF2ezBMRAjy-0lF6aEXgVdR9kgPSVIx_l1oPJ_hIuNm9aGtgkEmGwtsjJQnzRaN1RPY0s264LsVUDOkfgPPNDxSy0-Yro1XCLtWa_FszHjtX4xXCeBl34VJLQY1KTUt1vKt2SgqTd6K4Is4CVBlOZim419nsGqXCf_gKkkZxuWkrfopw-HSi2JFriuVMyw1niOGqmsruu4AmyZuGjJqFYTsm373GZNQBfQTERSemEWLM4u2zC1EGBNYCpowKnQ4mRjztIK7B0oXCIVdsCdJrd0jtzJiq3wXCK7XCIb9xUY4TgekIhcJ5i90oEaKOAKVb6_2gkHZYsImAJgtfkJOKNeDfgLC61sW6EWagFxKXtlpM9BNWowKEoGZOO_GvzJcT3c307IdObYg8-9lFWXQvNOZ52UvU1odAfSYO2jjbNoXFw9DH1Ix5_ZFU3ymKGmkRS6XRRuCibWrT3upPF1GKKKuj2VcQa-GIiQlUfpw5CJwZf_iVbVhpTVEfk5K8nrdM1iVh6RTx9fd00rj4rUoRfUNVwnlFwwC1av7qKoZVjG2pbHAx1GSaxlRS3hqg5Of3p7Rt68f_fx089nf3v303dcJ8f0VKkGud4asVwnZwKTdBJGF6o7AWTxoO4pMWtEUWfcB-NENd94EOjkGJqq_-_2L-0NwOanuF7Jp5K8T-dcJ8f56cnGP_2TTeSSwZCQfXIMZaIv5cgqd6kV27K_jRqWXoCyyr-RIL5MFSnttdGiBd15SYuMre4P0xtKk8IWpml5x7ZijwjfBNz-6KxHD90pDbKKwA4I7ZvQYh2lyusX7lFbQ_e7_pNdwHZY1O3y_4eOsMDYQdOC7wzYCvJ6fm-L9si2HNlxZ2D2R0fjMQw8eSndQeRPyTK1H9g4myxhWRrrQybRb1_EEdmYsDVFKG4_C54XLf0cd6d5TzASAWmUXCLw00tM8H__QI32LE2u9fSC-0sFFoDuxI0VhrxrEfFF5jvnh9cH3LF9q8dA5RoWWY6nVjdO4mPLltgzf47_INkSrmTXwVPSDdwxJVPX9UXABx1-3ey-4gk3hc1tHTYHn_o-TnGViEmhVzImtF3JclrQSnNMn4A5tVLSNkWlD-yKJErhGdAQx9E2If9gi8eWrHnfgcwDMlWQhR3SEziP77qE3m32oOw-PZS9p4ey__RQHj09lMdPD-XJ00N5-vRQnj1ilN0eU2I_YpxteatzlWXVvlMfff2zBsTY24M6WXVugvjVTS_mK0VXLDzQ2erZoLoySwE9VrFdloTu5D9BZ37gB77OqjKh9yUyznZhf0cW3k96B_eqGP7U-XQmTXtcIhoTdTf3MM66bfD-qITdAdrH2dlDZImKYTE3Rx7WfPvEuTIyvlf0D1rqtcD74yP1tz7HdP0295pz6AspVkhJGH2s0EzoxbFkNvTNC4Jfwm4DP26l0nOJ2VxcEX6bqD1LwtH8XFxm-bUIcOr0CcT0jSom__4_ghH05bYoML5_zWjxmehcMDMPruO53baIPw9O9SvfDH7GyPCQvI5jwvsqScEwEs_C4fNnCCpwQLOlg_k7aOljGmV3xjykFqU3bbln3gMsOD7yfeZiHygWd97TY4BxAVgLaYijJKrMjavniGqR57EMyk12GciznCDdJov6TBUNMe8Js1qSrKjPHIDED29f_0j-_v7DW_nOAY30HNm_2klj9Vwiu5KaWG7j1ZGbW9erHvjNb5BPq055nNZQTdIwvOzYJkwQsopGcdmrPDw-XCdVINJVgQm0YPXRJnDwI5aolWPyC6SJwtAlj8W5MoubpXQRs1Cf8YI8iCQZKRyv9QvXcZW6I_WjfMQUXCe6loVndF3ymUQlFpW6Zz4YCo8QK-SQzAyKWKm4LiZSit0b8Ya9fRVmcYcSRAYDXCcN_8_1OyABQQyR6UB0Fwyg1oDpGlEwxgRzJvXMPgh79zHm9mzumizpoDSo6Gat3YJqs7Vd32Zpe5RddmJafZ4V1SqLoyzIi-w30GhqRagjiF9EMfnRKJ6Z7XAh6tXji8WoVHYNxbVHwWIgNTRRrCFkZb24UJ1_EIVEYlHudqyaKX0w4ykFtTZA8duFrrULpiDoQ-HOnhF1qRg9xZV8pTUHP8sFcRiJT86o5A1nB8igzK35-o4mTM13u8G93G3Rd0DKbVTpO2Z9d0DGzTsgaVbtvdeCN0BcIisHc8vZ_VUtLNryiL9GMOOHsAbavIkjuVwwH4xcJ7biyYKxYi8_Rk1-yPXcww6evW9tS_m1oV5WuAexYlpcJ3TegRnii1wnNSEHcYMW5f1xQyTbNhMj9rLFO2zxjOvF87Ps-yGFZaq4k53v5c2kyZtlnG3D--SOfxh3gAu_giNO_rKN4uox8OUebpVVUbJ_SUmnpWVuTJ9N25xpA-xGr86zG_BRuo4Z3q8NFlW6k-LmzvZcMAvL2wiS5SuY_F7LhVZCQHRbq7oHw0LNdL45o0lcMN5vQRtTX0rPxTRVs17ohl7-eB7FwgFAJva1uA_RAipZklfX93sH0-ULbgHe2UqYwcOs1SHcwang981cIvxA3O_BogNXH-8dNjfydL6HM_zWgbWkMcOv1N2w0DgfgTJTdOW1Ry66lgg1qIwkffoqWvSIstFnW5hRsbKiyArf9oNFtN7HPscRZ6qmddtj-GaKiTyvtrSyG2_-GncwbqHTd0gwtsdQRN5--PD-g9J9GlDe0de59HhSvolKkgOTSUKvyYZeMAIeTEoS2O6HJCtIyGIGPuuQ_IWRclswUmVkuWHLc3KN1zjLnMVAznqosNWDNZN_UYHoKhzvxojK-AFcIiowuJVziXrEQRV957aVXFwmLxj6KlwnOs0KVqpvDGCjk413-i6rNjAdZIWMPTmGkpP89GNWFNdHZLGtSCrrYWsIsxjKSeT9EQyPlUPyS8xAmZGquCZ0TaOUXFxGmCEKXCJOwmi1YhiaI-fsGpM6yyGmBaoFV0YhU5d82onPjXo5x436WV3P1VxcwkRAqLkFHHVCBShIeQsW10iNkbShzctR4w4I3PZqF9nszq-BlWwbfZn4X2YZ3_QXy10yDQIWC54TuwNiDMQu1BcLGxBImXA0UHWVOmrhKzPMIwkcJemPiJzkIKWGssccZansdyGVcwFy9b22Xzd1i8YGpEUtggN6dQ_oFQ-r4mh5fnCn3mEcwHagEdMbuhWniHLpXS4tMwfXCFcak27VNklt8d0WRF5k4XZZWWDhLbUctLPl8nGEt2eh9bLacQ7fhJCVXaN63XDbtGrEHzAvEgWpKlwwpygz_FCM2XIbgZF2Ar8_4c088sZcMFa-U7OHTZXEYsW2ErK3qYUpiUIP6yzj589aMF3VPOSPKa6fRb5xs1HJch45OdWVG8dMasY0qtNP7358-4FcJ5Sfffj05uxv79-BknQ4sK870teLB6A6weJwjSnNPKmQG5dgLGEuGajLjxU8V9uUhd_xVGjoSo3fSIpusudWl-zvy_w1ULiVDew-nb9bgmDfN3KN3EC3za5lWYKjXCe-0TybQGd_jhLU2GRbxC80o_hXh4ZcIu-N5lHJWQRN_1vk_L36JcvBgUIs7SP4Gx258ODigwcPHj748ODjwwgeRvgwhocxPkzgYYIPU3iY4sMMHuBvNHj5w_Nnz58tsvD6y_Nn8gtJc2JDqchEF89fnz8bSsE6XCLDWsqgDc8RFFjOyUDiOThcIvvSE5s9qk6Qy3MytvMrqDcSDKFsJMoaiYVz4vJSE0_xLL1uKDJcMHShM-WlfMhLOVwwsKuj_wkHREx3KRbIut4usp4YlUvInHw_nU4PQr2BT4oR8FgMjj_DLtWDEyZFek7oogQdWjE-1oqT9F_wTOAPCLj5ap2jgquzP-eEP6KC_d8XFsC9rAt-FQWqZZL9627tyjs1y-7S6pZNcHbxNHbJtfOXHWnxxWyGUZnHFCQ8SvlkL2Bfc47NlR-dr_gdqdr8zPBuuOm6uS0gHhNRueJtaMeALuPtWsLkHTC4T9Sj4qZJd0SaRzAyVqbhGwigGdxpqPeRspnCxDEDR5bpdfJdH3q3TWYgqmdQTP7Ond6yEZjpYQmOa7QxN89NvvAtO5Ratd_Nv--DgNy7NvBQff6E5aXyy9ugTTxss02DSNFE42FLPLRLjxceopRviKW35aG9WnPtgTJUX2se8c8W1p9ElxdS-F0x4ztcMFNbXZheFsJuQeE1E2dyOC2N3i2xA-gYou6qPcLE3TfCpD0Ct57dA0zscddcMP7MP5AEQ9p7RvBvzyR-K1CN0BCb7jH8UecY41uMUVZRkqVgDvvGcCazrjGcqbeHU3ilEy9h6pCPjmW2DjxcIi56ZjRNJjyoexuGh-KNYIUML_PlakJQL8prjqhPCb_6_E9xExQMXCLmEXwmX4TW1Z6DA0aTuCNtOcFOFddy4zGHLfwL7FV9_-MlkfW8QPVV21dpSrHQNLG-q7vnKCbA3Vti6NcYyi1GldQbaTJM6QVsdNhFlG1LQud0BdYbPZ8-2JRdVQpOjcjtrjOG0b4TLh9NK20yfM3-32ruGxE1UYmWmt-rax2GG7XoumFMs2r9kwwtEJaGrXvhXCI7qEMGVFwnsx0JCaSvXFz72YIws5XIUBGBspJcJ1ItuEii6qAhvdD_nkiShXXlePefiFB1M_m9OxELlfCAPz_WEB8ZU8U8D6D-Fg1uVmRWZV0vmunvyvCPAepu9acORH6VbjfuynyRu-1SQeGGs-c4pQ1qrD4ZLylbPGxsXCI0Hr78VhreQQ7UF4GzvIb5-h_gMB19';
	$theme_options['Elementor']	= 'eNrVXf1y3DaS_99VfgfspK4qqhU1_JrPKHPrdbzZq9rYXlupvdRVioUZYmYQcUgWiZGsdfmB7jXuya4bHyTI4YxGiuRIcbLmgA2g8UOju9FocOnUDwfTz-V0Mu2VlzxdZElW9L4rp6Np75vlcsC8EH8Np72E3mRbgT_Cae-axwwfvfG0t9wmSYQFEUvYhqWi7H1Hp970M5-6quqa0ZhBq1-gAvRD4yuaLlgk1kAuOyxlW0H9qmLDg85KIEpjWtw0mHN9N_aHkmZi0TirgjUJl8FysBzjL9-d9uYJXVxc8nIdzbdCZM3xenP8I5uEn6skm9MkmgP9qsi2aYzDGiFWg2mPb-hKXCJcME3q6rKIx1YhDL1gOaPCKgPA8qzkgmepVerB31QIulgjgNYLHD7_t90TdN4e3mg5UeBChzxNWfGcmIbJSzKUD75Z2Y2P63JgMVpsS5FtbAIfpojBYGGOlhn2T5Gjz3IES7rhyQ2SQfPvcpaSjzStpAzR2eZOTeRDlQu6zjb0lPwIbV7B3yVUcErofqmZvqIFp2qcI8RotU1oJaOCfRKOKKDOMitsNqF_5M4xgFww195A1vJggDxlzprx1Vrod_7YtJgwIVjhlDld8FRcIgMV3C4wB_FwMBoaTGiSOMiqWoiyUTVroeJEz_Eqy1YJU2LjSk4unapVYBrW0uU6u2JFNRkVhWONPcSV6Eq2UPosoqoysjhic-oGkgq4X3sRqgQYVjVzk52Jw4m6XDCRSxK-3ZB_sfn-2QPuXsHcJKfk7yy5YoIvbpk_aGWomb7j3IXu_rkLB3efu1qL7Z8eRMx_togFwQHE3MdDLHi2iGmr1olY8IgyFj5fxA5o1OARZWzwfBFz_xjEhs8WsYNW-5EQ85Xv_IfCFdzTUB6Aa3AfuIbeMKC3Cli5nd-O2HE-4Z3BOsYrhK63ec6KBS3ZfQTtHup_7I3peHmroMH-SYDP-DRh-yOc6f1oeXIDvGLi-an94GHROkaJQV21167QGj5FtA4PfO_w_LAansjyeQZPmyincawbQBH15AM8bVgM44ssOGxJHptB6zhKJLjAXr42YL9zQY4OiwPwuJzTwrEDCtBjzJZ0mwgzDCSJ5qs6EDRWW1KM7phtpKI5HOnwUPzWQuTltN-XAVwnwRbrDdCLs0W26V9nRZwXrCz7UC4-ZWlfg58V_evc0UpR1axpZPNlH3e4Cb1x5DzhmOars9_y1XGhFYAuzZz69_1jLHJR6s12e4GajfcXCzKczRpYKL1ec8GMjFokMuQSNdqL4yDQO7qRpl3TNE5YEfEFck6Bs8-SNuHzghY3uiZcIsiXNyZep1_KNUCvWZltmIkhLClZUocWRXbtxNl1WscWVBXUXFzQVWkCE1cLKFwi8n-d-XY-T5gREFOj1bf-ifwSwR1cMHarlnLQMaJokWQl-93jCpvj2uYPOioMbLZGpdm2510Np3PevR0SM-4WoWlL2z8g3W7SqI4No7KNhpUsJRkVoAjl2igYvcwznpoYsucrrexP9hE6ddDPoscVXa6za6lvUUfNp56GRpUc0hvIlUXVknCcwQKY-NY99YPwNBicumeT8YkRd13xwPoJW0St9hFn3T6Bf_3BXDD-PvMHXCdGGnTlhC2FbEEKGfR8vk3IXCKhZfk9kki1RBeiNztP-OyXbFuQiwK6YjHxQ_J3-F2Sj6y44gtG3hfZFY9Z8afzPtCe97fJrDWcAn2AqjdvDGz8j9g4ZbZcMKPhYESvJFwiyxLB8-9BZfV-7WaGQJ01NJVIl0Jydl6KXCJLV7NzbujVGsjXWcqApM9nFzS5JBcZefMJnGJBpud9XYecgxVOq35Y4kDXM5d864XBCQkHQzIaT0ZADlSzfWM7IHRhB80eecPmtIZviBZcMFVXkIqlorrFKLnjhzBK2xwD5GUfjAYYo7Dvu9647076MBG2RcrTDosE4wuA_q5WCc3RAvpmBYhE_nsNFEq8Xg7yz5nrnVSnRBWYzeXWXDAd11NF91xcAwuDAz754B4--VL-c6vTWuF21Jb5CfubB6Klfvj48KH6iBfFdjN_mltnuWRpzgVNNGhfIbh1BIgIQQXiFWfXui5NEjR_xtuxlrfhCSqGapeBqlnhj7uqfaoZT_esWeqw-8gyC_BPZRuqbvFgu66tMQFbpPmj8VUkkHBBBS0WxhS8poKtsuKGvCoWa37FyinZqSHoytQI8fxx1Vwi9gOLGLSwkMaQLzmLDZvvobQkdTkBk8MK3dfYqk63Yp0VpjsY7ytZ0GYvMIf1Tbi9QVid3anXNtjtHYRFss-_Qs_H_OeemEkCE4Eyn0Smhadyin1nAxYE2H-Zg0MP6EbHIOKdqn_B4xyeGHWgK1pN7Xfi5YH5KhM3ueG5Qsq8Mh4lSJtyLLQ6wJcHtNdA6qVN9mR0_qETMn90d3Xlu_jnoLoaKZRkkgKFNfFZdtaQObm1BB3hbItE_h4-XugBeTGenc7B-brd6o2llJwN_RR1nYSDqJQgCpc3kclcMFJbNdyuNtRMpMh07ZFrNEmj9n6dM-miPH6hSVlRc1sxcuQU15rFngFZ-kUNoQVQc6T6_LvWuiUDFb2utrQIgSyJeJqrDTa2eQFLnPwL5pFcXKzBqXiD_vjZmVFIqgYuXCITQKx1nWd6KsVNYpwBni7BjMCabpJUW0Jd2W--iegcVKIKnuylmbMku27T1LOPb1wiW1wnw7QWlRy5Fmsm0oAbR6lwXDDy85hfVRtE2LDOs0-92csXBP5pvVLdOag7HaDCrWqd7KaryGrVRrUdI8rmPNFbVt1DH7o42JtUaBZPknI9MIRKQB3tepPe7DV4Puf99cAmV7tbStYFW37f683-7PmB2fy653060xtgm1wn8vKFetgLorjO1LoZfVUQQfugnnFoXCIeF8k3G8pvhRJR-Qv7RDd5wlAxHoWm34UmtCiFMsCF_BXxTDLwOWHhODlPHxfQV3GMFuM2SP2Q_I0vxZqU4pT8IyvJq3QFxqU8JT9_fHV3aZVhokoLDeFd1dc3vdmPTBBK_rkFr6YdX1rQggmn0IGoPoaG6MyoR616GiG2IWjB83z2Ay_A3JG3oOBZcd7PZ-dr37ScryMMQOFcIiU_l-RdOiXfjtzRCQbxHG8ceFwwjl-Fn4zf1gitDULZy7vlEgNzcj94wTcMOwL0_VkwdV3y6qczjIeB6ocf739cIlWz6O7rZnXw9XAc31KxXDAHbRro4cBwqqI5kTRT0K5Ya5ffH1bBryUHc6F09YYWK56aXYFymdr6fK-ZHu3StY10258OvBNTtWnhD_YUhHvJ2wFZV3fo-RPwCQanwyH0OjrRjiGiUrLMbBPW3jrbsCxNqiMo1e6-ICOCt2ErilQO7h8KmTatnSB_p_qe-CMSUp5cIvGzS5oZPayjfsR5s195nTZoe1rBXachi-hC4A4LI961hIQqL17CEOwj7ghcJ9QREBTquMhyPMs6PIePFCX6HdN3IDTphY-SXFzha7SOnpFu4o4ZGft-qAI8uBeoqj1UkOGrRs5tCdMyb0RM6bqS5bSgokKsOv_yapVU2RGTZvC0tMpxgcvhV8_KQwg7pFwn8p7eVYtqI7qHZf_5sRw8P5bD58fy4PmxPHx-LI-eH8vj58fy5Amz7O8xJe4T5tnVVz6XWSbYoYyI8Q4hbJ4f18kKKlwnS_3VPV5MYuKfWHyks4WztHtqdeZPTiqPVW2R9UB3kqKgsTAKo7BKtbKpDyU5TnZpv1wihCqZ9SFcXFWX4Z86yc4e04Eoxsjc6z0OWb9Nvv9E2O0g3Yes54aPk63jB3130N9QcKMlE3szdYahyvu_0zz6OpR-cCUctfKb8h9O5H_1WacftsFsTmmohNq0pFOkb5d-eVu7Tfy0Ncie2862-IftQR2Qf1QVRvDzGxVMrHIjAiB9bYrJ__0vwfQvUkVI71wnsL3ZG_OIMdMz8ipJiOyhJFCDFVcsPnv5AvMDFWdouX6t0j3bzFZnOcb0DGVMjae3Z8i5j3qIydOHzNU-Umjuvb3HSOMcuFaykvANF3oP66lzB_VapYEsXCKZHKsPW6JUBrOrE8WxbgkTWjZZUYfXYYgfoIz8BIX6tyS0MnN0-2ZTja_n2VwnrZT1jl6fz6H2Me9NC_KaOUivU8_yuKZqDq0-BQ4k1FwiUumoMDaKTJtzTVww5iOWmOViw1wwMkOhxVIG23ydvM1SOk9YXFwd8MI0q9QYPeevqh9SbamFCI8_6EdMWqIrXXhBV6WcINRcXLysWpadoUwoacGB63wgzkoDppofLU2v1S9s7YsyfDsjQWYwNNLw8PywgxIYxCBYFWjuogHWGjRdPSpgbDJvVE_YbfD6d4d3F8lAt7sPrcMwd02WdkEao-iG1m1RtWFtv29D2u5lF07Mps-zQiyzhGdRXmS_gaKKYiDmSWmOGN6rYvKDVTyx6-H6qo7zQ7XGjEauqaRSKFgCQ41tFmsK_bJeXFyorT-oQqK5KHcbNtXMMp_IxOp6kaP47VLXSgNz_MwJanfLyLrWd9VcJyTypcFJ3pxAWRmoL86YzA1vh8gamV_j-paqKxo4n-0KD3Klpbr6UW65MPc-9179GDavfqSZOHidBS9-cFwnB2sq4f5iFhZt-bxfOMz4MdBAndcJ12vt0TBxDSZzxoqDeAyaeOj1vAcOmanvbEv9saG9UPhHQTGu0zjvAYb6ZEo9kKPQoEX5cGio9NlmmsBBWILjFs-wXjz_0G0_prCMDTrZ5UFsRk1sFkm2jR8SnfA4dFwwhV8YLchftzwRTwGXB7hMJvjm8JLSTkvL3Ng-W2Vzxg2yW706dG730JfqilOpgVSfG5OoLNg8Q1S47BIRveZC-uW49mUHqzzZlvg7UDYLph8IGLozmL_rNnrl6SpheN8smot0XCerzp8cIFb2vhF8y5cgcnvtJdomRdFtI-sWLLs4qfLWGd1E4EoXtCFwpfbIbAM52UvdlGZ5NYvjZ9nMOd--ag8h1TBUtsnFzcPe-pT3hJwFTRh-JO5YO3kMQlD34yVPlGP2PMHxJThz8JqXyj05uM4lOYzRlmF9q1LKsKPCG3oLXh_vqhp7ZNpqsy3VqNdZUWRF6IbRnK8OAel56tDWNq4H7O7EaFCZ01s62a33jc0qvptJ2RmCtemGXCLy5sOHdx-M6q0I9ccCqqR9PIpf85LkXDAy2dAbsqZXjIADlZJNdgU-elaQmCUMXFzmM_JXRsptwYjIyGLNFpfkBm-JljlLYDirM8Nt1Vkz8Rg1SfUK-7s9XhM8XrwGmHByKVlPOGRTXe1tHhKYC42hyctOM4DBfOhcMCudr4PZ20ysMdNyiVwwn_eh5DyffcyK4uaUzLeCpPo97FBhNmM9mbI9gkG48oy8TxisXVwiihtCV5SnBCzemqCok5gvl2DaUkEu2Q3ORHmGOYdm4ZU8ZuaGUTsHu_Fez3Xj_aR-LxXfhqlwU3NcJzropIpQoPIWLa6VmiNtVBu3rvC8ZYcCd9-Vp243F9bERsbtG1xcFv_XWSbDDMVid5jWXDDmcynIOyRWR-zKRFwnGhQ4MuW_oAorq-BJaOyyDJlIlrSboxycKKWWx2d8m05K422AXFx9Uxmz25q1_aPjWvWPaBVPxRK-uDy60eA4BLAeaMb0lmbVcaVeetcLO9vaDoZak-7UtslEGvwWRV5k8XYhHHCIHLMcKu_Ll_0o989BK-a0wy2hTaFfdvUadNNtU9EIg-C3pFCQRAE88cxyTNFplrYCD5sI_P0zXgskry1i4yo0W1iLTaJWrN9MZd-mDqY-Kj1sbPvs5YsWTdfrGZ4WYCbtryYx3a5UslxcBnBm1cu1Z97pBPTe7Oe3P7z5QF6_e_vx4sPPry_-691bUJKeJA6rhqprzD1QnWCApMbU5p4IROMajCbMJQN1-VHAs9imLP4TNBXOTBZ6Ixs9bMPzde71d1vBBlwndzKF3dlcMPdLSNz3PV8rF9Fvo7YoS_D71AejXCcjaOwvfIOKm2yL5NsKL_k1pDOVZ0dzXkrEoOp_qhzD799nOfhT8mjoFP7jpz48-PgQwEOADyE8hPgwgIcBPgzhYYgPI3gY4cMYHsb4MIEH-I_3Tr57-eLli3kW33x--UJ_uWlKXFwoVdnu6vnLyxdnWr5OyVktbFBH5iQqLqekp_nsnZJD6ZDNFk0jiPKUDN38E7y3EhqhbKDKGomMU-LLUptP9aydcCiyCKpCbyxLZZfXugOAq6P9kSRETndHrJj1g11mA9WrlJAp-WY8Hh_FeoOfFOPxieoc_5x1aSCcMC3SU0LnJahSwWRfSzmk__hOXTUBAbd_Opeo5-ps0ymRj6hn__tbB-hO6oJfVIGpucn-fb965b2qZfepdccqOLt492ghlfTnHWkJ1WzGvMwTChLOUznZc9jmXFxideNO58sI7x7XVmiC99NtD85vEclYibkD3Kb2LOoy2a40Td5Bg9vGqlfcQ1UNkeaBkI7cVfQNBtAa7lSstpW6muHEs8NYju18yk0gOrlNMJDVCygmP0nft2wEbPZAgv1adey9dBMXGd-AUqd2v-XXhJBQOtkWH6bNH7G8NO55m7TJh2vXaQxSVan4cDUflWePgsE3K6ksUGTq29MD-RFFdd_Iuu1cIm9oWZ8eGLvmXvaiUGYKCm-YOnfFWWi07ii_v6OLuql2DyP_UA-jdg_SWHZ3MHKHXR2Ek_DIIVjCvacHv3MIg8GBIchLdaaHhpR09xEOOvsYusf3UQq-yVKwfvv68EaTrj68cXBcMCm8fIlfP6gCPlVIs3XaUod9TWxGXCdRmGshlkNiff1Rv_1t92VVFe2GvFPWOii23qIjUQpaiNb_mUGLhKVx6960Sow5wOJkZ1wwkfbcaq9PeVZ2LZWUoaI4pcwsmkvEJvpLbirepsrkmXb9pRT0eHUOoHrvVXfyVapPVW_YlaVRx-d17XoG9E65bDHa8BtNNbyixVM5jbo3zMfDz7LEbAMbf_3d2iyvK335f1oZcII';
	$theme_options['Advanced']	= 'eNrtPGtv3DiS3wfIf-B1sECMtdySWv0c27feJDd3wOZxeeBucQgEdovdrbEk6iS1HW8mP-j-xv2yq-JLlFrddhw7sYGLx2OJLBarisVisVgUnfnBdPalnE1nvfI8zhY84UXv13I2nvWeLqfLydjDt9Gsl9ArvqnwZTLrLTdJchlHDF899R5iQcgSlrKsKnu_0pk3-xLPXFzZfM1oxFww81do4GlsYXWVCxzBrBfR4lxcoANKaHRBswULqzUgEySVompQVxlCPWhbAlAGCK4a5Htjb-JFGqeBcVYF2wXou7PePKGL87hcXIfzTVXxlkTEP4ESXlcJn9MknAP8quCbLEKmxyjN4awXp3QleAOUqrkoiiOrEARTsJzRyioDcea8jKuYZ1apB39pVdHFGsVrVSD78T_snqDzTvZQ9NBhnGWseExEw-AlHLVcJ05XNvJJXQ4khotNWfHUBhijutALo0kpR42dzzys9GH8GEgCBnDJkTiK5H4R7C1pGlwnV4qsM8DPtfqh2Da5UwP4XDD-ga55Sg_Jb4DvAv6WNCudEuhaKm4uaBFTKVwwwDF0Xa24FftcXDlVAfBLXti0A89IlaOlBNR6I9EKXCdPnDFnzeLVulJ1_khjTFhVscIpc7qIMyEuaOC2JexDm2I1p8_84fBQ_7pHo-FBT8mGJomDZMu5LDqRQxtIypRcIqw4XyVM6pYrKDt3TC9TOavX_IIVZsQMhFOw1SahhUL61FViGTWATGNUijGbU3cgoICbtReiVQE2zQhObzGAEwFBk0Pyryy5YFW8uH4IR7cbwsDdPYTB8NuGsGmOdo8KCsp_bIIa7xHUxL0_QQ0em6D8PUZhcI8aFTw6QQ33COoeNWr46ATl_hxBjR6boLw9GuXfk6B86Uj_vyW_Tp3KzfxnCWqvewcS2uQ5Kxa0ZLfRq-Fd-nl79Qx2SxU4fw9LfA_BO94tNcAFe-AVezRC2-s9jO5nckJbubE2Qho9BAvWnpj7Gd_Jnh8Y9iqezzk8pWFOo0ghMHMYdSxlUbxJQ0sc2woNdKuQSljFFfby4wT2XVq1WwNcMPNyTgvHDhhA3xFb0k1SaRYQJJyv6kDPRO4mMXqjd4AS5o5cIhnAScad-v32IQ0xLdS2tT1F9Bb2q8UBCrfmE0ov13HFtJZYIFwiwhE28EXRXDD-6XCHgF3TLEpYEcYLpJwCZV8EbBLPC1pcXKmWGBGJl1c6PKYqhRbSS1bylOnd-JKSJXVoUfBLXCfil1m9S5dN0HZAV6Xe4l8soIiI_zvzzXyeMD1eukWrb_WK9JIqdkCwGzmZBh0chYuEl-y7-QqafG3yO-UK44gtrhTZ9rhLdjrH3dsC0Xy3XDA1LrXwXDDoJs3COliLdi8cGV1KOK3AFOH0mxeMnuc8lloM8vB8Od_96S5Ap46xWfDIDxq7_fMVu7egWqqMQyWWXFz30B8EhwNcXG-nkwOt16rhnokStIBa-FGgCj-B_3BBXCfuka_iXSPTOGHLSmCQ5dDF8SYhi4SW5QnCOOgW0UXVOz1O4tPjWFdJXYIhWpw7HCr78el_8OIcJEjWfFOUM_KKZw55TysyOXJd4hAP_x73AcuTX7pw5WueMYnpOU0SMiN_9sgzLxgckGA4csaT6Vi0Pu5vktOWnApcXMcNG2OQ7X9VqVPyBSxcMA4G18pPWDCvUDNhUTnp_QZGj1Dy7xsO8iTlmuZQWP73hhbwii1OeptcIpn9yR_88ccfvU_N_vaoUtABs0OLEB0Sc53dn9pwP8b243q0XDBzzwpcIpf0710JUOOUOoqfI9c7kLbB5q6p7tCkFhzqs4F7TFtCaObtDINi5fB-NoVCE7XAftbucIw6Z4Led7rFCe5fajiDo0WxSecPT2o4GRc0jyuaKIE9kIjNwBLgRcwuO5zdYWMqW3NhoAgGeCl73CysdlmEkYYSI9SxxlwiyWyAP8Y0m27x6LZurfq_YqV2Zso1v8QNiIIXTpM-SlO2SGuJ2v2oxVwnXDDZ1ksbLDoVW1SfYS1Ez8ahGQhKOpVipdPyoNFFWCG2Ba1osdB2_zmt2IoXV-SsWKzjCwbL6laLiq50i1wwj-ZWLWB_YAGDka8EafEyZpEWy1soLUldTmB9YYXqa2I1p5tqzQvdHcj3TBS0yRvo4--wK_w1NLW7x9ZvwHSMq3WEDS1hxcFplYS60UM57P3m9XAwwP7LHBxxEGi4Xwj-wB_6C21kFKzVere_LY6SV1xcpyPYwtFV2pkCnZIarIwMVj6mVWRfzMcff7sR9F382WsEx1JK4viegmH5XCI6k2oGjfypPFcQO0GwPg54mlKhcBSrKi9n_b44wAfbsU5BjaujBU_7l7yIchjesq9siv7roL_Yv5TOOuhif5NjokDZB51lZX_YB4oHfXfSR6oc8Dg-B5OjXFyyqZJZahq8H0CD7FxcbQ2FQqX0c9NYBIE2xQ1TEpagL-dXDYuC1kIWhx2Gpb0tm3YB79qd-d6h_A92Z6MDoyxycA0t7TGulbExvrU1sSUuSr9KLlqiaDIrJYKh6pKBCV6HcZbLPS82_VwwU5nAFixcIh_WLCMv0Xk_OtK2RrbAyaKjarUZ87SIy-oqMRlO0v0XCoMGDDbYTWCz4Ck0frMmpHNoJiMbO2HmLOGXbZh6xLEmtA0vKEthVMTFzJ4lrFxcYGB0GFwwd5CCfk_tXDBZcREv2Jx_Jmv_pIf7yh6JRRbWiQmcQIEwlOr9ZCs8w-cxyAXA6mUlFLI66YkXFjl8U6F1aQEJfTqx8sygGi0TFKU9sg5Oen_2_AFub8dkMvVcXLnP7OSsupQWdTLt5OxlSuNbsAYzGtcuh4Jndi_8IR9_YZ9pmlwnDO2H4tDv4nBdMGmz3VFcJ49nUYSG59u5TDh4VaBCTh5n98Mm8QPyL_GyWpOyOiR_4yU5y1YsYeUh-fj-rGtYRbTDzKER6OsxJSCB5Unvae_Ujk5sxVxcaMEqR84D4UMe9-mpnudq5jSiOiNQmeP89EVcXIClJq_BILHiuJ-fHq99jTlfhxnvybjLx5K8yWbk2dgdH2DcyPEmA--4v_ZN0EU7Go2gyzAQvbxZLmHIyJscbNCHOGXYEYGeTgcz1yVnr47IB07AhsHL21fEoEUvVKFVgb39MWLLQoA4aHPpGJldhDRioTCrgLdaK0ffH5kQzDIGu1wnTU1Ki1Wc6b3IxO8yR_bK0iBqvA3XXlTaPt_AO9BNmyvS3p4GwU7wdgzQVR16_hTWsOHhaAS9jg-UXCeDUikZ167s2lvzlPEsMacNEu-uUBcKL2UrilBiiSjiOttQnvY0mu-IgiEgjTMEfnBO5U0Or-_YuwTXMrrmPAk3dFIBbMHtwIK7Iw0W0kWF2wIMb9ZaEshEaKFag13AHZsPKzUY-ogKnuO29kGO454Q02D38Hm3CDENo9FwfM3wKWndeES6gTtGZOL7gYx1oP9qmv2omLFrYsYVz-_i6FBrmNJ5rWLS3pUspwWtjMSMf-_VZsmsJfog-ZGF70Y_PHyH0utQnNB7eEnzZt-0g2T_8ZE8eHwkB4-P5OHjI3n0-EgePz6SXCePj-TpAybZ37GUuA-YZldd7VtyXu07oDB3XDBrQIwt_aAzefmnm1_Mj4k_s-iGftaO1E9_emCcVblDVoxu5dtcMLIg9FXGjdeCviatoQ37A0V4N2kNYq_F8KfO37J52hPEGOsbmvslG4SBCXE3wHefnbkdoLskOx7LaP-s38coWbLmZTWbuBNPh_UHdkhfnAfUkX-BpezLXpz5Sh8pfP84-SrQu1fTbzSza_0OBod-MIbfqXXc5gdtYTWHzLqni5hUfuv12i3u1baBH7aF2HEv1VbvoM3UHv1GU6AVO7-SsUIMSwo-gKvnupT87_8QjPYuNkWBsegrRotPxERDRSAYkOJxyafeqXkVe7pPGPs8XCJnSUIErpIUDKPGLDoyGYBtXCLMCUKAeWLHUXxhHdbTPMdlKncw6AzvlwXNe5iw1gRDvmHntspMHJYSFUpWuc-yYkaG-edfe3Vg9zhOVxpPj5TF4uR-D9uoXCcmJaFJddL7TezzyFswMeQ97JxZj4ig6AlG44BIsb88wUR40hdRZeCb_kTafYv2szzfotm3aJ5omo_7MFRIufhrklxc-SrOrouEjEffbwxFR2gLf89XP3JS3zqygoHeOVAt53ISp3FlxxAGnqyWySGLUOTFqGOjMBNnCeaG-URhwrSaFIbKnA1cMIvvXp69IK_evHup3gWglR-k8OugBlbDFFSLogrJ69M9v67XGMRdbLAujhlMTQ1CNVnDpDvP1akxmBETykxRYI5cItX6gBQk8x5LtD2z5Vww6k4BZSkCnb5KzGYZnVwnLDIHwjDOMmNGDfqZeRHrSqU_BfFCPWLuFF2pwg90VYoRwqUlLg1m0RkqhVQX5FxcpQnFMn0JpSkHSKnTc_mG2L5Kz2OLEyQGY1MNF9sPOiCBQAxAmkB_FwyQ1oDp6lEKxgbzxvWIXVwnXlHULcR97G8J85ph2lwn5q7BUj5gg4tu0botqLZY2_VtkbZ72RZcJ2bK57yoljyJeZgX_HewVGEEwHFS6iOet7KYvLCKp3Y7nGB1XoCvUhcu42qtPk6Ba2wNLsxDwRLgObJprSFUZT3L0Dy_k4VEkVNuI9bN9ISfijzrerqjHm5D1-YDcw7NAXNcJ2YkXVk-88WFfKkFJq5HoMYM5TdedMqHtwVkcebXAn5NU6YHvt3gTu6tmPsd5SauzKWuXfc7Rs37HRmv9t5ZwdsdsZPD8inE_VXPPdrafXyNYcRvXCIadFwwk1jN0XuTiatlMmes2CuPYVMeamLvEIdI3Hc2pfq8z05R-DcSxaRO87yFMOQXRmpGbiQNWpR3XCcNmc7bTLLYK5bBzSbPqJ48f1O471NZJlo6_HyvbMZN2SwSvonuUjrBzaQDUvg7bJTIXzdxUj0EudzBjbEqTvdPKeW9tJYb23kza86kAXatezdwG_AxpmnjhdZwXmVbGXP-dA-wXFyCGwHJfAmDv3PlwlVCQnSvVjUGa4Wamox2RtMQ3NuCNoa-VE6SvVRNd0I39erl55zhYeaC6fPPXc3uQr-AVZbm1dXdXrIUGfoO7OEYfgLtpivWTSQEbd-fx4n0lR6ncHwhnDk4skvpKOydcQIceLR1WN1tFDrsyJCQ2hbXR96yxQ6dtnC2tRotLCsKXgRuEM7j1T5Bep48yLaXuT0r4FTbMpGWWzr82uu9ehZ_m3HfYsHaCEMRefnu3Zt32ggaQHU73iTeg9v8YR2XJAchk5RekTW9YARcXJmMpLCxjwgvSMQSBs7rEfkrI-WmYKTiZLFmi3NyxTcFKXOWXDA7qyNNrelMJgTbuzhThf39hIuGdxPdMPdem-cZ-rZhoFOhM16wUl9IwkbH68Hpaw7bmmxFlsj3cR9KjvPT97worg7JfFORTNXDXg6EHCkZC3wEaE_LI_I2YTClSFVcXBG6onFGcKtEUANJFC-XDEOc5JxdYXisPMLsSJPUHUdMX9FpXCc7N-rVEDTqp3W9sEcpk5EZITMddsUdYQdUKFwini1YVOGaXCK11qnck4zrzLItCNynGlfWRhfUwFr1LFxcNv2XnIv9e7HYZtNiYD4X0cUtEKsjdqE_5teAQM6kQ4CWpTRhhkAvl1wiuCBIUn6DzEMOM2q5RJiXzM0HPFuQ2glcML16ataY69Diqlww2qJcJ8ENsPo3wIoHeEm8OL8x0sHNJIDtwGBl16CVXCeraupdLhyZsupIm17HDa1Bd-olQ2_F_RZEXvBos6gc8FMcPR2MU-SLfqRX5uDi4rTjEYENoSq7eh10w22yqhFcJ8AsUVSkqlwwmmJu-YsYPBUmHEPbBP5-xHt15LkFrFfwJoZ1lSZyxvrNI4pN5mCCpuBaR6Lb5xOb7mpxdII5v59MiNxqVLJcXEQ46vj52tN16upw7_Tj6xcv35Hnb16___Du4_MP__bmNRhJT1wwBwaRuWrcA9OZMmkx1SpMKpTGJaxlMJYMzOX7Cp6rTcaifwJUgYnb2_F7HK-meK5ZnCbB98fxGx1-Uzy_Oz_hdtmRO87k7MRIvy2cRVmC1yU_VTwdA7K_xCnaZ7IpkmfmxEZ8fOdIZv7RPC7FmQ00_WeZ-XjylufgzSCV7iH8xoc-PPj4MICHAT4E8BDgwxAehvgwgocRPozhYYwPE3iY4MMUHuA37h38-uSXXCe_zHl09eXJL-qwbEZcXCiV6ffy-euTX46UGh2So1qnoI3IkpRUzkhP0dk7JPuSNJsYNRKU8oyM3Pwz1FspllA2lGWN1MoZ8UWpTad8Vi4wFFlcMKbQm4hS0eWl6lwwxNWBfyxcMJHSbY4lsf5gm9iB7FVoyIw8nUwmN1wivUFPhgHqRHaOP0ddhgYHTKn0jNB5CRazYqKvpWDpT_BM4B8ouP3qnKM5q_NfZ0Q8ojn9z2cOwB3UBX-XBbplyv9xu3blrZrx27T6xiY4uniGvRC2-MuWtgRyNKO4zBMKGh5nYrDn-KUVbK695nwpbkHVi80U73HbjprfAhKRCp2W3Ib2LOgy2awUTN4Bg5s20yvuYAxcItI8IVERLAPfIFwwF72thmZTp5ppSjw7nOPYPqbYgqEv2xQGkvoBiskr4eKWjXDJDpFgv1Ybe1wn25SLiC5AqVN72eKLOggofGmLDo3zNywvtRfeBm3S4dptGkzKJoYOV9FhHHhUjDhdCWOBKlPfPx6KT_XJC1DW9RtxZcz6AsPE1TebF4VcXKb0ZxG-ylFoYHeke9_RRY2q3cPY39fDuN2DWCy7Oxi7o64OgmlwQxYs5d7Rg9_JwnC4hwVxzU_30NCS7j6CYWcfI_fmfZRVnPIMVr9dfXjjaVcf3mTQ6kNtyFTUR1xcqjTRFhNPbB06xMKptkNaKqtAX1Gx_BEdTglM7e_blaYpLhvijlvr4NSqRT-irGhRtb6T3wJhWdS6hiwTQvaQON1iIFSOW-30ScfKbiWzFGQIpRSpUHMhsan6apkMdskytA3yMyPig1G6WBz91t81QXdX5SqqZoPW_T-7Qt0IrKM7ro4eiBYyGcr0NOpKf1A7uFJD4SZmRyi9DWqNutqDly3hNFxcVd0Mr6jFmVAdRRg68PiFloilPNQfZuV53ejr_wGcbi74';
	$theme_options['Demo4']	= 'eNrdPWtz2ziSny9V-Q84TW1VXFxrSnzpObZvvUl27qo2yWzi1N3W1ZQKEiGJY5Lg8uHHZvKD7m_cL7tuPEiQomQlsTP2jZIRBTSA7kaju9FoMHTmDv3Zp3w2nfXyyzBZ8ohnvR_z2XjW-4E6ruP5-Gs060X0lpcF_pjMeqsyiq7DgOFPR_2eY8GcRSxmSZH3fqQzZ_YpnNmy-YbRgEHPn6GBo3ubF7ep6MOf9QKaXYruXDATGlxc0WTJ5sUGOhMo5aLKq6sqRB1omwNQAh3cNtB3GX50nxWMtc5YDWjPevjlwvdcIqLLyzDfzBdlUfCkDeJAn-uIL2g0X1ww4DrjZRIgmWPk33DWC2O6ZkaDsSoKA6MQWJGxlNHCKAMGpjwPi5BcJ5rMJfCQZUR-iUKApUVBlxtkr9EYyQ__aY4LqDT5MMGPZD0MHyYJy54uCTCVEUdZCuO1OTuTuhwQni_LvOCxCVwwaMtCkJ2koGGCWC1mDs6-u12H4lxcbBR6jufZohNcMFxcM6gFIVhxJIJcIlmfBFNWNA6jW4X-GxQ2zQpkdplaNYAL4Bd0w2N6TH6C_q7gO6dJbuWA_0pRfUWzkEpGjZHl6zKilcgX7KawigzarHhm0gn8QcwszVHA2BmJVrjsgDJrw8L1plB1yFXZY8QKmCgrT-kyTARroYHdNRvBED-aHzSKLERVrnrRqRQCX2KiRGbN-TpiUgptgcmlVfVazU01lVW1ZRCOg6_Ef3pGDbgNv2IdqssB7DfOHPUPkFXN2vQrJg3wOocpiY7Jv7PoihXh8o5pg17Gtr17ypARS5qGBY3UbHXMnm_vnr2h_eWzVzNw9wQhz9xcJ8wzz9vNM997OJ55T5hn7h4t4Y0ejmf-U-aZv4dnw4fj2fAp82yPPvMeUJ-NnjDPnOEeC_5AcuZKp_1pMmy8R8gmD1wnZHm5eJQ8Aw6VacqyJc13itjkfp3EA0UM_W3wHL8vux6rO72bU9AW9iNrVjwuudrNpL2W0X8YcYK2cuteMWn0iJi0n96dVLl-RVXB0wUvcJea0iBQHVTWATexMQvCMp4bXFzYNlwigK4K0syLsMBRvhOfvnHVTfZPPuC4WtDMMsMQMGLAVrSMCk0GgswX6zp8NJGRXCeMCendooTZHx9xbOh7UxRpPhsMRJiqYMtNDPBFf8njwTXPgjRjeT6A8uKGXCeDgMXcH1xcp5bSeLJVXS-6zge4iY3orSWmBulZrPu_puvDgjHAtoRb9e9WVEYL4gFxGLH81H66vRTHgJftVTZPsAtnsmYqlF5vwoJpsTRAdJTF1H-B56kN21jBbmgSRCybh0vEnM5EiHKMumSR0exWtUQOhqtbHeFTlULs6TXLecx0mGBFyYpaNMv4tRXw66QOH8gmqKNgqFxchx-ullBExP-tRblYREwLh27RGlv9RHxJEVrA2FKuXq-Dovky4jn7Zrr8Jl1leq9UYUS0RZVC25x3SU7nvDtbIJruFqDuSxk4XDAt42Rex5uBhaP5qJKliNMCdJ9YGxmjlykPpRRjnM6Vitid7gK06jiTAY_0oHbdrxxweAOqJco4VRmM9sI-dj3_2Bse2_3p5EjLtWq4Z6H4LaBW_8hQ1T-BP-5wCN99d3ikp101jtiqED3IchjipIzIMqJ5foowQgHRZdE7O4nCs5NQV0lZgilaXlocKgfh2X_y7BI4SDa8zPIZAYNgkQ-0IJO-bROLOPh9MoBenj_r6ivd8ITJnl7SKFwiM_JHh7xwfO-I-MORNZ5Mx6L1yaCMzlp8ytBfqMgYw0z8dxFbOV-CxbEw6pf_ggWLAiUTVOVp76fXF-Sc_O3ju4vXPZJvaApl-T9KmrEewQanvTKLZn9wvd9--633S3O4PZLkd8DsEFwi7E6p7b02ZmrC3VMc_g7VbwTkpQvxrYZcMAVOSaP49G3nSKoGk7qmtDeivCjOFdyj3DTt9kWGe8KLw4fZKwk51Oz6vbaZD7hv8h-ea7h-g2VWxovHx7VvjwI9UFDDMxh4FbJr1RbUOdqZynbWC1nj5GEUfqj1ouQ9bk3Wu_TBSEOJGeowsIgy8_BTKeZqWDx6rlsrniTcUDRaCNRWShkW7RIPxcnyvECQJS1ottSa-iUt2Jpnt-Q8W27CKwZ2cKtFQde6hY8He-sWsOsZwKCWC2Emw1XIAk3Kz1Cak7qcgEVgmRprYjSnZbHhmR4OeHIuCtroefrIfd4Qk6lbnYnJ2jvcHQNql7uDjoj-ax_pqQSTgSsjmuseHvS8-R52NjsNmufh-HkKjjTwd34IR5xj-QccwNGRVhqqodHVbudZHGavuU6PMDmlq7RnBPImd5BKaWDlfv0G2ivmj8Yq7Dt2csdfrtRcXBs_e5XaWHJJJBBQUFSfxGBS5nxUpY6rkC02oE0s8BuldPnfuucvU8xRyAcgubDXHw1cMFV_YDsDRMdyLGdo3zi-208liSqxRo8_HT3s8HJYtbsTYhTTm6b68MdabnKQi8vbuU7rUXkUdkvrzCVYQ_mgWmm03quDpl3Ahy88ITtyritcXNpTXstmY7prTWNOgij9LKlo8ahJrGIVEstAW2_mYZLK_Sw2vYCVTWB7FZCLDUvIa_TM-32th2QLXFw7OkRXqzhHszgvbtUG3tG-PWzik6AJVVm6iQ9ifxKEV3qPJustrIc9Eu3hJs6oTuiVDGNgOezPnj8j_wKbPF2dYpINiFEM-ztKNhlbnX6NcKq9qFXmg97ZS_mDfMxPBvRMbywHYvCTAeDWQhH2f4oI2AZa1xnFI442HSrWyTNLPRG5bVRZI0Ll6lwiwVKLlwWqoqoQt5KWMF1glqEQ1bYFfto6sdAHXCL1CDKCsVVgSadjN2ayvqZcMDi6CwZ3sqRdahSgZrXioEcyjptiNfI9TdAJ6N9kXCdqSssYZOwFF4J59p79o2R5QSj5WwlG7WSAbe5oKeJRdamcCjErXCJqIPjcCkXQBJS_qiZouixwGQOWgBBlpYpRoJDJ0fUXCqESu85v7V4aS21OF-BdyPhfnV3YglmwiF-3YWrdiTVz070RBlB62wgWJivwFsFw61gZhlmEn-ioMAnLrsIlW_AbsnFPexh86ZFQZFueVtFFKBAOiPp9uhXD5IsQFAyA1b7bXFyskNOeWg16qbSAxMo6NfJJoRrlEopiEEX_tPdHx_UwBjQmk6ljy2hMXCdlxbX0VCbTTspexzT8CtJA4FF2QHKKh6EP6fgTu6FxGjFcXF6KQreLQlia0heyR500ngcBrssvpzLisJMBCbLSMHkYMonrk7-Eq2JD8uKY_JXn5DxZw8LMj8nHD-dd0ypCgpVNGoG8Vtbjh97ZT-DkV5qgHZgEI1XoBY7LFZenNphq4TRCnyMQmZP07FWYgUIjb8Gys-xkkJ6dbNzKiG3msEeUwcmPOXmXzMiLsT0-wuCq5Uw852SwcavIpHbgG5HJoS9GebdawZSRdykY84swZjgQgZHOvJltk_M3fXLBCTgD8OPnN6TqFnd-qlsV_d5_kGIoCLTZTedsVO22pTcwF_5Jlcbqoa9dBSpXITgQUtPENFuHiQJxpO_c1kami9ZAarwN1_bO2hsrzznSTZuu3d6RPH9cJ3g7UG6rAR13Cs7g8Hg0glHHR2qHgFxcyRnX-8WNs-Ex40lUnf_JfncGhN0tiB3hYASkYYLA_1-idA-TBuhW-wmTXzt6weCCBpuDZ4IbaXSK6vn35VUGITTeLuCO2FIzszjIeIpHhfunDxgo1vwHmuT3G5oefV1o-r4zxQ5ITnEVtw6ekW7gjhmZuK4vo324xauafa8zE7s6Myl4eh9cJ-dawpTMaxGTmixnKc1o0X2SGrM1FVDaTOjMjVwnFsH-HZSL0yk5c-d3jkN23HSpYgs7UHafHsre00PZf3ooD58eyqOnh_L46aE8eXooTx8xyu4OU2I_YpxtdTt3xXnRirWjHRY2HBwP1Xd1mbcGx-DRd0pN2XdXFLPEwhsWHOhu4VxcbR9P9t3pUeWzyi2wXCK0K-tsPB9WmWwm7F08nG7Df0cm3k9-D3pXNsNPncdo0rRcJ04x1petD-Gt2wa-g7koz1sNHpy7KEzoqn77beZaLn3v2PXH8HdqHDa7fpu83YxGrBRQdRaEh0f47OixVML44czdavC41_-OC-Om6PptovbIrlOxdMnTWxnqqxJdkD0vdTH53_8heH5KvuX4q3emDu_JK_hNfIxp9sl5FBExRk6gDcuuWNCv0l_b2GV6C4WhKwwfSwi0Ub9UCcF8HSZ3bZu__Xi5O6NdDH6faexf_XKBA7fmyMgFYC3lJArjsDD3oGhcIkU1phvFPKvD2YD3-9fnr8ibd-9fq98CUOdN4Wac3-hdLlbBT6UdVb0-73Dret1aL-2RiQQCNNHEGK7TRDRgBQ2jvNYSKBOqtSVTjpauzlPC9KS5zLOd5xuK5OkjaODLByzRKwW7UM3nIC4UkMhFnMxVae0soYuIBdWROwwr05cUPefVD_ECkEK_C-SVesRQtjyqUWLwUv7KxTxhqkCYVyOIQVE0pNCgQKjcrZDlmr10rYa4oGvs5bO0V1uUIDIY2Wg4aK7fAQldYvyqSoHoggGUGjBdI0rGmGDOuJ7jXCfMXq9FRTdr7RZUm63t-jZL26NssxPvGaQ8K1Y8Cvk8zfivoKf02tAK9GdZDOq4Lp6a7XA1NjIvMKNeJeNqHV1D5xt-DXpcIgKSAxPVGkJV1osM1-Z7WUgUNvl2x7qZVg5TiUilzFEMt6FrVYM5m9XBY2fPiLpSe57mTrqqdIk4LwSxGMp3_OicGmcLyKDMrfn7lsZMz3u7wb1cXPqpLsfkZVjoa687L8eMmpdjEl7svfCDV2NCKwV7Ktj9WS8w2spq_RzCjB_CGmjzMgoNL-xBeGJrniwYy_byY9jkh1rXO9ghrj1YZa5e77STFe5BrJjUKbdfwQz56piakIO4QbP8_rgh06Gbh-972eIdtnhG9eL5q-r7IYVlornDL_fyZtzkzTLiZXCf3PEP4w5w4e-MZuTPZRgVj4Ev93Ddrgjj_UtKOS8tc2P6bpXNmTTA7vTuPLsBH2L2FF4_ni-KZCsl0Z3uAZYWuBHNSlcw-TstF1oJCdFtreoeDAs1rW4EMBrPwR_OaGPqc-XBmKZquhO6KVevb1KGXCdhS6YPz3Y1uw_5AlJZnBa393tDVVxcgbCWNGL4CrxDLdYhHIK2Hy7DSLpKT5M5rmDOAvzYlXQU9q44AQ40mjKsLoYKGbZkrEHtievzUtlih0wbfbalGjUsyzKe-bY_X4TrfYx0HHkKapq5PRZwqnWZyHvOLX7n3WjjuswXKPctEowNMxSR1-_fv3uvlWAFqN5lUF10XDC3-WIT5gQzj0lMb8mGXjECrkxCYtjVB4RnJGARA-e1T_7MSF5mjBScLDdseUlueZmRPGURkLPua2yrwWTGtbmJq6pEpvP3v6Z5P6ENZL0IN_qjY_nHPrLlpPg6zzzhGcv1OxLQzJ5svLO3vNjg1d8V0nwygJKT9OwDz7LbY7IoC5KoetjGAYMDxV_RH8HwU95cJz9HDJYTKbJbQtc0TMh1iJmCIH0kCFcrhlFHcsluMbKU9zFjrsqYDwOmr0opiuowl1mv2N-on9b1QhfFDDP_2mm0w06oOc5x2oJFHtYYKTvXvGI26oDALWrlxprd-TWwFjujLxP_a87FBj1bbpNpELBYiMDcFogxELvSr2dsQCBl0hlArZJXEQZfm0qx6xcoKZ9B5qbOE2q4Q5iryquXt7YgtQNcMHL1Q2Vf7uoWLQJIi15cMAf06h7QK575ROHy8uBOvcM4gO1AWSV3dCuP5NTSu17quwtSn6uQD_RmTLpVmwu9DXdbEGnGg3JZWOCjWHo5VA6RK8aRHpmFhsVqx1wifBNCVXaN6nXDlUnRiBHge6ZQkIoMcAq54St6jlLfePeIwPdHvN9IXhrA2no3e9gUcSRXrNu8v1ImFqb2Cap1CLp9xaLsrj7DODnmgf7Sda0kZ6mIbtTJ_xvHvDSDkZ6zj29fvX5PXr57--Hi_ceXF__x7i0oSUdcMPtVR9U17R6ozphJjaksMCmQG9dgx2AuGajLDwU8F2XCgn-FrvzuywZ-mz13vqfGf5iofgOLL4ru73hj8Fcl2-04_THz7Nw2x5Z5Dm6YfHf1dAyd_SmMUWmTMoteVLwS707qyzwymoa54BY0_TeZR3f6M0_BvUEs7WP4Gx678ODigwcPHj748ODjwxAehvgwgocRPozhYYwPE3iY4MMUHuBv2Dv68fmz588WPLj99PyZes_TjNhQKvO05fPn58_6SraOSb8WNGgjcu4kljPSU3j2jsm-lL9mj7oT5PKMjOz0BuqNhD0oG8qyRqLejLii1MRTPiufGIoMgKrQmYhSMeS1Glww2NXR_1hcMFwiptsUS2RdbxtZT44qJGRGfphMJgeh3sBcJ8GAdSQHx0-_S_vghCmRnhG6yEGNFkyMtRIk_QGeCfwHAm7-tC5Rx9XZlDNcIh5Rx_7XCwvgjuqCv8sC3TLm__y6dvlXNeNf0-oLm-Ds4iWYpVDQn7akxZezGYR5GlGQ8DARk73A99Zgc-1GpytxXaa2QFO8ZG96b24LSIQudJJrG9oxoPOoXFwrmLQDBndx1ai4pak6XCLNExMV0qrgGwigJdxqWO3yVDONiWPGdyzT8RR7MnRwm8xAVC-gmLwRfm_eiJ_sYAmOa7Qxt7ZNvohwA5Ratest3k-EgMLBNvDQff6E5bl2zdugTTxss02DSNmkwsNWeFRePQpGGK_lLUk8L6rOzobiBYv1C9_VJQ5xt8h4pcXE1lfLl5k0U1B4y-SJGc5Co3dL-vwdQ9RdtUcYu_tGGLdHEMaye4CxPeoawJ_6B5JgCHf3CL4z7hxhNNk9grgPpkdoSEn3GN6wk03evolojZEXYcwTsH67xnDG064xnIm3h1N4mQ-v31XxlyrC2DqGCIWrbQa5VJKBvvJgOCQuaqV--8Zrf-t-76fa5jloi1Frbt107ndda-53XmveGhK8ikbrFWjpA5uST1LxL8C3BBObgZkuczDz0sR-1npDUf9rTbwRXZKVaBfFba_WSbFRi45SXtCsaP1bEC0QlgSt-7gyXCemYwp0XCfTrQmaK8-09mql52i28vBfP2AyaJSLrKKFkAhcXLk0oFfVP2sSi-Fk5VS9AU_G_lQDwFHE8-Xbx6pifLELvu1Gv_tGV4gT8vr9Obg1UImAdb3sr3oXjnhvYKNjebGuDoZpzPX1EwtjTFlYY-5UL3OQaUe63Gulh4iRVbLBPCnlgleIjbqSTtTmOTc73HGC0QY1lpYKf-StGWpsCHQzvFcWJmJ9KsR8xWrcEs31i4p5Wjf6_H_AS3_z';
	
	if ( !function_exists( 'tm_cs_decode_string' ) ) {
		function tm_cs_decode_string( $string ) {
			
			// decode the encrypted theme opitons
			$options = unserialize( gzuncompress( stripslashes( call_user_func( 'base'. '64' .'_decode', rtrim( strtr( $string, '-_', '+/' ), '=' ) ) ) ) );
	
	
		$demo_domains = array(
							'http://tectxon.themetechmount.com/tectxon-data/',
							'http://tectxon.themetechmount.com/tectxon-classic/',
							'http://tectxon.themetechmount.com/tectxon-overlay/',
							'http://tectxon.themetechmount.com/',
							'https://themetechmount.com/wordpress/tectxon/tectxon-dark/',
						);
				
				// getting current site URL
				$current_url = get_site_url() . '/';
				
			foreach( $options as $key=>$val ){
					if( !empty($val) && is_string($val) ){
						if( substr($val,0,7) == 'http://' ){
							$val = str_replace( $demo_domains, $current_url, $val );
							$options[$key] = $val;
						}
					}
				}
		
			return $options;
		}
	}
					
		$new_options = tm_cs_decode_string( $theme_options[$selected_import['import_file_name']] );
		
		update_option('tectxon_theme_options', $new_options);
	
}

add_action( 'ocdi/before_content_import', 'tectxon_demo_before_import' );

// Disable generation of smaller images (thumbnails) during the content import
add_filter( 'ocdi/regenerate_thumbnails_in_content_import', '__return_true' );

// Disable the branding notice
add_filter( 'ocdi/disable_pt_branding', '__return_true' );


?>