<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/* Getting skin color */
$skincolor = themetechmount_get_option('skincolor');

/* Dark BG color */
$secondarycolor = themetechmount_get_option('secondarycolor');

/* Grey BG color */
$secondarygreycolor = themetechmount_get_option('secondary-greycolor');

/* Blackish Button Color */
$blackish_buttoncolor = themetechmount_get_option('blackish_buttoncolor');

$button_topbottom_padding	= themetechmount_get_option('button_topbottom_padding');
$medium_button_fontsize		= themetechmount_get_option('medium_button_fontsize');
$special_element_font  = themetechmount_get_option('element_title');
$special_element_fontfamily   = $special_element_font['family'];
$special_element_fontweight   = $special_element_font['variant'];
$button_font = themetechmount_get_option('button_font');
$general_font = themetechmount_get_option('general_font');

/*
 *  Set skin color set for this page only.
 */
if( isset($_GET['color']) && trim($_GET['color'])!='' ){
	$skincolor = '#'.trim($_GET['color']);
}

?>

:root {
  --tm-skincolor-bg:<?php echo esc_attr($skincolor); ?>;
  --tm-whitecolor:#ffffff;
  --tm-secondary-bg:<?php echo esc_attr($secondarycolor); ?>;
  --tm-greycolor-bg:<?php echo esc_attr($secondarygreycolor); ?>;
  --tm-skincolor-text:<?php echo esc_attr($skincolor); ?>;
  --tm-secondary-text:<?php echo esc_attr($secondarycolor); ?>;
  --body-fonts-color:<?php echo esc_attr($general_font['color']); ?>;
  --body-blackfont-color:<?php echo esc_attr($blackish_buttoncolor); ?>;
  --body-fonts-family:<?php echo esc_attr($general_font['family']); ?>;
  --body-fonts-weight:<?php echo esc_attr($general_font['variant']); ?>;
  --button-fontfamily:<?php echo esc_attr($button_font['family']); ?>;
}


.tribe-events-calendar div[id*=tribe-events-daynum-], .tribe-events-calendar div[id*=tribe-events-daynum-] a, .tribe-events-calendar td.tribe-events-past div[id*=tribe-events-daynum-], .tribe-events-calendar td.tribe-events-past div[id*=tribe-events-daynum-]>a,
.tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline.active,
.tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline:active,
 .tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline:focus,
 .tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline:hover,
.comment-list a.comment-reply-link,
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child .tooltip:after,
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child [data-tooltip]:after,
.vc_tta-color-black.vc_tta-style-outline.tm-center-tabicon  .vc_tta-panel .vc_tta-panel-heading:focus,
.vc_tta-color-black.vc_tta-style-outline.tm-center-tabicon  .vc_tta-panel .vc_tta-panel-heading:hover,
.top-overlay-icon-box.tm-sbox:hover .tm-vc_icon_element.tm-vc_icon_element-outer .tm-vc_icon_element-inner.tm-vc_icon_element-background-color-skincolor.tm-vc_icon_element-background,
.vc_progress_bar.vc_progress-bar-color-bar_black .vc_single_bar .vc_bar,
.tm-col-bgcolor-darkgrey .tm-bg-layer-inner, .site-header-menu.tm-sticky-bgcolor-darkgrey.is_stuck, .tm-bgcolor-darkgrey, .tm-header-style-infostack .site-header .tm-stickable-header.is_stuck.tm-sticky-bgcolor-darkgrey, .tm-header-style-infostack .site-header-menu .is_stuck .tm-sticky-bgcolor-darkgrey, .tm-titlebar-wrapper.tm-breadcrumb-on-bottom.tm-breadcrumb-bgcolor-darkgrey .tm-titlebar .breadcrumb-wrapper .container, .tm-titlebar-wrapper.tm-breadcrumb-on-bottom.tm-breadcrumb-bgcolor-darkgrey .breadcrumb-wrapper .container:before, .tm-titlebar-wrapper.tm-breadcrumb-on-bottom.tm-breadcrumb-bgcolor-darkgrey .breadcrumb-wrapper .container:after,
.tm-bg.tm-bgcolor-darkgrey .tm-bg-layer {
   background-color: <?php echo esc_attr($secondarycolor); ?>;
}

.tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline.active,
.tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline:active,
 .tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline:focus,
 .tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline:hover,
.comment-list a.comment-reply-link {
	border-color: <?php echo esc_attr($secondarycolor); ?>;
}
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child .tooltip-top:before,
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child .tooltip:before, 
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child [data-tooltip]:before {
	border-top-color:<?php echo esc_attr($secondarycolor); ?>;
}

@media (min-width: 1200px) {
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child .tooltip-top:before,
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child .tooltip:before, 
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child [data-tooltip]:before {
	border-top-color:<?php echo esc_attr($secondarycolor); ?> !important;
}
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child .tooltip:after,
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child [data-tooltip]:after {
	background-color: <?php echo esc_attr($secondarycolor); ?> !important;
}	
}

button, input[type="submit"], input[type="button"], input[type="reset"], #tribe-bar-form .tribe-bar-submit input[type=submit], .checkout_coupon input.button, .woocommerce div.product form.cart .button:hover, table.compare-list .add-to-cart td a:hover, .woocommerce .widget_shopping_cart a.button:hover, .woocommerce #review_form #respond .form-submit input:hover, .main-holder .site table.cart .coupon input:hover, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button:hover, .woocommerce-cart #content table.cart td.actions input[type="submit"]:hover, .woocommerce #payment #place_order:hover, .woocommerce .wishlist_table td.product-add-to-cart a:hover, .woocommerce-cart #content table.cart td.actions input[type="submit"], #tribe-bar-form .tribe-bar-submit input[type=submit], .wishlist_table tr td a.yith-wcqv-button:hover, .woocommerce .wishlist_table td.product-add-to-cart a:hover, .woocommerce .widget_shopping_cart a.button.checkout:hover, .tm-sresults-title small .label-default[href]:hover, .woocommerce .widget_price_filter .price_slider_amount .button, .woocommerce .widget_shopping_cart a.button, .woocommerce #payment #place_order, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .main-holder .site table.cart .coupon input, .main-holder .site-content #review_form #respond .form-submit input, .woocommerce div.product form.cart .button, table.compare-list .add-to-cart td a, .main-holder .site table.cart .coupon button, .main-holder .site .woocommerce-cart-form__contents button, .main-holder .site .return-to-shop a.button, .main-holder .site .woocommerce-MyAccount-content a.woocommerce-Button, .main-holder .site .woocommerce-form-coupon button, .main-holder .site .woocommerce-form-login button.woocommerce-Button, .main-holder .site .woocommerce-ResetPassword button.woocommerce-Button, .main-holder .site .woocommerce-EditAccountForm button.woocommerce-Button, .tm-sresults-title small .label-default[href]:hover, .tm-vc_general.tm-vc_btn3.tm-vc_btn3-color-skincolor:hover, .tm-vc_general.tm-vc_btn3.tm-vc_btn3-style-3d.tm-vc_btn3-color-skincolor:hover, .mailchimp-inputbox input[type="submit"]:hover {
	 background-color: <?php echo esc_attr($secondarycolor); ?>;
}


.themetechmount-box-team.themetechmount-box-view-topimage-bottomcontent .themetechmount-box-content,
.single article.post blockquote,
.comment-body,
.themetechmount-iconbox-stylethree .tm-box-icon,
.tm-search-overlay .tm-site-searchform input[type="search"],
.single-tm_team_member .tm-team-social-links-wrapper ul li a,
.tm-header-style-classic-highlight .tm-header-icons .tm-header-wc-cart-link a,
.tm-header-style-classic-highlight .tm-header-icons .tm-header-search-link a,
.tm-col-bgcolor-grey .tm-bg-layer-inner, .tm-bgcolor-grey, 
.site-header.tm-sticky-bgcolor-grey.is_stuck,
.site-header-menu.tm-sticky-bgcolor-grey.is_stuck, 
.tm-header-overlay .site-header.tm-sticky-bgcolor-grey.is_stuck,
.tm-header-style-infostack .site-header .tm-stickable-header.is_stuck.tm-sticky-bgcolor-grey,
.tm-header-style-infostack .site-header-menu .is_stuck .tm-sticky-bgcolor-grey,
.tm-titlebar-wrapper.tm-breadcrumb-on-bottom.tm-breadcrumb-bgcolor-grey .tm-titlebar .breadcrumb-wrapper .container,
.tm-titlebar-wrapper.tm-breadcrumb-on-bottom.tm-breadcrumb-bgcolor-grey .breadcrumb-wrapper .container:before, .tm-titlebar-wrapper.tm-breadcrumb-on-bottom.tm-breadcrumb-bgcolor-grey .breadcrumb-wrapper .container:after,
.tm-vc_icon_element.tm-vc_icon_element-outer .tm-vc_icon_element-inner.tm-vc_icon_element-background-color-grey.tm-vc_icon_element-background,
.inside.tm-fid-view-style1 .tm-fld-contents.tm-wrap:after,
.tm-stepbox-bg-grey .tm-stepbox-wrapper .tm-stepsbox .tm-stepnum,
.tm-stepbox-bg-grey .tm-stepbox-wrapper .tm-stepsbox {
    background-color:<?php echo esc_attr($secondarygreycolor); ?>;
}
@media (min-width: 1200px) {
.site-footer .second-footer .container.tm-container-for-footer .row > .widget-area:first-child, .site-footer .second-footer .container.tm-container-for-footer .row:first-child > .widget-area:before {
	 background-color:<?php echo esc_attr($secondarygreycolor); ?> !important;
}
}

.tm-stepbox-bg-grey .tm-stepbox-wrapper .tm-stepsbox:nth-of-type(odd):before {
	border-top-color:<?php echo esc_attr($secondarygreycolor); ?>;
}
.tm-stepbox-bg-grey .tm-stepbox-wrapper .tm-stepsbox:nth-of-type(even):before {
    border-bottom-color:<?php echo esc_attr($secondarygreycolor); ?>;
}


.tm-progressbar-style1 span.tm-vc_label_units.vc_label_units,
.tm-progressbar-style1.themetechmount-progress-bar.vc_progress_bar .vc_general.vc_single_bar .vc_label,
.tribe-events-schedule h2,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title>a,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title>a,
.themetechmount-boxes-testimonial.themetechmount-boxes-col-one .themetechmount-box-view-default .themetechmount-box-title h3, .themetechmount-boxes-view-carousel .themetechmount-box-view-default .themetechmount-box-title h3,
.tm-sbox .tm-vc_cta3-content-header h2,
.vc_tta-color-black.vc_tta-style-outline .vc_tta-panel .vc_tta-panel-title>a,
.tm-sortable-list .tm-sortable-link a,
.tm-bgcolor-white .tm-vc_general.tm-vc_cta3.tm-vc_cta3-color-transparent.tm-cta3-only .tm-vc_cta3-content .tm-vc_cta3-headers h2, .tm-bgcolor-grey .tm-vc_general.tm-vc_cta3.tm-vc_cta3-color-transparent.tm-cta3-only .tm-vc_cta3-headers h2,
.tm-team-details-list .tm-team-list-title,
.tm-element-heading-wrapper .tm-vc_cta3-headers h2 strong,
.tm-sbox .tm-custom-heading a, .entry-header:not(.tm-titlebar) .entry-title > a,
.sidebar .widget a,
.tm-vc_icon_element-color-bar_black, .vc_progress-bar-color-bar_black.vc_progress_bar.themetechmount-progress-bar .vc_general.vc_single_bar .vc_label,
.themetechmount-boxes-testimonial.themetechmount-boxes-col-one .themetechmount-box-view-default .themetechmount-box-title h3 a,
.site-footer .tm-textcolor-dark a:not(:hover),
.themetechmount-box-team.themetechmount-team-style2 .themetechmount-box-social-links ul li a,
.tm-vc_btn3.tm-vc_btn3-color-white.tm-vc_btn3-style-outline.active, .tm-vc_btn3.tm-vc_btn3-color-white.tm-vc_btn3-style-outline:active, .tm-vc_btn3.tm-vc_btn3-color-white.tm-vc_btn3-style-outline:focus, .tm-vc_btn3.tm-vc_btn3-color-white.tm-vc_btn3-style-outline:hover,
.site-footer .tm-textcolor-dark .social-icons li i, .site-footer .tm-textcolor-dark.themetechmount-fbar-btn-link i,
.tm-header-style-infostack .tm-top-info-con .tm-sbox .tm-vc_cta3-content-header h2,
.tm-ptablebox .tm-ptablebox-price,
.wpb-js-composer .vc_tta.vc_tta-style-outline.tm-tab-dot-style .vc_tta-tab>a:hover,
.wpb-js-composer .vc_tta.vc_tta-style-outline.tm-tab-dot-style .vc_tta-tab.vc_active>a,
.tm-vc_general.tm-vc_cta3.tm-vc_cta3-color-grey.tm-vc_cta3-style-classic .tm-vc_cta3-content-header h2, .tm-vc_general.tm-vc_cta3.tm-vc_cta3-color-grey.tm-vc_cta3-style-flat .tm-vc_cta3-content-header, .themetechmount-box-portfolio .themetechmount-box-bottom-content h4 a, .tm-publised-in-wrapper span.post-title, .tm-team-member-single-category, .tm-team-member-single-category a, .tm-team-details-list .tm-team-list-value a, .tm-team-social-links a, .tm-bgcolor-darkgrey .themetechmount-team-box-view-overlay .themetechmount-box-title a, .tm-comment-owner, .tm-comment-owner a, .comment-reply-link:hover, .testimonial_item .themetechmount-author-name a:hover, .tm-social-share-wrapper, .themetechmount-pf-detailbox-list .tm-pf-details-date .tm-pf-left-details, .tm-tourtab-style1.vc_general.vc_tta-color-grey.vc_tta-style-outline .vc_tta-panel .vc_tta-panel-title>a, .tm-tourtab-style1.vc_general.vc_tta-tabs.vc_tta-style-outline .vc_tta-tab>a, .themetechmount-box-team.themetechmount-box-view-top-image .themetechmount-box-content h4 a, .themetechmount-team-box-view-overlay .themetechmount-box-social-links ul a, .tm-bgcolor-skincolor .themetechmount-teambox-style2 .themetechmount-box-content h4, .tm-bgcolor-skincolor .themetechmount-teambox-style2 .themetechmount-box-content h4 a, .themetechmount-box-content h4 a, .themetechmount-post-readmore a, .tm-bgcolor-skincolor .themetechmount-blogbox-footer-readmore a:hover, .tm-bgcolor-skincolor .themetechmount-box-content h4 a:hover, .logged-in-as a:hover, .vc_column-inner.tm-col-bgcolor-grey .tm-element-heading-wrapper .tm-vc_general .tm-vc_cta3_content-container .tm-vc_cta3-content .tm-vc_cta3-headers h2, .vc_column-inner.tm-col-bgcolor-white .tm-element-heading-wrapper .tm-vc_general .tm-vc_cta3_content-container .tm-vc_cta3-content .tm-vc_cta3-headers h2, div .vc_row .vc_column-inner .tm-sbox-bgcolor-white.tm-sbox h2, div .vc_row .vc_column-inner .tm-sbox-bgcolor-grey.tm-sbox h2, div .vc_row .vc_column-inner.tm-col-bgcolor-white .tm-sbox h2, div .vc_row .vc_column-inner.tm-col-bgcolor-grey .tm-sbox h2, .tm-bgcolor-white .vc_row .tm-sbox h2, .tm-bgcolor-grey .vc_row .tm-sbox h2, .tribe-events-list-separator-month, .widget.tectxon_category_list_widget .widget-title, .widget.tectxon_category_list_widget li a,
.tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline,
 .vc_column-inner.tm-col-bgcolor-white .tm-element-heading-wrapper .tm-vc_general .tm-vc_cta3_content-container .tm-vc_cta3-content .tm-vc_cta3-headers h2,
.inside.tm-fid-view-style1 .tm-fid-title,
.tm-stepbox-wrapper .tm-stepsbox .tm-stepnum {
	color:<?php echo esc_attr($blackish_buttoncolor); ?>;	
}

.vc_tta-color-black.vc_tta-style-outline .vc_tta-panel .vc_tta-panel-heading,
.tm-vc_btn3.tm-vc_btn3-color-black.tm-vc_btn3-style-outline {
	border-color:<?php echo esc_attr($blackish_buttoncolor); ?>;		
}

.single-post .tm-post-prev-next-buttons .tm-vc_btn3,
.tm-vc_btn3.tm-vc_btn3-style-text.tm-vc_btn3-size-md,
.tm-vc_btn3.tm-vc_btn3-style-text.tm-vc_btn3-size-md .tm-vc_btn3-icon,
.tm-sbox.top-overlay-icon-box .tm-vc_btn3.tm-vc_btn3-style-text.tm-vc_btn3-size-md,
.tm-sbox.tm-sbox-iconalign-top-center .tm-vc_btn3.tm-vc_btn3-style-text.tm-vc_btn3-size-md,
.tm-ptablebox .tm-vc_btn3.tm-vc_btn3-size-md,
button, input[type="submit"], input[type="button"], input[type="reset"], .checkout_coupon input.button, .woocommerce div.product form.cart .button, table.compare-list .add-to-cart td a, .woocommerce .widget_shopping_cart a.button, .woocommerce #review_form #respond .form-submit input, .main-holder .site table.cart .coupon input, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce-cart #content table.cart td.actions input[type="submit"], .woocommerce #payment #place_order, .woocommerce .wishlist_table td.product-add-to-cart a,.main-holder .site .return-to-shop a.button,
.woocommerce-cart .wc-proceed-to-checkout a.checkout-button,
.main-holder .site .woocommerce-cart-form__contents button,
.main-holder .site .woocommerce-cart-form__contents button.button:disabled[disabled],
.main-holder .site table.cart .coupon button,	
 .comment-respond .tm-vc_btn3.tm-vc_btn3-shape-square,
.single-tm_portfolio .navigation.post-navigation .nav-links  a,
.tm-vc_btn3.tm-vc_btn3-size-md{
	font-size:<?php echo esc_attr($medium_button_fontsize); ?>px;
	line-height:<?php echo esc_attr($medium_button_fontsize); ?>px;
}
.tm-vc_btn3.tm-vc_btn3-style-text.tm-vc_btn3-size-md .tm-vc_btn3-icon {
	line-height:<?php echo esc_attr($medium_button_fontsize-2); ?>px;
	height:<?php echo esc_attr($medium_button_fontsize); ?>px;
}

.tm-post-prev-next-buttons .tm-vc_btn3.tm-vc_btn3-shape-square,
.comment-respond .tm-vc_btn3.tm-vc_btn3-shape-square,
.tm-single-top-btn .tm-vc_btn3.tm-vc_btn3-shape-square,
.single-post .tm-post-prev-next-buttons .tm-vc_btn3,
.single-tm_portfolio .nav-next a, .single-tm_portfolio .nav-previous a,
.tm-ptablebox .tm-vc_btn3.tm-vc_btn3-size-md,
.tm-vc_btn3.tm-vc_btn3-size-md{
    padding-top:<?php echo esc_attr($button_topbottom_padding); ?>px;
    padding-bottom:<?php echo esc_attr($button_topbottom_padding); ?>px;
}


.tm-progressbar-style1 span.tm-vc_label_units.vc_label_units,
.tm-progressbar-style1.themetechmount-progress-bar.vc_progress_bar .vc_general.vc_single_bar .vc_label,
.themetechmount-portfolio-style1 .themetechmount-box-titles h4,
.themetechmount-box-blog .themetechmount-blogbox-footer-readmore a, .post.themetechmount-box-blog-classic .themetechmount-blogbox-footer-readmore a,
.tribe-events-calendar div[id*=tribe-events-daynum-], .tribe-events-calendar div[id*=tribe-events-daynum-] a,
.tribe-events-list-separator-month,
.tribe-events-page-title,
.tm-fid.inside h4,
.tm-commonform input[type="submit"],
.tm-teamform input[type="submit"],
.tribe-events-schedule h2,
.themetechmount-pf-detailbox-inner .themetechmount-pf-detailbox-title, .tm-pf-single-related-wrapper .tm-pf-single-related-title,
.themetechmount-pf-detailbox-list .tm-pf-details-date .tm-pf-left-details,
.themetechmount-boxes-testimonial.themetechmount-boxes-col-one .themetechmount-box-view-default .themetechmount-box-title h3, .themetechmount-boxes-view-carousel .themetechmount-box-view-default .themetechmount-box-title h3,
.comment-meta .tm-comment-owner a, .tm-comment-owner,
.sidebar .widget .tagcloud a,
.tm-post-prev-next-buttons .tm-vc_btn3.tm-vc_btn3-shape-square, .comment-respond .tm-vc_btn3.tm-vc_btn3-shape-square, .tm-single-top-btn .tm-vc_btn3.tm-vc_btn3-shape-square,
.comment-reply-title,
.single-post .comments-area .comments-title,
.wpcf7 .tm-contactform input[type="submit"],
.tm-sortable-list .tm-sortable-link a,
.tm-team-details-list .tm-team-list-title,
.themetechmount-team-box-view-left-image .themetechmount-box-content h4,
.tm-sbox .tm-vc_cta3-content-header h2,
.widget.tm_widget_nav_menu li a, .widget.tectxon_category_list_widget li a,
article.themetechmount-box-blog-classic .entry-header .entry-title,
.mailchimp-inputbox input[type="submit"], .mc_form_inside .mc_signup_submit .button, .main-holder .newsletter-widget .newsletter-submit,
.tm-header-style-infostack .ttm-custombutton i, .tm-header-style-infostack .kw-phone .ttm-custombutton a,
.tm-header-style-infostack .tm-top-info-con .tm-sbox .tm-vc_cta3-content-header h2,
.tm-vc_btn3.tm-vc_btn3-style-text.tm-vc_btn3-size-md.tm-vc_btn3-weight-no,
.widget a{
	font-weight:<?php echo esc_attr($special_element_fontweight); ?>;	
}

.tm-header-style-infostack .tm-top-info-con .tm-sbox .tm-vc_cta3-content-header h2,
.site-footer .tm-sbox .tm-vc_general.tm-vc_cta3 .tm-vc_general.tm-vc_btn3 {
	font-size:<?php echo esc_attr($special_element_font['font-size']); ?>px;
}

.single-tm_portfolio .nav-next a, .single-tm_portfolio .nav-previous a,
.tm-post-prev-next-buttons .tm-vc_btn3.tm-vc_btn3-shape-square, .comment-respond .tm-vc_btn3.tm-vc_btn3-shape-square, .tm-single-top-btn .tm-vc_btn3.tm-vc_btn3-shape-square{
	font-weight:<?php echo esc_attr($button_font['variant']); ?>;
}
.tm-sbox.tm-sbox-iconalign-top-center .tm-vc_btn3.tm-vc_btn3-style-text.tm-vc_btn3-size-md .tm-vc_btn3-icon,
.tm-sbox.top-overlay-icon-box .tm-vc_btn3.tm-vc_btn3-style-text.tm-vc_btn3-size-md .tm-vc_btn3-icon {
    font-size: 14px;
    height: 14px;
    line-height: 13px;
}
.sidebar ul.tm-recent-post-list > li,
.tm-social-share-wrapper .tm-social-share-title, .tm-right-meta .tm-social-share-wrapper.tm-social-share-post-wrapper, .tm-entry-meta .tm-meta-line i, .tm-entry-meta .tm-meta-line a:not(:hover), .tm-post-cat .tm-meta-line a:not(:hover) {
	color:<?php echo esc_attr($general_font['color']); ?>;
}

.single-tm_portfolio .nav-previous a:after, .single-tm_portfolio .nav-next a:after {
	top:<?php echo esc_attr($button_topbottom_padding - 2); ?>px;
}

.comment-form p.form-submit .tm-vc_btn3,
.single-post .tm-post-prev-next-buttons .tm-vc_btn3,
.single-tm_portfolio .nav-next a, .single-tm_portfolio .nav-previous a {
	font-family:<?php echo esc_attr($button_font['family']); ?>;
	font-weight:<?php echo esc_attr($button_font['variant']); ?>;
	text-transform:<?php echo esc_attr($button_font['text-transform']); ?>;
}
.comment-list a.comment-reply-link {
	text-transform:<?php echo esc_attr($button_font['text-transform']); ?>;	
}