<?php

/**
 * Add group in Elementor editor
 */
if( !function_exists('tm_elements_manager') ){
function tm_elements_manager() {
	\Elementor\Plugin::$instance->elements_manager->add_category( 
		'tectxon_category',
		[
			'title' => esc_attr__( 'Tectxon Special Elements', 'tectxon' ),
			'icon' => 'fa fa-plug',
		],
		1 // tab position
	);
}
}
add_action( 'elementor/init', 'tm_elements_manager' );

define( 'INOTERIOR_ICON_URL',  get_template_directory( __FILE__ )  ); 

/**
 * Adding custom theme icons
 */
 
if( !function_exists('tm_elementor_add_custom_icons_tab') ){
function tm_elementor_add_custom_icons_tab( $icons_tabs = array() ) {

	if( defined('INOTERIOR_ICON_URL') ){

		$tm_tectxon_icons_array = array(
			'nature-1',
            'nature',
            'fuel',
            'security',
            'technology-1',
            'energy',
            'factory-5',
            'technology',
            'process',
            'container',
            'drilling',
            'conveyor-1',
            'loader',
            'gears',
            'robot-arm-1',
            'gas',
            'factory-4',
            'oil-platform',
            'assembly-line',
            'refinery',
            'worker-1',
            'cargo-ship',
            'factory-3',
            'oil',
            'stock',
            'robot-arm',
            'factory-2',
            'industrial-robot',
            'worker',
            'conveyor',
            'factory-1',
            'industry',
            'interface',
            'computer',
		);
		
		$icons_tabs['kw_tectxon'] = array(
			'name'          => 'kw_tectxon',
			'label'         => esc_html__( 'Tectxon Special Icons', 'tectxon' ),
			'labelIcon'     => 'kw_tectxon flaticon-workspace',
			'prefix'        => 'flaticon-',
			'displayPrefix' => 'kw_tectxon',
			'url'           => wp_enqueue_style( 'themetechmount-tectxon-extra-icons', get_template_directory_uri() . '/assets/themetechmount-tectxon-extra-icons/font/flaticon.css' ),
			'icons'         => $tm_tectxon_icons_array,
			'ver'           => '1.0.0',
		);
		
	}
	
	
	return $icons_tabs;
}
}
add_filter( 'elementor/icons_manager/additional_tabs', 'tm_elementor_add_custom_icons_tab' );


/**
 *  Add preview js for Elementor
 */
function tm_elementor_preview_scripts(){
	if ( defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
		wp_enqueue_script(  'tectxon-elementor-preview', get_template_directory_uri() . '/inc/elementor-preview.js' );
	}
}
add_action( 'wp_enqueue_scripts', 'tm_elementor_preview_scripts' );

function tm_elementor_enqueue_base_scripts(){
	wp_enqueue_script(  'tectxon-functions', get_template_directory_uri() . '/js/functions.js' );
	wp_enqueue_script(  'tectxon-elementor-main', get_template_directory_uri() . '/inc/elementor-main.js' );
}
add_action('elementor/editor/before_enqueue_scripts', 'tm_elementor_enqueue_base_scripts');


/**
 * Creating element widgets now*/
 
add_action( 'elementor/widgets/register', 'tm_elementor_register_widgets',1,1 );
function tm_elementor_register_widgets() {

    if ( defined( 'ELEMENTOR_PATH' ) && class_exists('Elementor\Widget_Base') ) {

        require_once( get_template_directory() . '/inc/elementor/heading-subheading.php' );
        require_once( get_template_directory() . '/inc/elementor/fid.php' );
        require_once( get_template_directory() . '/inc/elementor/icon-heading.php' );
        require_once( get_template_directory() . '/inc/elementor/tm-testimonial.php' );
        require_once( get_template_directory() . '/inc/elementor/tm-client.php' );        
        require_once( get_template_directory() . '/inc/elementor/tm-blog.php' );
        require_once( get_template_directory() . '/inc/elementor/tm-team.php' );
        require_once( get_template_directory() . '/inc/elementor/tm-portfolio.php' );
        require_once( get_template_directory() . '/inc/elementor/static-box.php' );
        require_once( get_template_directory() . '/inc/elementor/tm-tabs.php' );
        require_once( get_template_directory() . '/inc/elementor/pricing-table.php' );
		require_once( get_template_directory() . '/inc/elementor/marque-box.php' );
		require_once( get_template_directory() . '/inc/elementor/showcase-box.php' );
        require_once( get_template_directory() . '/inc/elementor/listimg-box.php' );
        
	
   }
}

if( !function_exists('tm_link_render') ){
function tm_link_render( $value=array(), $type='start' ) {
	if( !empty($value) && is_array($value) && !empty($value['url']) ){
		if( $type=='start' ){
			$target		= $value['is_external'] ? ' target="_blank"' : '';
			$nofollow	= $value['nofollow'] ? ' rel="nofollow"' : '';
			return themetechmount_wp_kses( '<a href="' . $value['url'] . '"' . $target . $nofollow . '><span>' ); 
		} else {
			return themetechmount_wp_kses( '</span></a>' ); 
		}
	}
}
}

/***Themetechmount Iconbox Element code***/

if( !function_exists('themetechmount_iconbox_ele') ){
function themetechmount_iconbox_ele( $settings, $echo=false ){
	$return = '';
	
	if( !empty($settings['icon_type']) ){

		switch( $settings['icon_type'] ){

			case 'icon':
				if( !empty($ttm_data['icon']['value']) ){
					$return = '<i class="'.esc_attr( $settings['icon']['value'] ).'"></i>';

				}
				break;

			case 'image':
				if( !empty($settings['icon_image']['url']) ){
					$return = '<img src="'.esc_attr( $settings['icon_image']['url'] ).'" />';
				}
			break;

			case 'text':
				if( !empty($settings['icon_text']) ){
					$return = '<div class="tm-iheading-icontext">'.esc_attr($settings['icon_text']).'</div>';
				}
				break;

		}

	}
	if( !empty($return) ){
		$return = themetechmount_wp_kses('<div class="tm-iheading-icon tm-iheading-icon-type-'.esc_attr($settings['icon_type']).'">'.$return.'</div>');
	}

	if( $echo == true ){
		echo themetechmount_wp_kses($return);
	} else {
		return themetechmount_wp_kses($return);
	}

}
}

/**
 *  Heading Sub Heading Element.
 */

if( !function_exists('tm_heading_subheading') ){
function tm_heading_subheading( $settings = array(), $echo = false ){

	// Reverse heading class
	$reverse_class = '';
	if( !empty($settings['reverse_heading']) && $settings['reverse_heading']=='yes' ){
		$reverse_class = 'tm-reverse-heading-yes';
	}
	
	// desc heading class
	$desc = '';
	if( !empty($settings['desc'] )){
		$desc = 'tm-content-with-desc';
	}
	
	$heading_style = '';
	
	$return = '<div class="tm-element-heading-content-wrapper ' . themetechmount_wp_kses($settings['text_align']) . '-align '.esc_attr($reverse_class).' tm-seperator-'. themetechmount_wp_kses($settings['heading_sep']) .' '.esc_attr($desc).' tm-heading-style-'. themetechmount_wp_kses($settings['heading_style']) .' ">';
	
	$heading = '';
	
	// icon
	$return .= themetechmount_iconbox_ele($settings);
	
	$return .= themetechmount_wp_kses('<div class="tm-content-header">');
	
	// Heading
	if( !empty($settings['heading']) ) {
		$heading_tag = ( !empty($settings['heading_tag']) ) ? $settings['heading_tag'] : 'h2' ;

		$heading .= '<'. themetechmount_wp_kses($heading_tag) . ' class="tm-element-content-heading">
				'.themetechmount_wp_kses($settings['heading']).'
			</'. themetechmount_wp_kses($heading_tag) . '>
		';
	}

	// reverse before heading
	if( empty($settings['reverse_heading']) && !empty($heading) ){
		$return .= themetechmount_wp_kses($heading);
	}

	// subheading
	if( !empty($settings['subheading']) ) {
		$subheading_tag	= ( !empty($settings['subheading_tag']) ) ? $settings['subheading_tag'] : 'h4' ;
		$subheading		= '<'. themetechmount_wp_kses($subheading_tag) . ' class="tm-element-subheading">
				'.themetechmount_wp_kses($settings['subheading']).'
			</'. themetechmount_wp_kses($subheading_tag) . '>
		';
		$return .= themetechmount_wp_kses($subheading);
	}

	// Heading after sub-title
	if( !empty($settings['reverse_heading']) && !empty($heading) ){
		$return .= themetechmount_wp_kses($heading);
	}
	$return .= themetechmount_wp_kses('</div>');
	if( !empty($settings['desc']) ){
		$desc = '<div class="tm-element-content-desctxt">'.themetechmount_wp_kses($settings['desc']).'</div>';
		$return .= themetechmount_wp_kses($desc);
	}
	// closing div
	$return .= themetechmount_wp_kses('</div>');

	// final output
	if( $echo == true ){
		echo themetechmount_wp_kses($return);
	} else {
		return themetechmount_wp_kses($return);
	}

}
}

add_action('elementor/element/section/section_layout/before_section_start', 'tm_elementor_section_options', 10);
if( !function_exists('tm_elementor_section_options') ){
function tm_elementor_section_options( $element ){

	$element->start_controls_section(
		'tm_element_section_title',
		[
			'label' => __('Tectxon Special Options', 'tectxon'),
			'tab' => Elementor\Controls_Manager::TAB_LAYOUT,
		]
	);
	
	$element->add_control(
		'tm_break_col',
		[
			'label'			=> esc_html__( 'Break Column in Ipad Screen', 'tectxon' ),
			'description'	=> esc_html__( 'Pre-defined Break Column', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> 'no',
			'prefix_class'	=> 'tm-column-break-ipad-',
			'options' => [
				'no' 			=> __( 'No', 'tectxon' ),
				'yes'		=> __( 'Yes', 'tectxon' ),
			],
		]
	);

	$element->add_control(
		'tm-extended-column',
		[
			'label'			=> esc_attr__( 'Exapand Column Background', 'tectxon' ),
			'description'	=> esc_attr__( 'Exapand Column BG to left or right. This will expand the Background image/color visibility to border of the browser border.', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'label_block'	=> true,
			'hide_in_inner' => true,
			'default'		=> 'none',
			'prefix_class'	=> 'tm-col-stretched-',
			'options'		=> [
				'none' 			=> __( 'No expand (default)', 'tectxon' ),
				'left'		=> __( 'Exapand Column background to left', 'tectxon' ),
				'right'		=> __( 'Exapand Column background to right', 'tectxon' ),	
				'both'		=> __( 'Exapand Column background to both', 'tectxon' ),				
			],
		]
	);


	$element->add_control(
		'tm-strech-content-left',
		[
			'label'			=> esc_attr__( 'Also stretch left content too?', 'tectxon' ),
			'description'	=> esc_attr__( 'Also stretch left content too?', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SWITCHER,
			'prefix_class'	=> 'tm-left-col-stretched-content-',
			'hide_in_inner' => true,
			'label_on'		=> esc_attr__( 'Yes', 'tectxon' ),
			'label_off'		=> esc_attr__( 'No', 'tectxon' ),
			'return_value'	=> 'yes',
			'default'		=> '',
			'condition'		=> [
				'tm-extended-column' => array('left', 'both'),
			]
		]
	);
	$element->add_control(
		'tm-strech-content-right',
		[
			'label'			=> esc_attr__( 'Also stretch right content too?', 'tectxon' ),
			'description'	=> esc_attr__( 'Also stretch right content too?', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SWITCHER,
			'prefix_class'	=> 'tm-right-col-stretched-content-',
			'hide_in_inner' => true,
			'label_on'		=> esc_attr__( 'Yes', 'tectxon' ),
			'label_off'		=> esc_attr__( 'No', 'tectxon' ),
			'return_value'	=> 'yes',
			'default'		=> '',
			'condition'		=> [
				'tm-extended-column' => array('right', 'both'),
			]
		]
	);
	
	
	$element->add_control(
		'tm-left-margin',
		[
			'label'			=> esc_html__( 'Left Content Area Margin', 'tectxon' ),
			'description'	=> esc_html__( 'This is useful if you like to overlap columns on each other.', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::DIMENSIONS,
			'separator'		=> 'before',
			'selectors' => [
				'{{WRAPPER}} .tm-stretched-div.tm-stretched-left' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$element->add_control(
		'tm-right-margin',
		[
			'label'			=> esc_html__( 'Right Content Area Margin', 'tectxon' ),
			'description'	=> esc_html__( 'This is useful if you like to overlap columns on each other.', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::DIMENSIONS,
			'selectors' => [
				'{{WRAPPER}} .tm-stretched-div.tm-stretched-right' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$element->add_control(
		'tm_bg_color',
		[
			'label'			=> esc_html__( 'Background Color', 'tectxon' ),
			'description'	=> esc_html__( 'Select Background Color. If you select color and also select background Video or background Image than the color will be overlay with some opacity', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> '',
			'separator'		=> 'before',
			'prefix_class'	=> 'tm-bgcolor-',
			"weight"      => 1,
			'options'		=> [
				'' 		=> esc_attr__( 'Transparent (From Design Options tab)', 'tectxon' ),
				'darkgrey'		=> esc_attr__( 'Dark grey color as background color', 'tectxon' ),
				'grey'			=> esc_attr__( 'Grey color as background color', 'tectxon' ),
				'white'	        => esc_attr__( 'White color as background color', 'tectxon' ),
				'skincolor'  	=> esc_attr__( 'Skincolor color as background color', 'tectxon' ),
				'gradient'		=> esc_attr__( 'Gradient color as background color', 'tectxon' ),
				
			],
		]
	);

	$element->add_control(
		'tm_text_color',
		[
			'label'			=> esc_html__( 'Section Text Color', 'tectxon' ),
			'description'	=> esc_html__( 'Pre-defined Text Color in this Section (ROW)', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> '',
			'prefix_class'	=> 'tm-textcolor-',
			'options' => [
				'' 			=> __( 'Default', 'tectxon' ),
				'white'		=> __( 'White Color', 'tectxon' ),
				'dark'		=> __( 'Dark Color', 'tectxon' ),
				'skincolor'	=> __( 'Skin Color', 'tectxon' ),
			],
		]
	);
	$element->add_control(
		'tm_section_hightl_bg',
		[
			'label' => esc_attr__( 'HighLight BG Color One', 'tectxon' ),
			'description' => esc_attr__( 'show highLight background dot color one.', 'tectxon' ),
			'type' => Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_attr__( 'Yes', 'tectxon' ),
			'label_off' => esc_attr__( 'No', 'tectxon' ),
			'prefix_class'	=> 'tm-highlight-bg-',
			'return_value' => 'yes',
			'default' => '',
		]
	);
	
	$element->add_control(
		'tm_section_hightl_bg1_color',
		[
			'label' => esc_attr__( 'High Light BG Color One', 'tectxon' ),
			'description' => esc_attr__( 'show highLight background color.', 'tectxon' ),
			'type' => Elementor\Controls_Manager::COLOR,
			'default' => '',
				'selectors' => [
					'{{WRAPPER}} .tm-section-hili-dot.tm-hilidot-left' => 'color: {{VALUE}};',
				],
			'condition'		=> [
				'tm_section_hightl_bg' => 'yes',
			]
		]
	);

		$start = is_rtl() ? esc_html__( 'Right', 'elementor' ) : esc_html__( 'Left', 'elementor' );
		$end = ! is_rtl() ? esc_html__( 'Right', 'elementor' ) : esc_html__( 'Left', 'elementor' );

		$element->add_control(
			'tmhis_offset_orientation_h',
			[
				'label' => esc_html__( 'Horizontal Orientation', 'elementor' ),
				'type' => Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => $start,
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'title' => $end,
						'icon' => 'eicon-h-align-right',
					],
				],
				'classes' => 'elementor-control-start-end',
				'render_type' => 'ui',
				'condition'		=> [
					'tm_section_hightl_bg' => 'yes',
				]
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_x',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .tm-hilidot-left' => 'left: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .tm-hilidot-left' => 'right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_h!' => 'end',
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_x_end',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .tm-hilidot-left' => 'right: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .tm-hilidot-left' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_h' => 'end',
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		
		$element->add_control(
			'tmhis_offset_orientation_v',
			[
				'label' => esc_html__( 'Vertical Orientation', 'elementor' ),
				'type' => Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => esc_html__( 'Top', 'elementor' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => esc_html__( 'Bottom', 'elementor' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
				'condition'		=> [
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_y',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .tm-hilidot-left' => 'top: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_v!' => 'end',
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);

		$element->add_responsive_control(
			'tmhis_offset_y_end',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .tm-hilidot-left' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_v' => 'end',
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);

		$element->add_responsive_control(
			'tmhis_z_index',
			[
				'label' => esc_html__( 'Z-Index', 'elementor' ),
				'type' => Elementor\Controls_Manager::NUMBER,
				'selectors' => [
					'{{WRAPPER}} .tm-hilidot-left' => 'z-index: {{VALUE}};',
				],
				'condition'		=> [
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		$element->add_control(
			'tmhis_font_size',
			[
				'label' => esc_html__( 'Font Size', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .tm-hilidot-left' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition'		=> [
					'tm_section_hightl_bg' => 'yes',
				],
			]
		);
		
		$element->add_control(
		'tm_section_hight2_bg',
		[
			'label' => esc_attr__( 'HighLight BG Color Two', 'tectxon' ),
			'description' => esc_attr__( 'show high light background dot color two.', 'tectxon' ),
			'type' => Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_attr__( 'Yes', 'tectxon' ),
			'label_off' => esc_attr__( 'No', 'tectxon' ),
			'prefix_class'	=> 'tm-highlight-bg-',
			'return_value' => 'yes',
			'default' => '',
		]
	);
	
	$element->add_control(
		'tm_section_hightl_bg2_color',
		[
			'label' => esc_attr__( 'High Light BG Color Two', 'tectxon' ),
			'description' => esc_attr__( 'show high light background color.', 'tectxon' ),
			'type' => Elementor\Controls_Manager::COLOR,
			'default' => '',
				'selectors' => [
					'{{WRAPPER}} .tm-section-hili-dot.tm-hilidot-right' => 'color: {{VALUE}};',
				],
			'condition'		=> [
				'tm_section_hight2_bg' => 'yes',
			]
		]
	);
	
	$element->add_control(
			'tmhis_offset_orientation_h2',
			[
				'label' => esc_html__( 'Horizontal Orientation', 'elementor' ),
				'type' => Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => $start,
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'title' => $end,
						'icon' => 'eicon-h-align-right',
					],
				],
				'classes' => 'elementor-control-start-end',
				'render_type' => 'ui',
				'condition'		=> [
					'tm_section_hight2_bg' => 'yes',
				]
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_x2',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .tm-hilidot-right' => 'left: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .tm-hilidot-right' => 'right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_h2!' => 'end',
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_x2_end',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'body:not(.rtl) {{WRAPPER}} .tm-hilidot-right' => 'right: {{SIZE}}{{UNIT}}',
					'body.rtl {{WRAPPER}} .tm-hilidot-right' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_h2' => 'end',
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		
		$element->add_control(
			'tmhis_offset_orientation_v2',
			[
				'label' => esc_html__( 'Vertical Orientation', 'elementor' ),
				'type' => Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => esc_html__( 'Top', 'elementor' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => esc_html__( 'Bottom', 'elementor' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
				'condition'		=> [
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		
		$element->add_responsive_control(
			'tmhis_offset_y2',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .tm-hilidot-right' => 'top: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_v2!' => 'end',
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);

		$element->add_responsive_control(
			'tmhis_offset_y2_end',
			[
				'label' => esc_html__( 'Offset', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} .tm-hilidot-right' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'tmhis_offset_orientation_v2' => 'end',
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);

		$element->add_responsive_control(
			'tmhis_z_index2',
			[
				'label' => esc_html__( 'Z-Index', 'elementor' ),
				'type' => Elementor\Controls_Manager::NUMBER,
				'selectors' => [
					'{{WRAPPER}} .tm-hilidot-right' => 'z-index: {{VALUE}};',
				],
				'condition'		=> [
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		$element->add_control(
			'tmhis_font_size2',
			[
				'label' => esc_html__( 'Font Size', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .tm-hilidot-right' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition'		=> [
					'tm_section_hight2_bg' => 'yes',
				],
			]
		);
		

	$element->end_controls_section();
}
}


/**
 * Elementor column options
 */
add_action('elementor/element/column/layout/before_section_start', 'tm_elementor_column_options', 10);
if( !function_exists('tm_elementor_column_options') ){
function tm_elementor_column_options( $element ){

	$element->start_controls_section(
		'tm_element_section_title',
		[
			'label' => __('Tectxon Special Options', 'tectxon'),
			'tab' => Elementor\Controls_Manager::TAB_LAYOUT,
		]
	);

	$element->add_control(
		'tm_bg_color',
		[
			'label'			=> esc_html__( 'Column Background Color', 'tectxon' ),
			'description'	=> esc_html__( 'Pre-defined Background Color for this Column', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> '',
			'prefix_class'	=> 'tm-bgcolor-yes tm-col-bgcolor-',
			"weight"      => 1,
			'options'		=> [
				'' 			=> esc_attr__( 'Transparent (From Design Options tab)', 'tectxon' ),
				'darkgrey'		=> esc_attr__( 'Dark grey color as background color', 'tectxon' ),
				'grey'			=> esc_attr__( 'Grey color as background color', 'tectxon' ),
				'white'	        => esc_attr__( 'White color as background color', 'tectxon' ),
				'skincolor'  	=> esc_attr__( 'Skincolor color as background color', 'tectxon' ),
				'gradient'		=> esc_attr__( 'Gradient color as background color', 'tectxon' ),
				
			],
		]
	);

	$element->add_control(
		'tm_text_color',
		[
			'label'			=> esc_html__( 'Column Text Color', 'tectxon' ),
			'description'	=> esc_html__( 'Pre-defined Text Color in this Column', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> '',
			'prefix_class'	=> 'tm-textcolor-',
			'options' => [
				'' 			=> __( 'Default', 'tectxon' ),
				'white'		=> __( 'White Color', 'tectxon' ),
				'dark'		=> __( 'Dark Color', 'tectxon' ),
				'skincolor'	=> __( 'Skin Color', 'tectxon' ),
			],
		]
	);

	$element->end_controls_section();
}
}



/**
 * Elementor button options
 */
add_action('elementor/element/button/section_button/before_section_start', 'tm_elementor_button_options', 10);
if( !function_exists('tm_elementor_button_options') ){
function tm_elementor_button_options( $element ){

	$element->start_controls_section(
		'tm_element_section_title',
		[
			'label' => __('Tectxon Special Options', 'tectxon'),
			'tab' => Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
		
	$element->add_control(
		'color',
		[
			'label'			=> esc_html__( 'Button Color', 'tectxon' ),
			'description'	=> esc_html__( 'Pre-defined Color for Button', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> 'skincolor',
			'label_block'	=> true,
			'prefix_class'	=> 'tm-btn-color-',
			'options' => [
				'darkgrey'		=> esc_attr__( 'Dark Grey', 'tectxon' ),
				'grey'			=> esc_attr__( 'Grey Color', 'tectxon' ),
				'white'	        => esc_attr__( 'White Color', 'tectxon' ),
				'skincolor'  	=> esc_attr__( 'Skin Color', 'tectxon' ),
				'gradient'		=> esc_attr__( 'Gradient Color', 'tectxon' ),
			],
		]
	);
	$element->add_control(
		'style',
		[
			'label'			=> esc_html__( 'Select Button Style', 'tectxon' ),
			'description'	=> esc_html__( 'Button style', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'default'		=> 'flat',
			'label_block'	=> true,
			'prefix_class'	=> 'tm-btn-style-',
			'options' => [
				'flat' 			=> esc_attr__( 'Flat', 'tectxon' ),
				'outline'		=> esc_attr__( 'Outline', 'tectxon' ),
				'text'			=> esc_attr__( 'Simple text', 'tectxon' ),
			],
		]
	);
	
	$element->add_control(
		'shape',
		[
			'label'			=> esc_attr__( 'Select button shape.', 'tectxon' ),
			'description'	=> esc_attr__( 'Select button shape.', 'tectxon' ),
			'type'			=> Elementor\Controls_Manager::SELECT,
			'label_block'	=> true,
			'prefix_class'	=> 'tm-btn-shape-',
			'default'		=> 'square',
			'options' => [
				'square' 		=> esc_attr__( 'Square', 'tectxon' ),
				'rounded'		=> esc_attr__( 'Rounded', 'tectxon' ),
				'round'			=> esc_attr__( 'Round', 'tectxon' ),
			],
		]

	);
	
	$element->add_control(
			'icon-pos',
			[
				'label' => __( 'Icon Position', 'tectxon' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'label_block'	=> true,
				'prefix_class'	=> 'tm-icon-align-',
				'default' => 'left',
				'options' => [
					'left'  => __( 'Before', 'tectxon' ),
					'right' => __( 'After', 'tectxon' ),
				],
				'condition' => [
					'selected_icon[value]!' => '',
				],
			]
		);
		
		
	$element->end_controls_section();
}
}
	
/* enable builder for custom cpt */

if( !function_exists('tm_elementor_enable_cpt_support') ){
function tm_elementor_enable_cpt_support() {

	$cpt_support  = array( 'page', 'post', 'tm_portfolio', 'tm_service', 'tm_team_member' );
	update_option( 'elementor_cpt_support', $cpt_support  );

}
}
add_action( 'after_switch_theme', 'tm_elementor_enable_cpt_support' );