<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Fact & Digit Widget.
*/
 
class Tectxon_Fidbox_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_fid_element';
	}

	public function get_title() {
		return esc_attr__( 'Facts in digits', 'tectxon' );
	}

	public function get_icon() {
		return 'eicon-counter';
	}

	public function get_categories() {
		return [ 'tectxon_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
		wp_enqueue_script( 'waypoints' );
		wp_enqueue_script( 'numinate' );
		wp_enqueue_script( 'jquery-circle-progress' );
	}  
	
	protected function register_controls() {

		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Content', 'tectxon' ),
			]
        );
		
		
		$this->add_control(
			'view',
			[
				'label'			=> esc_attr__( 'Design', 'tectxon' ),
				'description'	=> esc_attr__( 'Select box design.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'topicon',
				'options' => [
					'topicon'	=> esc_attr( 'Top Center icon' ),
					'lefticon'	=> esc_attr( 'Left Icon' ),
					'righticon'	=> esc_attr( 'Right Icon' ),
					'circle-progress'	=> esc_attr( 'Circle Progress Style' ),
				],
			]
		);

		 $this->add_control(
			'icon_type',
			[
				'label' => esc_attr__( 'Icon Type', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'icon'	=> esc_attr__( 'Icon', 'tectxon' ),
					'image'	=> esc_attr__( 'Image', 'tectxon' ),
					'text'	=> esc_attr__( 'Text', 'tectxon' ),
				],
				'default' => esc_attr( 'icon' ),
			]
		);

		 $this->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'tectxon' ),
				'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'icon_type' => 'icon',
                ]
            ]

		);

        $this->add_control(
			'icon_image',
			[
				'label' => __( 'Select Image for Icon', 'tectxon' ),
				'description' => __( 'image will appear at icon position', 'tectxon' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ]
			]
		);
		    $this->add_control(
			'icon_text',
			[
				'label' => esc_attr__( 'Text for Icon', 'tectxon' ),
				'description' => esc_attr__( 'Text will appear at icon position', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( '01', 'tectxon' ),
				'placeholder' => esc_attr__( 'Enter text here', 'tectxon' ),
                'label_block' => true,
                'condition' => [
                    'icon_type' => 'text',
                ]
			]
		);

		$this->add_control(
			'title',
			[
				'label' => esc_attr__( 'Header ', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'Title Text. ', 'tectxon' ),
				'placeholder' => esc_attr__( 'Enter text for the title. ', 'tectxon' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'desc',
			[
				'label' => esc_attr__( 'Description Text', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_attr__( 'Enter description text', 'tectxon' ),
				'label_block' => true,
				// 'condition' => [
				// 	'view' => 'style6',
				// ],
			]
		);

		$this->add_control(
			'digit',
			[
				'label' => esc_attr__( 'Rotating Number', 'tectxon' ),
				'description' => esc_attr__( 'Enter rotating number digit here.', 'tectxon' ),
				'separator' => 'before',
				'type' => Controls_Manager::NUMBER,
				'default' => '50',
			]
		);

		$this->add_control(
			'interval',
			[
				'label' => esc_attr__( 'Rotating digit Interval', 'tectxon' ),
				'description' => esc_attr__( 'Enter rotating interval number here.', 'tectxon' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '5',
			]
		);

		$this->add_control(
			'before',
			[
				'label' => esc_attr__( 'Text Before Number', 'tectxon' ),
				'description' => esc_attr__( 'Enter text which appear just before the rotating numbers.', 'tectxon' ),
				'separator' => 'before',
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => '',
			]
		);

		$this->add_control(
			'beforetextstyle',
			[
				'label' => esc_attr__( 'Text Style', 'tectxon' ),
				'description' => esc_attr__('Select text style for the before text.', 'tectxon'),
				'type' => Controls_Manager::SELECT,
				'default' => 'sup',
				'options' => [
					'sup'		=> esc_attr__( 'Superscript', 'tectxon' ),
					'sub'		=> esc_attr__( 'Subscript', 'tectxon' ),
					'span'		=> esc_attr__( 'Normal', 'tectxon' ),
				]
			]
		);

		$this->add_control(
			'after',
			[
				'label' => esc_attr__( 'Text After Number', 'tectxon' ),
				'description' => esc_attr__( 'Enter text which appear just after the rotating numbers.', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'separator' => 'before',
				'dynamic' => [
					'active' => true,
				],
				'default' => '',
			]
		);

		$this->add_control(
			'aftertextstyle',
			[
				'label' => esc_attr__( 'Text Style', 'tectxon' ),
				'description' => esc_attr__('Select text style for the after text.', 'tectxon'),
				'type' => Controls_Manager::SELECT,
				'default' => 'sup',
				'options' => [
					'sup'		=> esc_attr__( 'Superscript', 'tectxon' ),
					'sub'		=> esc_attr__( 'Subscript', 'tectxon' ),
					'span'		=> esc_attr__( 'Normal', 'tectxon' ),
				]
			]
		);
		
		$this->add_control(
			'circle_fill_color',
			[
				'label' => esc_attr__( 'Circle fill color', 'tectxon' ),
				'description'	=> esc_attr__( 'Select circle fill color..', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'skincolor',
				'options' => [
					'skincolor'		=> esc_attr__( 'Skincolor', 'tectxon' ),
					'20292f'		=> esc_attr__( 'Dark Grey', 'tectxon' ),
					'#fff'			=> esc_attr__( 'White', 'tectxon' ),
				],
				'condition' => [
					'view' => ['circle-progress','circle-progress-style2']
				],
			]
		);
		$this->add_control(
			'circle_empty_color',
			[
				'label' => esc_attr__( 'Circle empty color', 'tectxon' ),
				'description'	=> esc_attr__( 'Select circle empty color..', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'default' => '20292f',
				'options' => [
					'skincolor'		=> esc_attr__( 'Skincolor', 'tectxon' ),
					'20292f'		=> esc_attr__( 'Dark Grey', 'tectxon' ),
					'#fff'		=> esc_attr__( 'White', 'tectxon' ),
				],
				'condition' => [
					'view' => ['circle-progress','circle-progress-style2']
				],
			]
		);
		

		$this->end_controls_section();

	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		
		global $tm_global_fid_element_values;
		$tm_global_fid_element_values = array();
		
		$tm_global_fid_element_values['circle_fill_color']  = $circle_fill_color;
		$tm_global_fid_element_values['circle_empty_color']  = $circle_empty_color;

		$return = $icon = '';

		$lefticoncode  = '';
		$righticoncode = '';
		if( !empty($settings['icon']['value']) ){ 
			$lefticoncode = '<div class="tm-fid-icon-wrapper"><i class="' . esc_attr($settings['icon']['value']) . '"></i></div>';
		} 

			if( !empty($settings['icon_type']) ){

				if( $settings['icon_type']=='text' ){
					$lefticoncode = '<div class="tm-icon-type-text">' . $settings['icon_text'] . '</div>';
					$icon_type_class = 'text';

				} else if( $settings['icon_type']=='image' ){
					$icon_alt	= (!empty($settings['title'])) ? trim($settings['title']) : esc_attr__('Icon', 'tectxon') ;
					$icon_image = '<img src="'.esc_url($settings['icon_image']['url']).'" alt="'.esc_attr($icon_alt).'" />';
					$lefticoncode	= '<div class="tm-icon-type-image">' . $icon_image . '</div>';
					$icon_type_class = 'image';
				} else if( $settings['icon_type']=='none' ){
					$lefticoncode = '';
					$icon_type_class = 'none';
				} else {

					$lefticoncode       = '<div class="tm-fid-icon-wrapper"><i class="' . esc_attr($settings['icon']['value']) . '"></i></div>';
					$icon_type_class = 'icon';

					wp_enqueue_style( 'elementor-icons-'.$settings['icon']['library']);
				}
			}
			
		$class         = array();
		$class_icon         = 'tm-fid-without-icon';
		if( !empty($settings['icon']['value']) ){ 
			$class_icon = 'tm-fid-with-icon';	
			
		}  // if( $add_icon=='true' )
		
		// icon exists class
		$class[] = $class_icon;
		
		if( !empty($view) ){
			$class[] = 'tm-fid-view-'.$view;
		}
			
		$before_text = '';
		$after_text  = '';
		
		if( trim($before)!='' ){
			if( $beforetextstyle=='sup' || $beforetextstyle=='sub' || $beforetextstyle=='span' ){
				$before_text = '<'.$beforetextstyle.'>'.trim($before).'</'.$beforetextstyle.'>';
			}
		}
		
		if( trim($after)!='' ){
			if( $aftertextstyle=='sup' || $aftertextstyle=='sub' || $aftertextstyle=='span' ){
				$after_text = '<'.$aftertextstyle.'>'.trim($after).'</'.$aftertextstyle.'>';
			}
		}
			$view_class=implode(' ', $class);

		if( file_exists( locate_template( '/template-parts/fidbox2/fidbox-'.esc_attr($view).'.php', false, false ) ) ){

			ob_start();
			include( locate_template( '/template-parts/fidbox2/fidbox-'.esc_attr($view).'.php', false, false ) );
			$return .= ob_get_contents();
			ob_end_clean();

		}
		
		echo themetechmount_wp_kses($return);

	}


}
// Register widget
Plugin::instance()->widgets_manager->register( new Tectxon_Fidbox_Widget() );