<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Steps Box
*/
 
class Tectxon_Listimgbox_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_listimgbox_element';
	}

	public function get_title() {
		return esc_attr__( 'List Image Box', 'tectxon' );
	}

	public function get_icon() {
		return 'eicon-bullet-list';
	}

	public function get_categories() {
		return [ 'tectxon_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}

	protected function register_controls() {
		
		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'General ', 'tectxon' ),
			]
		);
		$this->add_control(
			'view',
			[
				'label'			=> esc_attr__( 'General', 'tectxon' ),
				'description'	=> esc_attr__( 'Select List Box style.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'styleone',
				'prefix'		=> 'themetechmount-listimgbox themetechmount-listimgbox-',
				'options' => [
					'styleone'	=> esc_attr( 'Style 1' ),
				],
			]
		);
		$this->add_control(
			'heading',
			[
				'label' => esc_attr__( 'Heading', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_attr__( 'Our Services', 'tectxon' ),
				'placeholder' => esc_attr__( 'Enter text for heading text.', 'tectxon' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'desc',
			[
				'label' => esc_attr__( 'Description', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_attr__( 'Enter description text', 'tectxon' ),
			]
		);
		$this->add_control(
			'heading_sep',
			[
				'label' => esc_attr__( 'Seperator', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none'	=> esc_attr( 'None' ),
					'solid'	=> esc_attr( 'Solid' ),
				],
				'default' => esc_attr( 'solid' ),
				'condition' => [
                    'view' => 'styletwo',
                ]
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_attr__( 'Text alignment', 'tectxon' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_attr__( 'Left', 'tectxon' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_attr__( 'Center', 'tectxon' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_attr__( 'Right', 'tectxon' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'tm-align-',
				'selectors' => [
					'{{WRAPPER}} .tm-heading-subheading' => 'text-align: {{VALUE}};',
				],
				'dynamic' => [
					'active' => true,
				],
				'default' => 'left',
				'condition' => [
                    'view' => 'styletwo',
                ]
			]
		);
		
		$this->add_control(
			'heading_style',
			[
				'label'			=> esc_attr__( 'Heading Style', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'vertical'	=> esc_attr( 'Vertical (Default)' ),
					'horizontal'	=> esc_attr( 'Horizontal' ),
				],
				'default' => esc_attr( 'vertical' ),
				'condition' => [
                    'view' => 'styletwo',
                ]
			]
		);
		
		
		$this->end_controls_section();

		$this->start_controls_section(
			'data_section2',
			[
				'label' => esc_attr__( 'Boxes Content', 'tectxon' ),
			]
        );
		
		$this->add_control(
			'box_border',
			[
				'label'			=> esc_attr__( 'Box border', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'yes'	=> esc_attr( 'Yes' ),
					'no'	=> esc_attr( 'No' ),
				],
				'default' => esc_attr( 'no' ),
			]
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'icon_image',
			[
				'label' => __( 'Select Image for Icon', 'tectxon' ),
				'description' => __( 'image will appear at icon position', 'tectxon' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
			]
		);

	
		$repeater->add_control(
			'label',
			[
				'label' => esc_attr__( 'Box Title', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_attr__( 'Box Title', 'tectxon' ),
				'placeholder' => esc_attr__( 'Box Title', 'tectxon' ),
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'sublabel',
			[
				'label' => esc_attr__( 'Box Sub Title', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_attr__( 'Box Sub Title', 'tectxon' ),
				'placeholder' => esc_attr__( 'Box Title', 'tectxon' ),
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'smalltext',
			[
				'label' => esc_attr__( 'Box Content', 'tectxon' ),
				'default' => esc_attr__( 'Box Content', 'tectxon' ),
				'placeholder' => esc_attr__( 'Box Content', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => true,
			]
		);

		$repeater->add_control(
			'link_text',
			[
				'label' => esc_attr__( 'Link Text', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_attr__( 'Like READ MORE text. This text will appear as link (fill link URL in below option).', 'tectxon' ),
				'placeholder' => esc_attr__( 'READ MORE', 'tectxon' ),
				'label_block' => true,
				'separator' => 'before',
			]
		);
		
		$repeater->add_control(
			'link_url',
			[
				'label' => esc_attr__( 'Link URL', 'tectxon' ),
				'description' => esc_attr__( 'Add link URL here.', 'tectxon' ),
				'type' => Controls_Manager::URL,
				'show_label' => true,
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
		);
        $this->add_control(
			'boxes',
			[
				'label'		=> esc_attr__( 'Boxes', 'tectxon' ),
				'type'		=> Controls_Manager::REPEATER,
				'fields'	=> $repeater->get_controls(),
				'default'	=> [
					[
						'image'		=> get_template_directory_uri() . '/images/placeholder.png',
						'label'		=> esc_attr__( 'This is first box', 'tectxon' ),
						'sublabel'		=> esc_attr__( 'This is first box', 'tectxon' ),
						'smalltext'	=> esc_attr__( 'This is small description', 'tectxon' ),
					],
					[
						'image'		=> get_template_directory_uri() . '/images/placeholder.png',
						'label'		=> esc_attr__( 'This is second box', 'tectxon' ),
						'sublabel'		=> esc_attr__( 'This is second box', 'tectxon' ),
						'smalltext'	=> esc_attr__( 'This is small description', 'tectxon' ),
					],
				],
				'title_field' => '{{{ label }}}',
			]
		);

		$this->end_controls_section();



	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
				$boxstyle	= $view;
				$link_html = '';
		$image_html = $smalltext_html = $label_html = $sublabel_html = $boxborder_html = '';
		?> <div class="tm_listimgbox_wrapper">
			<?php tm_heading_subheading($settings, true); ?>
			<ul class="tm_listimgbox_list_content 	themetechmount-listimgbox-<?php echo esc_attr($boxstyle)?>">
			
	
		<?php 
		$count = 1;
		foreach( $settings['boxes'] as $box ){
			if( !empty($box['smalltext']) ){
					$smalltext_html = '<div class="tm-cta3-content-wrapper">'.themetechmount_wp_kses($box['smalltext']).'</div>';
			}
			if( !empty($box['label']) ){
				$label_html = '<h4 class="tm-box-title">'.themetechmount_wp_kses($box['label']).'</h4>';
			}
			if( !empty($box['sublabel']) ){
				$sublabel_html = '<h4 class="tm-box-subtitle">'.themetechmount_wp_kses($box['sublabel']).'</h4>';
			}			
			if( !empty($box_border) ){
				$boxborder_html = esc_attr($box_border);
			}
			
			$icon_image = '<img src="'.esc_url($box['icon_image']['url']).'" alt="'.esc_attr($box['label']).'" />';
			$icon = '<div class="tm-stepbox-imagebox"><div class="tm-ptable-icon-type-image">' . $icon_image . '</div></div>';
			
			
			$link_html = '';
			if( !empty($box['link_text']) && isset($box['link_url']['url']) && !empty($box['link_url']['url']) ){
				$text = $box['link_text'];
				$link_html = '<a class="tm-staticbox-more-link tm-more-button" href="' . esc_url( $box['link_url']['url'] ) . '" title="' . esc_attr( $text ) . '" target="' . ( (!empty($box['link_url']['is_external']) && $box['link_url']['is_external']==true) ? '_blank' : '_self' ) . '">' . esc_attr( $text ) . '</a>' ;
			}
		

		
		include( locate_template( '/template-parts/listimgbox/listimgbox-'.esc_attr($view).'.php', false, false ) ); 
		$count++;
		}
		
		?> </ul>
		
		</div>
		<?php
	}


}
// Register widget
Plugin::instance()->widgets_manager->register( new Tectxon_Listimgbox_Widget() );