<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Steps Box
*/
 
class Tectxon_showcasebox_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_showcase_element';
	}

	public function get_title() {
		return esc_attr__( 'Showcase Box', 'tectxon' );
	}

	public function get_icon() {
		return ' eicon-menu-toggle';
	}

	public function get_categories() {
		return [ 'tectxon_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}

	protected function register_controls() {
		
		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'General ', 'tectxon' ),
			]
		);

		$this->add_control(
			'style',
			[
				'label'			=> esc_attr__( 'Select Showcase Style', 'tectxon' ),
				'description'	=> esc_attr__( 'Select Showcase style.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'options' => [
					'style1'	=> esc_attr( 'Style 1' ),
				],
				'default' => esc_attr( 'style1' ),
			]
		);
		
		
		$this->end_controls_section();

		$this->start_controls_section(
			'data_section2',
			[
				'label' => esc_attr__( 'Boxes Content', 'tectxon' ),
			]
        );

		$repeater = new Repeater();


		 $repeater->add_control(
			'icon_image',
			[
				'label' => __( 'Select Image for Icon', 'tectxon' ),
				'description' => __( 'image will appear at icon position', 'tectxon' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
			]
		);
		
		$repeater->add_control(
			'label',
			[
				'label' => esc_attr__( 'Box Title', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_attr__( 'Box Title', 'tectxon' ),
				'placeholder' => esc_attr__( 'Box Title', 'tectxon' ),
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'label_link_url',
			[
				'label' => esc_attr__( 'Title Link URL', 'tectxon' ),
				'description' => esc_attr__( 'Add title link URL here.', 'tectxon' ),
				'type' => Controls_Manager::URL,
				'show_label' => true,
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
			]
		);
		
		$repeater->add_control(
			'sublabel',
			[
				'label' => esc_attr__( 'Box Sub Title', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_attr__( 'Box Sub Title', 'tectxon' ),
				'placeholder' => esc_attr__( 'Box Sub Title', 'tectxon' ),
				'label_block' => true,
				'condition' => [
                    'style' => 'style2',
                ]
			]
		);
		
		$repeater->add_control(
			'smalltext',
			[
				'label' => esc_attr__( 'Box Content', 'tectxon' ),
				'default' => esc_attr__( 'Box Content', 'tectxon' ),
				'placeholder' => esc_attr__( 'Box Content', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => true,
				'condition' => [
                    'style' => 'style2',
                ]
			]
		);

		$repeater->add_control(
			'link_text',
			[
				'label' => esc_attr__( 'Link Text', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'description' => esc_attr__( 'Like READ MORE text. This text will appear as link (fill link URL in below option).', 'tectxon' ),
				'placeholder' => esc_attr__( 'READ MORE', 'tectxon' ),
				'label_block' => true,
				'separator' => 'before',
				
			]
		);
		
		$repeater->add_control(
			'link_url',
			[
				'label' => esc_attr__( 'Link URL', 'tectxon' ),
				'description' => esc_attr__( 'Add link URL here.', 'tectxon' ),
				'type' => Controls_Manager::URL,
				'show_label' => true,
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
				
			]
		);

		$repeater->add_control(
			'icon_type',
			[
				'label' => esc_attr__( 'Icon Type', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'icon'	=> esc_attr__( 'Icon', 'tectxon' ),					
					'none'	=> esc_attr__( 'None', 'tectxon' ),					
				],
				'default' => esc_attr( 'icon' ),
			]
		);
		$repeater->add_control(
			'number',
			[
				'label' => esc_attr__( 'Number Text', 'tectxon' ),
				'description' => esc_attr__( 'Text will appear as number', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( '01', 'tectxon' ),
                'label_block' => true,
			
			]
		);
		
         $repeater->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'tectxon' ),
				'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'icon_type' => 'icon',
                ]
            ]

		);
        $this->add_control(
			'boxes',
			[
				'label'		=> esc_attr__( 'Boxes', 'tectxon' ),
				'type'		=> Controls_Manager::REPEATER,
				'fields'	=> $repeater->get_controls(),
				'default'	=> [
					[
						'image'		=> get_template_directory_uri() . '/images/placeholder.png',
						'label'		=> esc_attr__( 'This is first box', 'tectxon' ),
						'smalltext'	=> esc_attr__( 'This is small description', 'tectxon' ),

					],
					[
						'image'		=> get_template_directory_uri() . '/images/placeholder.png',
						'label'		=> esc_attr__( 'This is second box', 'tectxon' ),
						'smalltext'	=> esc_attr__( 'This is small description', 'tectxon' ),
					],
				],
				'title_field' => '{{{ label }}}',
			]
		);

		$this->end_controls_section();



	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		$return = '';
		$link_html = '';
		$label_html = '';
		$image_html		= '' ;
		$column_class = '';
		$icon_html = $smalltext_html = $number_html = $sublabel_html = '';
		$headingclass= '';
		if( empty($settings['heading']) ){
			$headingclass = 'tm-boxwithout-heading';
		}
		?>


		<?php
			$col_start_div	= '';
			$col_end_div	= '';
					if( !empty($boxes) ){
						switch( count($boxes) ){
					case 1:
						$column_class = 'one';
					break;
					
					case 2:
						$column_class = 'two';
					break;
					
					case 3:
						$column_class	 = 'three';
					break;
					
					case 4:
					default:
						$column_class = 'four';
					break;
					
				}
			} ?>
			
<div class="qodef--min-height qodef--init tm_showcasebox_wrapper tm-showcasebox-<?php echo esc_attr($style); ?> multi-columns-row">
	<div class="tm_showcasebox_main-contents qodef-m-items-holder tm-column-<?php echo esc_attr($column_class); ?>">

		<?php
		$count = 1;
		$accclass = '';
		foreach( $settings['boxes'] as $box ){
			$icon_html = '';
			$icon_type_class = '';

			if( !empty($box['icon_type']) ){

				 if( $box['icon_type']=='none' ){
					$icon_html = '';
					$icon_type_class = 'none';
				} else {

					$icon_html       = '<div class="tm-box-icon"><i class="' . $box['icon']['value'] . '"></i></div>';
					$icon_type_class = 'icon';

					wp_enqueue_style( 'elementor-icons-'.$box['icon']['library']);
				}
			}
			 
			$sublabel_html	= ( !empty($box['sublabel']) ) ? '<div class="themetechmount-static-box-sublabel">'.esc_html($box['sublabel']).'</div>' : '' ;
			
			$smalltext_html	= ( !empty($box['smalltext']) ) ? '<div class="themetechmount-static-box-desc">'.themetechmount_wp_kses($box['smalltext']).'</div>' : '' ;
			
			$label_html		= ( !empty($box['label']) ) ? '<div class="tm-box-title"><h4>'.esc_html($box['label']).'</h4></div>' : '' ;
			
			if( !empty($box['label']) && isset($box['label_link_url']['url']) && !empty($box['label_link_url']['url']) ){
				$text = $box['label'];
				$label_html = '<div class="tm-box-title"><h4><a class="tm-box-more-link tm-more-button" href="' . esc_url( $box['label_link_url']['url'] ) . '">' . esc_attr( $text ) . '</a></h4></div>' ;
			}
			
			else {
			
			$label_html		= ( !empty($box['label']) ) ? '<div class="tm-box-title"><h4>'.esc_html($box['label']).'</h4></div>' : '' ;
			}
			
			
			$icon_image = '<img src="'.esc_url($box['icon_image']['url']).'" alt="'.esc_attr($box['label']).'" />';
			$icon = '<div class="tm-stepbox-imagebox"><div class="tm-ptable-icon-type-image">' . $icon_image . '</div></div>';
			$inline_style = '';
			
				 // check if the post has a Post Thumbnail assigned to it.
				$inline_style = 'style="background-image:url('.esc_url($box['icon_image']['url']).');"';
			
						
			if( !empty($box['number']) ){
				$number_html = '<div class="tm-number-wrapper">'.esc_attr($box['number']).'</div>';
			}
					

			$link_html = '';
			if( !empty($box['link_text']) && isset($box['link_url']['url']) && !empty($box['link_url']['url']) ){
				$text = $box['link_text'];
				$link_html = '<a class="tm-staticbox-more-link tm-more-button" href="' . esc_url( $box['link_url']['url'] ) . '" title="' . esc_attr( $text ) . '" target="' . ( (!empty($box['link_url']['is_external']) && $box['link_url']['is_external']==true) ? '_blank' : '_self' ) . '">' . esc_attr( $text ) . '</a>' ;
			}
			
					ob_start();
					
					include( get_template_directory() . '/template-parts/showcasebox/showcasebox-'.esc_attr($style).'.php' );
					$return .= ob_get_contents();
					ob_end_clean();
		$count++;

		}		
		
		
		
		echo themetechmount_wp_kses($return);
		
		?>

	</div>
		</div>

	    <?php
	}

	

}
// Register widget
Plugin::instance()->widgets_manager->register( new Tectxon_showcasebox_Widget() );