<?php
namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly	
}

/**
 *  Blog Box
*/

class Tectxon_Portfoliobox_Widget extends Widget_Base{

	public function get_name() {
		return 'tm_project_element';
	}

	public function get_title() {
		return esc_attr__( 'Portfolio Box Element', 'tectxon' );
	}
	
	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'tectxon_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
	}

	protected function register_controls() {

		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_attr__( 'General', 'tectxon' ),
			]
		);
		
		$this->add_control(
			'style',
			[
				'label'			=> esc_attr__( 'Select Portfolio Style', 'tectxon' ),
				'description'	=> esc_attr__( 'Select Portfolio style.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'options' => [
					'overlay'	=> esc_attr( 'PortfolioBox Style 1' ),
					'top-image'	=> esc_attr( 'PortfolioBox Style 2' ),
					'style1'	=> esc_attr( 'PortfolioBox Style 3' ),
				],
				'default' => esc_attr( 'overlay' ),
			]
		);
		
		$this->add_control(
			'heading',
			[
				'label' => esc_attr__( 'Heading', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'Our Work', 'tectxon' ),
				'placeholder' => esc_attr__( 'Enter text for heading text.', 'tectxon' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'subheading',
			[
				'label' => esc_attr__( 'Subheading', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( '', 'tectxon' ),
				'placeholder' => esc_attr__( 'Enter text for subheading text.', 'tectxon' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'reverse_heading',
			[
				'label' => esc_attr__( 'Reverse heading order', 'tectxon' ),
				'description' => esc_attr__( 'Show sub-heading before heading.', 'tectxon' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_attr__( 'Yes', 'tectxon' ),
				'label_off' => esc_attr__( 'No', 'tectxon' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'desc',
			[
				'label' => esc_attr__( 'Description', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_attr__( 'Type your description text', 'tectxon' ),
			]
		);
		
		$this->add_control(
			'heading_sep',
			[
				'label' => esc_attr__( 'Seperator', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none'	=> esc_attr( 'None' ),
					'solid'	=> esc_attr( 'Solid' ),
                    'style1'	=> esc_attr( 'Style1' ),
					'style2'	=> esc_attr( 'Style2' ),
					'style3'	=> esc_attr( 'Style3' ),
					'style4'	=> esc_attr( 'Style4' ),
					'style5'	=> esc_attr( 'Style5' ),
				],
				'default' => esc_attr( 'solid' ),
			]
		);
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_attr__( 'Text Alignment', 'tectxon' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_attr__( 'Left', 'tectxon' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_attr__( 'Center', 'tectxon' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_attr__( 'Right', 'tectxon' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'prefix_class' => 'tm-align-',
				'selectors' => [
					'{{WRAPPER}} .tm-heading-subheading' => 'text-align: {{VALUE}};',
				],
				'dynamic' => [
					'active' => true,
				],
				'default' => 'left',
			]
		);
		
		$this->add_control(
			'heading_style',
			[
				'label'			=> esc_attr__( 'Heading Style', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'vertical'	=> esc_attr( 'Vertical (Default)' ),
					'horizontal'	=> esc_attr( 'Horizontal' ),
				],
				'default' => esc_attr( 'vertical' ),
			]
		);

		$this->add_control(
			'tag_options',
			[
				'label'			=> esc_attr__( 'Tags for SEO', 'tectxon' ),
				'type'			=> Controls_Manager::HEADING,
				'separator'		=> 'before',
			]
		);
		
		$this->add_control(
			'heading_tag',
			[
				'label' => esc_attr__( 'Heading Tag', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h2' ),
			]
		);
		
		$this->add_control(
			'subheading_tag',
			[
				'label' => esc_attr__( 'Subheading Tag', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h4' ),
			]
		);
		
		$this->add_control(
            'tm_reveal_effects_enable',
            [
                'label'              => esc_html__('Use Reveal Effects?', 'tectxon'),
                'type'               => Controls_Manager::SWITCHER,
                'render_type'        => 'none',
                'frontend_available' => true,
                'prefix_class'       => 'tm-reveal-effects-',
				 'condition' => [
					'style' => [ 'overlay', 'overlay-style2', 'overlay-style3' ]
				],
            ]
        );
        $this->add_control(
            'tm_reveal_effects_direction',
            [
                'label'              => __('Direction', 'bdthemes-element-pack'),
                'type'               => Controls_Manager::SELECT,
                'default'            => 'lr',
                'options'            => [
                    'lr' => __('Left to Right', 'tectxon'),
                    'rl' => __('Right to Left', 'tectxon'),
                   ],
                'frontend_available' => true,
				'render_type'        => 'none',
				'prefix_class'       => 'tm-reveal-direction-',
                'condition' => [
				   'tm_reveal_effects_enable' => 'yes',
					'style' => [ 'overlay', 'overlay-style2', 'overlay-style3' ]
				],
            ]
        );
		
		$this->end_controls_section();

		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Box Design', 'tectxon' ),
			]
		);
		
		$this->add_control(
			'from_category',
			[
				'label' => esc_attr__( 'From Category ?', 'tectxon' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $this->select_category(),
				'multiple' => true,
				'label_block'	=> true,
				'placeholder' => esc_attr__( 'All Categories', 'tectxon' ),
			]
		);
		
		$this->add_control(
			'exclude',
			[
				'label' => esc_attr__( 'Exclude Posts', 'tectxon' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_attr__( 'Exclude posts that you do not want to appear. Write ID of that post with comma separated. Like "10,14,8".', 'tectxon' ),
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'show',
			[
				'label' => esc_attr__( 'Post to show', 'tectxon' ),
				'description' => esc_attr__( 'How many item you want to show.', 'tectxon' ),
				'separator' => 'before',
				'type' => Controls_Manager::NUMBER,
				'default' => '3',
			]
		);
		
		$this->add_control(
			'sortable',
			[
				'label' => esc_attr__( 'Show Sortable Category Links', 'tectxon' ),
				'description' => esc_attr__( 'Show sortable category links above items so user can sort by just single click.', 'tectxon' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_attr__( 'Yes', 'tectxon' ),
				'label_off' => esc_attr__( 'No', 'tectxon' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		
		$this->add_control(
			'allword',
			[
				'label' => esc_attr__( 'Replace ALL word', 'tectxon' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'All', 'tectxon' ),
				'placeholder' => esc_attr__( 'Replace ALL word in sortable group links. Default is ALL word.', 'tectxon' ),
				'label_block' => true,
				'condition' => [
					'sortable' => 'yes',
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => esc_attr__( 'Order', 'tectxon' ),
				'description' => esc_attr__( 'Designates the ascending or descending order.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'separator' => 'before',
				'default' => 'DESC',
				'options' => [
					'ASC'		=> esc_attr__( 'Ascending order (1, 2, 3; a, b, c)', 'tectxon' ),
					'DESC'		=> esc_attr__( 'Descending order (3, 2, 1; c, b, a)', 'tectxon' ),
				]
			]
		);
		
		$this->add_control(
			'orderby',
			[
				'label' => esc_attr__( 'Order By', 'tectxon' ),
				'description' => esc_attr__( ' Sort retrieved posts by parameter.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'none'		=> esc_attr__( 'No order', 'tectxon' ),
					'ID'		=> esc_attr__( 'ID', 'tectxon' ),
					'title'		=> esc_attr__( 'Title', 'tectxon' ),
					'date'		=> esc_attr__( 'Date', 'tectxon' ),
					'rand'		=> esc_attr__( 'Random', 'tectxon' ),
				]
			]
		);
		
		$this->add_control(
			'gap',
			[
				'label' => esc_attr__( 'Box Gap', 'tectxon' ),
				'description' => esc_attr__( 'Gap between each Post box.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'default' => '30px',
				'options' => [
					'0px'		=> esc_attr__( 'No Gap (0px)', 'tectxon' ),
					'5px'		=> esc_attr__( '5px', 'tectxon' ),
					'10px'		=> esc_attr__( '10px', 'tectxon' ),
					'15px'		=> esc_attr__( '15px', 'tectxon' ),
					'20px'		=> esc_attr__( '20px', 'tectxon' ),
					'25px'		=> esc_attr__( '25px', 'tectxon' ),
					'30px'		=> esc_attr__( '30px', 'tectxon' ),
					'35px'		=> esc_attr__( '35px', 'tectxon' ),
					'40px'		=> esc_attr__( '40px', 'tectxon' ),
					'45px'		=> esc_attr__( '45px', 'tectxon' ),
					'50px'		=> esc_attr__( '50px', 'tectxon' ),
				]
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'appearance_section',
			[
				'label' => esc_attr__( 'Box Design', 'tectxon' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
	
		$this->add_control(
			'column',
			[
				'label'			=> esc_attr__( 'Select Column', 'tectxon' ),
				'description'	=> esc_attr__( 'Select column.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'three',
				'options'		=> [
					'one'				=> esc_attr__( 'One Column', 'tectxon' ),
					'two'				=> esc_attr__( 'Two Column', 'tectxon' ),
					'three'				=> esc_attr__( 'Three Column', 'tectxon' ),
					'four'				=> esc_attr__( 'Four Column', 'tectxon' ),
					'five'				=> esc_attr__( 'Five Column', 'tectxon' ),
					'six'				=> esc_attr__( 'Six Column', 'tectxon' ),
				],
			]
		);
		
		$this->add_control(
			'view-type',
			[
				'label'			=> esc_attr__( 'Box View', 'tectxon' ),
				'description'	=> esc_attr__( 'Select box view. Show as normal row and column or show with carousel effect.', 'tectxon' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'default'		=> 'default',
				'options'		=> [
					'default'	=> esc_attr__( 'Row and Column', 'tectxon' ),
					'carousel'	=> esc_attr__( 'Carousel effect', 'tectxon' ),
				]
			]
		);

		$this->add_control(
			'carousel_options',
			[
				'label' => esc_attr__( 'Carousel Settings', 'tectxon' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'view-type' => 'carousel',
				]
			]
		);

		$this->add_control(
			'tm-autoplayspeed',
			[
				'label'			=> esc_attr__( 'Carousel: autoplaySpeed', 'tectxon' ),
				'description'	=> esc_attr__( 'Carousel Effect: Slide/Fade animation speed.', 'tectxon' ),
				'type'			=> Controls_Manager::TEXT,
				'default'		=> '4500',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);
		
		$this->add_control(
			'tm-loop',
			[
				'label'			=> esc_attr__( 'Carousel: Loop Item', 'tectxon' ),
				'description'	=> esc_attr__( 'Carousel Effect: Infinite loop sliding.', 'tectxon' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'tectxon' ),
					'0'				=> esc_attr__( 'No', 'tectxon' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'tm-autoplay',
			[
				'label'			=> esc_attr__( 'Carousel: Autoplay', 'tectxon' ),
				'description'	=> esc_attr__( 'Carousel Effect: Enable/disable Autoplay', 'tectxon' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'tectxon' ),
					'0'				=> esc_attr__( 'No', 'tectxon' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'carousel_nav',
			[
				'label'			=> esc_attr__( 'Carousel: Next/Prev Arrows', 'tectxon' ),
				'description'	=> esc_attr__( 'Carousel Effect: Show dots navigation.', 'tectxon' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'tectxon' ),
					'0'				=> esc_attr__( 'No', 'tectxon' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->add_control(
			'carousel_arrowtype',
			[
				'label'			=> esc_attr__( 'Carousel:Button Type', 'tectxon' ),
				'description'	=> esc_attr__( 'Carousel button type.', 'tectxon' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'square'			=> esc_attr__( 'Square', 'tectxon' ),
					'round'				=> esc_attr__( 'Round', 'tectxon' ),
				],
				'default'		=> 'square',
				'condition'		=> [
					'view-type'		=> 'carousel',
					'carousel_nav'		=> '1',
				]
			]
		);
		
		$this->add_control(
			'carousel_dots',
			[
				'label'			=> esc_attr__( 'Carousel: dots', 'tectxon' ),
				'description'	=> esc_attr__( 'Carousel Effect: Show dots navigation.', 'tectxon' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'tectxon' ),
					'0'				=> esc_attr__( 'No', 'tectxon' ),
				],
				'default'		=> '0',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);
		
		$this->add_control(
			'carousel_slidestoscroll',
			[
				'label'			=> esc_attr__( 'Carousel: slidesToScroll', 'tectxon' ),
				'description'	=> esc_attr__( '# of slides to scroll', 'tectxon' ),
				'type'			=> Controls_Manager::SELECT,
				'options'		=> [
					'1'				=> esc_attr__( '1 Slide', 'tectxon' ),
					'column'		=> esc_attr__( 'Same as column', 'tectxon' ),
				],
				'default'		=> '1',
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);
		
		$this->add_control(
			'tm-centermode',
			[
				'label'			=> esc_attr__( 'Carousel: centerMode', 'tectxon' ),
				'description'	=> esc_attr__( 'Enables centered view with partial prev/next slides. Use with odd numbered slidesToShow counts.', 'tectxon' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'tectxon' ),
					'0'				=> esc_attr__( 'No', 'tectxon' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
				]
			]
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_attr__( 'Typo Settings', 'tectxon' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'heading_title',
				[
					'label' => esc_attr__( 'Heading', 'tectxon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'heading_color',
				[
					'label' => esc_attr__( 'Color', 'tectxon' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .tm-element-content-heading' => 'color: {{VALUE}};',
						'{{WRAPPER}} .tm-element-content-heading > a' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'heading_typography',
					'selector' => '{{WRAPPER}} .tm-element-content-heading',
				]
			);
			$this->add_responsive_control(
				'heading_bottom_space',
				[
					'label' => esc_attr__( 'Spacing', 'tectxon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .tm-element-content-heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'heading_subheading',
				[
					'label' => esc_attr__( 'Sub Heading', 'tectxon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'stitle_color',
				[
					'label' => esc_attr__( 'Color', 'tectxon' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .tm-element-subheading' => 'color: {{VALUE}};',
						'{{WRAPPER}} .tm-element-subheading > a' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'subheading_typography',
					'selector' => '{{WRAPPER}} .tm-element-subheading',
				]
			);
			$this->add_responsive_control(
				'subheading_bottom_space',
				[
					'label' => esc_attr__( 'Spacing', 'tectxon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .tm-element-subheading' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);

			$this->add_control(
				'heading_desc',
				[
					'label' => esc_attr__( 'Description', 'tectxon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'desc_color',
				[
					'label' => esc_attr__( 'Color', 'tectxon' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .tm-element-content-desctxt' => 'color: {{VALUE}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .tm-element-content-desctxt',
				]
			);
			$this->add_responsive_control(
				'desc_bottom_space',
				[
					'label' => esc_attr__( 'Spacing', 'tectxon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .tm-element-content-desctxt' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);

		$start_div = ttm_element_container( array(
			'position'	=> 'start',
			'cpt'		=> 'portfolio',
			'data'		=> $settings
		) );

		echo themetechmount_wp_kses($start_div);

		$args = array(
			'post_type'				=> 'tm_portfolio',
			'posts_per_page'		=> $show,
			'ignore_sticky_posts'	=> true,
		);

		if( !empty($orderby) && $orderby!='none' ){
			$args['orderby'] = $orderby;
			if( !empty($order) ){
				$args['order'] = $order;
			}
		}

		if( !empty($from_category) ){
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'tm_portfolio_category',
					'field'    => 'slug',
					'terms'    => $from_category,
				),
			);
		};
		
		if( !empty($exclude) ){
				$args['post__not_in'] = explode( ',', $exclude );
		}

		$posts = new \WP_Query( $args );
		
		$headingclass= '';
		if( empty($settings['heading']) ){
			$headingclass = 'tm-boxwithout-heading';
		}
		if ( $posts->have_posts() ) {
				if($settings['_element_id'] == 'tm-column-styleview') {
				echo '<div class="tm_portfolioarrow-box"><div class="tm-portfoliobox-inner">';
				?>
				<?php echo tm_heading_subheading($settings, true); ?>
				<?php
				echo '<div class="tm-slick-arrows"><a class="tm-slick-arrow tm-slick-prev"><i class="tm-tectxon-icon-arrow-left"></i></a><a class="tm-slick-arrow tm-slick-next"><i class="tm-tectxon-icon-arrow-right"></i></a></div></div>';
			}
			else if($settings['_element_id'] == 'tm-leftheadingarrow-view') {
				echo '<div class="col-md-4"><div class="tm-portfoliobox-inner">';
				?>
				<?php echo tm_heading_subheading($settings, true); ?>
				<?php
				echo '<div class="tm-slick-arrows"><a class="tm-slick-arrow tm-slick-prev"><i class="tm-tectxon-icon-arrow-left"></i></a><a class="tm-slick-arrow tm-slick-next"><i class="tm-tectxon-icon-arrow-right"></i></a></div></div></div>';
			}				
			else {
			?>
			<div class="themetechmount-box-heading-wrapper <?php echo themetechmount_wp_kses($headingclass); ?>">
				<?php tm_heading_subheading($settings, true); ?>
				<?php
				if( function_exists('themetechmount_get_filterbutton') ){
					$sortable_category_html = themetechmount_get_filterbutton( $settings, 'tm_portfolio_category' );
					echo  themetechmount_wp_kses($sortable_category_html);
				}
				?>
			</div>
			<?php } 
			if($settings['_element_id'] == 'tm-leftheadingarrow-view') { ?>
			<div class="col-md-8"><div class="tm-portfoliobox-inner">			
			<div class="themetechmount-boxes-row-wrapper row multi-columns-row">
			<?php
			while ( $posts->have_posts() ) {
				$return = '';
				$posts->the_post();

				if( file_exists( locate_template( '/template-parts/portfoliobox/portfoliobox-'.esc_attr($style).'.php', false, false ) ) ){

					$return .= ttm_element_block_container( array(
						'position'	=> 'start',
						'column'	=> $column,
						'cpt'		=> 'portfolio',
						'taxonomy'	=> 'tm_portfolio_category',
						'style'		=> $style,
					) );

					ob_start();
					$r = include( locate_template( '/template-parts/portfoliobox/portfoliobox-'.esc_attr($style).'.php', false, false ) );
					$return .= ob_get_contents();
					ob_end_clean();

					$return .= ttm_element_block_container( array(
						'position'	=> 'end',
					) );

				}
				
		
				echo themetechmount_wp_kses($return);
				
			}
			?>
			</div></div></div>
			<?php } else { ?>
			<div class="themetechmount-boxes-row-wrapper row multi-columns-row">
			<?php
			while ( $posts->have_posts() ) {
				$return = '';
				$posts->the_post();

				if( file_exists( locate_template( '/template-parts/portfoliobox/portfoliobox-'.esc_attr($style).'.php', false, false ) ) ){

					$return .= ttm_element_block_container( array(
						'position'	=> 'start',
						'column'	=> $column,
						'cpt'		=> 'portfolio',
						'taxonomy'	=> 'tm_portfolio_category',
						'style'		=> $style,
					) );

					ob_start();
					$r = include( locate_template( '/template-parts/portfoliobox/portfoliobox-'.esc_attr($style).'.php', false, false ) );
					$return .= ob_get_contents();
					ob_end_clean();

					$return .= ttm_element_block_container( array(
						'position'	=> 'end',
					) );

				}
				
		
				echo themetechmount_wp_kses($return);
				
			}
			?>
			</div>
			<?php } ?>
			<?php
		}

	    wp_reset_postdata();
		
		$end_div = ttm_element_container( array(
			'position'	=> 'end',
			'cpt'		=> 'portfolio',
			'data'		=> $settings
		) );
		echo themetechmount_wp_kses($end_div);
	}


	

	protected function select_category() {
	  	$category = get_terms( array( 'taxonomy' => 'tm_portfolio_category', 'hide_empty' => false ) );
	  	$cat = array();
	  	foreach( $category as $item ) {
			$cat_count = get_category( $item );

	     	if( $item ) {
	        	$cat[$item->slug] = $item->name . ' ('.$cat_count->count.')';
	     	}
	  	}
	  	return $cat;
	}
	
}
// Register widget
Plugin::instance()->widgets_manager->register( new Tectxon_Portfoliobox_Widget() );