<?php

/* Options */

$allParams = array(
	array(
		"type"        => "dropdown",
		"holder"      => "div",
		"class"       => "",
		"heading"     => esc_attr__("Show Pagination",'tectxon'),
		"description" => esc_attr__("Show pagination links below Event boxes.",'tectxon'),
		"param_name"  => "pagination",
		"value"       => array(
			esc_attr__('No','tectxon')  => 'no',
			esc_attr__('Yes','tectxon') => 'yes',
		),
		"std"         => "no",
		'dependency'  => array(
			'element'    => 'sortable',
			'value_not_equal_to' => array( 'yes' ),
		),
	),
	array(
		"type"        => "dropdown",
		"holder"      => "div",
		"class"       => "",
		"heading"     => esc_attr__("Show Events Item",'tectxon'),
		"description" => esc_attr__("How many events you want to show.",'tectxon'),
		"param_name"  => "show",
		"value"       => array(
			esc_attr__('All','tectxon') => '-1',
			esc_attr__('1','tectxon')  => '1',
			esc_attr__('2','tectxon') => '2',
			esc_attr__('3','tectxon')=>'3',
			esc_attr__('4','tectxon')=>'4',
			esc_attr__('5','tectxon')=>'5',
			esc_attr__('6','tectxon')=>'6',
			esc_attr__('7','tectxon')=>'7',
			esc_attr__('8','tectxon')=>'8',
			esc_attr__('9','tectxon')=>'9',
			esc_attr__('10','tectxon')=>'10',
			esc_attr__('11','tectxon')=>'11',
			esc_attr__('12','tectxon')=>'12',
			esc_attr__('13','tectxon')=>'13',
			esc_attr__('14','tectxon')=>'14',
			esc_attr__('15','tectxon')=>'15',
			esc_attr__('16','tectxon')=>'16',
			esc_attr__('17','tectxon')=>'17',
			esc_attr__('18','tectxon')=>'18',
			esc_attr__('19','tectxon')=>'19',
			esc_attr__('20','tectxon')=>'20',
			esc_attr__('21','tectxon')=>'21',
			esc_attr__('22','tectxon')=>'22',
			esc_attr__('23','tectxon')=>'23',
			esc_attr__('24','tectxon')=>'24',
		),
		"std"  => "3",
	),
	array(
		"type"        => "dropdown",
		"heading"     => esc_attr__("Box Style", "tectxon"),
		"description" => esc_attr__("Select box style.", "tectxon"),
		"group"       => esc_attr__( "Box Design", "tectxon" ),
		"param_name"  => "view",
		"value"       => array(
			esc_attr__("Default Style", "tectxon")  => "top-image",
			esc_attr__("Detailed Style", "tectxon") => "top-image-details",
			esc_attr__("Style 1", "tectxon") 		=> "style1",
		),
		"std"         => "default",
	),
	array(
		"type"        => "dropdown",
		"heading"     => esc_attr__("Box Spacing", "tectxon"),
		"param_name"  => "box_spacing",
		"description" => esc_attr__("Spacing between each box.", "tectxon"),
		"value"       => array(
			esc_attr__("Default", "tectxon")                        => "",
			esc_attr__("0 pixel spacing (joint boxes)", "tectxon")  => "0px",
			esc_attr__("5 pixel spacing", "tectxon")                => "5px",
			esc_attr__("10 pixel spacing", "tectxon")               => "10px",
		),
		"std"  => "",
	),
	
);


/**
 * Heading Element
 */
$heading_element = vc_map_integrate_shortcode( 'tm-heading', '', '',
	array(
		'exclude' => array(
			'el_class',
			'css',
			'css_animation'
		),
	)
);

$boxParams = themetechmount_box_params();
$params    = array_merge( $heading_element, $allParams, $boxParams );


// Changing default values
$i = 0;
foreach( $params as $param ){
	$param_name = (isset($param['param_name'])) ? $param['param_name'] : '' ;
	if( $param_name == 'h2' ){
		$params[$i]['std'] = 'Latest Events';
		
	} else if( $param_name == 'h2_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'h4_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	}
	$i++;
}


global $tm_sc_params_eventsbox;
$tm_sc_params_eventsbox = $params;


vc_map( array(
	"name"     => esc_attr__("ThemetechMount Events Box", "tectxon"),
	"base"     => "tm-eventsbox",
	"icon"     => "icon-themetechmount-vc",
	'category' => esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	"params"   => $params
) );

