<?php

/* Options */



$allParams1 =  array(
	array(
		'type'			=> 'textfield',
		'holder'		=> 'div',
		'class'			=> '',
		'heading'		=> esc_attr__('Header (optional)', 'tectxon'),
		'param_name'	=> 'title',
		'std'			=> esc_attr__('Title Text', 'tectxon'),
		'description'	=> esc_attr__('Enter text for the title. Leave blank if no title is needed.', 'tectxon')
	),
	array(
		"type"			=> "dropdown",
		"holder"		=> "div",
		"class"			=> "",
		"heading"		=> esc_attr__("Design", 'tectxon'),
		"param_name"	=> "view",
		"description"	=> esc_attr__('Select box design.' , 'tectxon'),
		'value' => array(
			esc_attr__( 'Top Center icon', 'tectxon' )           => 'topicon',
			esc_attr__( 'Left icon', 'tectxon' )                 => 'lefticon',
			esc_attr__( 'Right icon', 'tectxon' )                => 'righticon',
			esc_attr__( 'Left icon with separator', 'tectxon' )  => 'lefticon-border',
			esc_attr__( 'Right icon with separator', 'tectxon' ) => 'righticon-border',
			esc_attr__( 'Top Hightlight icon', 'tectxon' )		 => 'left-top-icon',
			esc_attr__( 'Circle progress', 'tectxon' )			 => 'circle-progress',
			esc_attr__( 'Hightlight text without icon', 'tectxon' )           => 'style1',
		),
		'std'           => 'topicon',
	),
	array(
		'type'       => 'checkbox',
		'heading'    => esc_attr__( 'Add icon?', 'tectxon' ),
		'param_name' => 'add_icon',
		'std'        => 'true',
		'edit_field_class'	=> 'vc_col-sm-6 vc_column',
	),
	array(
		'type'       => 'checkbox',
		'heading'    => esc_attr__( 'Add border?', 'tectxon' ),
		'param_name' => 'add_border',
		'std'        => 'true',
		'edit_field_class'	=> 'vc_col-sm-6 vc_column',
	),
	

	
);


$icons_params = vc_map_integrate_shortcode( 'tm-icon', 'i_', '', array(
	'include_only_regex' => '/^(type|icon_\w*)/',
	// we need only type, icon_fontawesome, icon_blabla..., NOT color and etc
), array(
	'element' => 'add_icon',
	'value' => 'true',
) );

$icons_params_new = array();

/* Adding class for two column */
foreach( $icons_params as $param ){
	$param['edit_field_class'] = 'vc_col-sm-6 vc_column';
	$icons_params_new[] = $param;
}



$allParams2 = array(
			array(
				'type'				=> 'textfield',
				'holder'			=> 'div',
				'class'				=> '',
				'heading'			=> esc_attr__('Rotating Number', 'tectxon'),
				'param_name'		=> 'digit',
				'std'				=> '100',
				'description'		=> esc_attr__('Enter rotating number digit here.', 'tectxon'),
			),
			array(
				'type'				=> 'textfield',
				'holder'			=> 'div',
				'heading'			=> esc_attr__('Text Before Number', 'tectxon'),
				'param_name'		=> 'before',
				'description'		=> esc_attr__('Enter text which appear just before the rotating numbers.', 'tectxon'),
				'edit_field_class'	=> 'vc_col-sm-6 vc_column',
			),
			array(
				"type"			=> "dropdown",
				"holder"		=> "div",
				"heading"		=> esc_attr__("Text Style",'tectxon'),
				"param_name"	=> "beforetextstyle",
				"description"	=> esc_attr__('Select text style for the text.', 'tectxon') . '<br>' . esc_attr__('Superscript text appears half a character above the normal line, and is rendered in a smaller font.','tectxon') . '<br>' . esc_attr__('Subscript text appears half a character below the normal line, and is sometimes rendered in a smaller font.','tectxon'),
				'value' => array(
					esc_attr__( 'Superscript', 'tectxon' ) => 'sup',
					esc_attr__( 'Subscript', 'tectxon' )   => 'sub',
					esc_attr__( 'Normal', 'tectxon' )      => 'span',
				),
				'std' => 'sup',
				'edit_field_class'	=> 'vc_col-sm-6 vc_column',
			),
			array(
				'type'				=> 'textfield',
				'holder'			=> 'div',
				'class'				=> '',
				'heading'			=> esc_attr__('Text After Number', 'tectxon'),
				'param_name'		=> 'after',
				'description'		=> esc_attr__('Enter text which appear just after the rotating numbers.', 'tectxon'),
				'edit_field_class'	=> 'vc_col-sm-6 vc_column',
			),
			array(
				"type"			=> "dropdown",
				"holder"		=> "div",
				"class"			=> "",
				"heading"		=> esc_attr__("Text Style",'tectxon'),
				"param_name"	=> "aftertextstyle",
				"description"	=> esc_attr__('Select text style for the text.', 'tectxon') . '<br>' . esc_attr__('Superscript text appears half a character above the normal line, and is rendered in a smaller font.','tectxon') . '<br>' . esc_attr__('Subscript text appears half a character below the normal line, and is sometimes rendered in a smaller font.','tectxon'),
				'value' => array(
					esc_attr__( 'Superscript', 'tectxon' ) => 'sup',
					esc_attr__( 'Subscript', 'tectxon' )   => 'sub',
					esc_attr__( 'Normal', 'tectxon' )      => 'span',
				),
				'std' => 'sub',
				'edit_field_class'	=> 'vc_col-sm-6 vc_column',
			),
			array(
				'type'			=> 'textfield',
				'holder'		=> 'div',
				'class'			=> '',
				'heading'		=> esc_attr__('Rotating digit Interval', 'tectxon'),
				'param_name'	=> 'interval',
				'std'			=> '5',
				'description'	=> esc_attr__('Enter rotating interval number here.', 'tectxon')
			),
			array(
					'type'			=> 'textfield',
					'holder'		=> 'div',
					'class'			=> '',
					'heading'		=> esc_attr__('Description)', 'tectxon'),
					'param_name'	=> 'description',
					'description'	=> esc_attr__('Enter description for the fidbox. Leave blank if no description is needed.', 'tectxon'),
					'dependency'  => array(
						'element'            => 'view',
						'value_not_equal_to' => array( 'topicon','lefticon-style2','lefticon','righticon','lefticon-border','righticon-border','style6' ),
					),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_attr__( 'Circle fill color', 'tectxon' ),
				'param_name' => 'circle_fill_color',
				'value'      => array(
						esc_attr__( 'Skincolor', 'tectxon' )      => 'skincolor',
						esc_attr__( 'Dark Grey', 'tectxon' )      => 'ff5e14',
						esc_attr__( 'White', 'tectxon' ) 		   => '#fff',
					),
				'std'         => 'skincolor',
				'description' => esc_attr__( 'Select circle fill color.', 'tectxon' ),
				'param_holder_class' => 'tm_vc_colored-dropdown',
				'edit_field_class'   => 'vc_col-sm-6 vc_column',
				'dependency'  => array(
							'element'            => 'view',
							'value_not_equal_to' => array( 'topicon','lefticon-style2','lefticon','righticon','lefticon-border','righticon-border','style6' ),
						),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_attr__( 'Circle empty color', 'tectxon' ),
				'param_name' => 'circle_empty_color',
				'value'      => array(
						esc_attr__( 'Skincolor', 'tectxon' )      => 'skincolor',
						esc_attr__( 'Dark Grey', 'tectxon' )      => 'ff5e14',
						esc_attr__( 'White', 'tectxon' ) 		   => 'fff',
						esc_attr__( 'Grey color', 'tectxon' ) 	   => '#dadada',
					),
				'std'         => '20292f',
				'description' => esc_attr__( 'Select circle empty color.', 'tectxon' ),
				'param_holder_class' => 'tm_vc_colored-dropdown',
				'edit_field_class'   => 'vc_col-sm-6 vc_column',
				'dependency'  => array(
							'element'            => 'view',
							'value_not_equal_to' => array( 'topicon','lefticon-style2','lefticon','righticon','lefticon-border','righticon-border','style6'),
						),
			),
);



// merging all options
$params = array_merge( $allParams1, $icons_params_new, $allParams2 );

// merging extra options like css animation, css options etc
$params = array_merge(
	$params,
	array( vc_map_add_css_animation() ),
	array( themetechmount_vc_ele_extra_class_option() ),
	array( themetechmount_vc_ele_css_editor_option() )
);




global $tm_sc_params_facts_in_digits;
$tm_sc_params_facts_in_digits = $params;






vc_map( array(
	'name'		=> esc_attr__( 'ThemetechMount Facts in digits', 'tectxon' ),
	'base'		=> 'tm-facts-in-digits',
	'class'		=> '',
	'icon'		=> 'icon-themetechmount-vc',
	'category'	=> esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	'params'	=> $params
) );

