<?php

$heading_params = vc_map_integrate_shortcode( 'tm-heading', '', esc_attr__('Content','tectxon'),
	array(
		'exclude' => array(
			'txt_align',
			'seperator',
			'heading_style',
			'el_class',
			'css_animation',
			'css',
		),
	)
);

if ( is_array( $heading_params ) && ! empty( $heading_params ) ) {
	foreach ( $heading_params as $key => $param ) {
		
		if ( is_array( $param ) && isset( $param['param_name'] ) ){
			
			if( $param['param_name'] == 'content' ){
				$heading_params[$key]['value'] = esc_attr('');
				$heading_params[$key]['type'] = 'textarea';
				
			} else if( $param['param_name'] == 'reverse_heading' ){
				$heading_params[$key]['std'] = 'no';
				$heading_params[$key]['value'] = 'no';
				
			}
			
			
		}
	}
}

$btn_params = vc_map_integrate_shortcode( 'tm-btn', 'btn_', esc_attr__('Button','tectxon'),
	array(
		'exclude' => array(
			'style',
			'shape',
			'color',
			'size',
			'font_weight',
			'align',
			'i_align',
			'gradient_color_1',
			'gradient_color_2',
			'gradient_custom_color_1',
			'gradient_custom_color_2',
			'gradient_text_color',
			'custom_background',
			'custom_text',
			'outline_custom_color',
			'outline_custom_hover_background',
			'outline_custom_hover_text',
			'button_block',
			'css_animation',
			'css',
		),
	),
	array(
		'element' => 'show_btn',
		'value'   => 'yes',
	)
);

// Extra Class
$extra_class = themetechmount_vc_ele_extra_class_option();
$extra_class['group'] = esc_attr__( 'Content', 'tectxon' );

$vc_map_add_css_animation = vc_map_add_css_animation();
$vc_map_add_css_animation['group'] = esc_attr__( 'Animation', 'tectxon' );
	
$params = array_merge(
		array( 
			array(
				"type"        => "themetechmount_style_selector",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Box Design",'tectxon'),
				"description" => esc_attr__("Select box design.",'tectxon'),
				"param_name"  => "view",
				"value"       => themetechmount_global_iconbox_template_list( true ),
				"std"         => "styleone",
				'group'		  => esc_attr__( 'Box Style', 'tectxon' ),
			),		
		),
		
		$heading_params,
		
		array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_attr__( 'Select Icon Type', 'tectxon' ),
				'param_name' => 'main_icon_type',
				'value'      => array(
					esc_attr__( 'Icon', 'tectxon' ) => 'icon',
					esc_attr__( 'Image', 'tectxon' )  => 'image',
				),
				'std'         => 'icon',
				'group'		  => esc_attr__( 'Icon', 'tectxon' ),
				'description' => esc_attr__( 'Want to show icon or image', 'tectxon' ),
			),
		),
		
		vc_map_integrate_shortcode( 'tm-icon', 'i_', esc_attr__( 'Icon', 'tectxon' ),
		array(	
			'include_only_regex' => '/^(type|icon_\w*)/',
			)
		),
	
	array(
		array(
			'type'				=> 'textfield',
			'holder'			=> 'div',
			'class'				=> '',
			'heading'			=> esc_attr__('Box Number', 'tectxon'),
			'param_name'		=> 'digit',
			'description'		=> esc_attr__('Enter Number here.', 'tectxon'),
			'group'		  => esc_attr__( 'Content', 'tectxon' ),
			'dependency'  => array(
					'element'            => 'view',
					'value_not_equal_to' => array( 'styleone','stylethree'),
			),
		),
		array(
			'type'        => 'dropdown',
			'heading'     => esc_attr__( 'Show button', 'tectxon' ),
			'description' => esc_attr__( 'Show/hide button', 'tectxon' ),
			'param_name'  => 'show_btn',
			'std'         => 'no',
			'value'       => array(
				esc_attr__( 'Yes', 'tectxon' )	=> 'yes',
				esc_attr__( 'No', 'tectxon' )	=> 'no',
			),
			'group'		  => esc_attr__( 'Content', 'tectxon' ),
			'dependency'  => array(
					'element'            => 'view',
					'value_not_equal_to' => array( 'styleone','stylethree','stylenine' ),
			),
		),
		array(
		'type'        => 'vc_link',
		'heading'     => esc_attr__( 'URL (Link)', 'tectxon' ),
		'param_name'  => 'smallicon_link',
		'description' => esc_attr__( 'Add link to Bottom icon.', 'tectxon' ),
		'group'		  => esc_attr__( 'Button', 'tectxon' ),
		'dependency'  => array(
				'element'	=> 'view',
				'value'		=> array('styleone'),
			)
		),
		array(
			'type'        => 'dropdown',
			'heading'     => esc_attr__( 'Background shape', 'tectxon' ),
			'param_name'  => 'icon_bg_style',
			'value'       => array(
				esc_attr__( 'Circle', 'tectxon' ) => 'rounded',
				esc_attr__( 'Square', 'tectxon' ) => 'boxed',
				esc_attr__( 'Rounded', 'tectxon' ) => 'rounded-less',
				esc_attr__( 'Outline Circle', 'tectxon' ) => 'rounded-outline',
				esc_attr__( 'Outline Square', 'tectxon' ) => 'boxed-outline',
				esc_attr__( 'Outline Rounded', 'tectxon' ) => 'rounded-less-outline',
			),
			'std'         => 'rounded',
			'group'		  => esc_attr__( 'Icon', 'tectxon' ),
			'description' => esc_attr__( 'Select background shape and style for icon.', 'tectxon' ),
			'dependency'  => array(
					'element'	=> 'view',
					'value'		=> array('stylenine'),
			)
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_attr__( 'Content alignment', 'tectxon' ),
			'param_name' => 'content_align',
			'value'      => array(
				esc_attr__( 'Left', 'tectxon' )   => 'left',
				esc_attr__( 'Right', 'tectxon' )  => 'right',
				esc_attr__( 'Center', 'tectxon' ) => 'center',
			),
			'std'         => 'center',
			'description' => esc_attr__( 'Select content alignment.', 'tectxon' ),
			'group'		  => esc_attr__( 'Icon', 'tectxon' ),
			'dependency'  => array(
					'element'	=> 'view',
					'value'		=> array('stylethree','style15'),
			)
		),
		array(
			'type' => 'themetechmount_attach_image',
			'heading' => esc_attr__( 'Box Image', 'tectxon' ),
			'param_name' => 'mainiconimage',
			'description' => esc_attr__( 'Select image.', 'tectxon' ),
			'admin_label' => true,
			'group'		  => esc_attr__( 'Icon', 'tectxon' ),
			'dependency'  => array(
					'element'	=> 'main_icon_type',
					'value'		=> array('image'),
			)
		),
	),
	
	$btn_params,
	
	array(
		$extra_class,
		themetechmount_vc_ele_css_editor_option(),
	)
	
	
);


global $tm_sc_params_iconbox;
$tm_sc_params_iconbox = $params;

vc_map( array(
	"name"     => sprintf( esc_attr__("ThemetechMount IconBox",'tectxon') ),
	"base"     => "tm-iconbox",
	"class"    => "",
	'category' => esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	"icon"     => "icon-themetechmount-vc",
	"params"   => $params,
) );