<?php

/* Options for ThemetechMount Blogbox */


$portfolioCatList = array();
if( taxonomy_exists('tm_portfolio_category') ){
	$portfolioCatList_data = get_terms( 'tm_portfolio_category', array( 'hide_empty' => false ) );
	$portfolioCatList      = array();
	foreach($portfolioCatList_data as $cat){
		$portfolioCatList[ esc_attr($cat->name) . ' (' . esc_attr($cat->count) . ')' ] = esc_attr($cat->slug);
	}
}


// Getting Options
$tectxon_theme_options   = get_option('tectxon_theme_options');
$pf_type_title          = ( !empty($tectxon_theme_options['pf_type_title']) ) ? $tectxon_theme_options['pf_type_title'] : 'Portfolio' ;
$pf_type_title_singular = ( !empty($tectxon_theme_options['pf_type_title_singular']) ) ? $tectxon_theme_options['pf_type_title_singular'] : 'Portfolio' ;
$pf_cat_title           = ( !empty($tectxon_theme_options['pf_cat_title']) ) ? $tectxon_theme_options['pf_cat_title'] : 'Portfolio Categories' ;
$pf_cat_title_singular  = ( !empty($tectxon_theme_options['pf_cat_title_singular']) ) ? $tectxon_theme_options['pf_cat_title_singular'] : 'Portfolio Category' ;


/**
 * Heading Element
 */
$heading_element = vc_map_integrate_shortcode( 'tm-heading', '', '',
	array(
		'exclude' => array(
			'el_class',
			'css',
			'css_animation'
		),
	)
);

/**
 * Box Design options
 */
$boxParams = themetechmount_box_params();


$allParams = array_merge(
		
		$heading_element,
		array( 
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Show Sortable Category Links",'tectxon'),
				"description" => sprintf( esc_attr__("Show sortable category links above %s items so user can sort by just single click.",'tectxon'), $pf_type_title_singular ),
				"param_name"  => "sortable",
				"value"       => array(
					esc_attr__('No','tectxon')  => 'no',
					esc_attr__('Yes','tectxon') => 'yes',
				),
				"std"         => "no",
				'dependency'  => array(
					'element'            => 'boxview',
					'value_not_equal_to' => array( 'carousel' ),
				),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_attr__( 'Replace ALL word', 'tectxon' ),
				'param_name'  => 'allword',
				'description' => esc_attr__( 'Replace ALL word in sortable category links. Default is ALL word.', 'tectxon' ),
				"std"         => "All",
				'dependency'  => array(
					'element'   => 'sortable',
					'value'     => array( 'yes' ),
				),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_attr__( 'Sortable Button Type', 'tectxon' ),
				'description' => esc_attr__( 'Sortable Button type square or round', 'tectxon' ),
				'param_name'  => 'sortable_buttontype',
				"value"       => array(
					esc_attr__('Square','tectxon')  => 'square',
					esc_attr__('Round','tectxon') => 'round',
				),
				"std"         => "square",
				'dependency'  => array(
					'element'   => 'sortable',
					'value'     => array( 'yes' ),
				),
			),
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Show Pagination",'tectxon'),
				"description" => sprintf( esc_attr__("Show pagination links below %s boxes.",'tectxon'), $pf_type_title ),
				"param_name"  => "pagination",
				"value"       => array(
					esc_attr__('No','tectxon')  => 'no',
					esc_attr__('Yes','tectxon') => 'yes',
				),
				"std"         => "no",
				'dependency'  => array(
					'element'    => 'sortable',
					'value_not_equal_to' => array( 'yes' ),
				),
			),
			array(
				"type"        => "checkbox",
				"heading"     => sprintf( esc_attr__("From %s", "tectxon"), $pf_cat_title_singular ),
				"description" => sprintf( esc_attr__('If you like to show %1$s from selected %2$s than select the category here.', "tectxon"), $pf_type_title, $pf_cat_title ),
				
				"param_name"  => "category",
				"value"       => $portfolioCatList,
			),
			
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Order by",'tectxon'),
				"description" => esc_attr__("Sort retrieved portfolio by parameter.",'tectxon'),
				"param_name"  => "orderby",
				"value"       => array(
					esc_attr__('No order (none)','tectxon')           => 'none',
					esc_attr__('Order by post id (ID)','tectxon')     => 'ID',
					esc_attr__('Order by author (author)','tectxon')  => 'author',
					esc_attr__('Order by title (title)','tectxon')    => 'title',
					esc_attr__('Order by slug (name)','tectxon')      => 'name',
					esc_attr__('Order by date (date)','tectxon')      => 'date',
					esc_attr__('Order by last modified date (modified)','tectxon') => 'modified',
					esc_attr__('Random order (rand)','tectxon')       => 'rand',
					esc_attr__('Order by number of comments (comment_count)','tectxon') => 'comment_count',
					
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				"std"              => "date",
			),
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Order",'tectxon'),
				"description" => esc_attr__("Designates the ascending or descending order of the 'orderby' parameter.",'tectxon'),
				"param_name"  => "order",
				"value"       => array(
					esc_attr__('Ascending (1, 2, 3; a, b, c)','tectxon')  => 'ASC',
					esc_attr__('Descending (3, 2, 1; c, b, a)','tectxon') => 'DESC',
				),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				"std"              => "DESC",
			),
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Show",'tectxon'),
				"description" => sprintf( esc_attr__("How many %s item you want to show.", "tectxon"), $pf_type_title ),
				"param_name"  => "show",
				"value"       => array(
					esc_attr__("All", "tectxon") => "-1",
					esc_attr__('1', "tectxon")   => "1",
					esc_attr__('2', "tectxon")   => "2",
					esc_attr__('3','tectxon')    =>'3',
					esc_attr__('4','tectxon')    =>'4',
					esc_attr__('5','tectxon')    =>'5',
					esc_attr__('6','tectxon')    =>'6',
					esc_attr__('7','tectxon')    =>'7',
					esc_attr__('8','tectxon')    =>'8',
					esc_attr__('9','tectxon')    =>'9',
					esc_attr__('10','tectxon')   =>'10',
					esc_attr__('11','tectxon')   =>'11',
					esc_attr__('12','tectxon')   =>'12',
					esc_attr__('13','tectxon')   =>'13',
					esc_attr__('14','tectxon')   =>'14',
					esc_attr__('15','tectxon')   =>'15',
					esc_attr__('16','tectxon')   =>'16',
					esc_attr__('17','tectxon')   =>'17',
					esc_attr__('18','tectxon')   =>'18',
					esc_attr__('19','tectxon')   =>'19',
					esc_attr__('20','tectxon')   =>'20',
					esc_attr__('21','tectxon')   =>'21',
					esc_attr__('22','tectxon')   =>'22',
					esc_attr__('23','tectxon')   =>'23',
					esc_attr__('24','tectxon')   =>'24',
				),
				"std"  => "3",
			),
			array(
				"type"        => "dropdown",
				"holder"      => "div",
				"class"       => "",
				"heading"     => esc_attr__("Box Design",'tectxon'),
				"description" => esc_attr__("Select box design.",'tectxon'),
				"param_name"  => "view",
				"value"       => themetechmount_global_portfolio_template_list( true ),
				"std"         => "overlay",
			),
			array(
				"type"        => "dropdown",
				"heading"     => esc_attr__("Box Spacing", "tectxon"),
				"param_name"  => "box_spacing",
				"description" => esc_attr__("Spacing between each box.", "tectxon"),
				"value"       => array(
					esc_attr__("Default", "tectxon")                        => "",
					esc_attr__("0 pixel spacing (joint boxes)", "tectxon")  => "0px",
					esc_attr__("5 pixel spacing", "tectxon")                => "5px",
					esc_attr__("10 pixel spacing", "tectxon")               => "10px",
				),
				"std"  => "",
			)
		),
		$boxParams,
		array(
			themetechmount_vc_ele_css_editor_option(),
		)
		
	);



$params = $allParams;


// Changing default values
$i = 0;
foreach( $params as $param ){
	$param_name = (isset($param['param_name'])) ? $param['param_name'] : '' ;
	if( $param_name == 'h2' ){
		$params[$i]['std'] = 'Our Work';
		
	} else if( $param_name == 'h2_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'h4_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'txt_align' ){
		$params[$i]['std'] = 'center';
	}
	$i++;
}



global $tm_sc_params_portfoliobox;
$tm_sc_params_portfoliobox = $params;




vc_map( array(
	"name"     => sprintf( esc_attr__("ThemetechMount %s Box",'tectxon'), $pf_type_title_singular ),
	"base"     => "tm-portfoliobox",
	"class"    => "",
	'category' => esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	"icon"     => "icon-themetechmount-vc",
	"params"   => $params,
) );