<?php



// Icon picker
$icons_params = vc_map_integrate_shortcode( 'tm-icon', 'i_', '',
	array(
		'include_only_regex' => '/^(type|icon_\w*)/',
		// we need only type, icon_fontawesome, icon_blabla..., NOT color and etc
	), array(
		'element' => 'add_icon',
		'value' => 'true',
	)
);

// each progress bar options
$param_group = array(
	array(
		'type' => 'textfield',
		'heading' => esc_attr__( 'Label', 'tectxon' ),
		'param_name' => 'label',
		'description' => esc_attr__( 'Enter text used as title of bar.', 'tectxon' ),
		'admin_label' => true,
	),
	array(
		'type' => 'textfield',
		'heading' => esc_attr__( 'Value', 'tectxon' ),
		'param_name' => 'value',
		'description' => esc_attr__( 'Enter value of bar.', 'tectxon' ),
		'admin_label' => true,
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_attr__( 'Color', 'tectxon' ),
		'param_name' => 'color',
		'value' => array(
				__( 'Default', 'tectxon' ) => '',
			) + array(
				__( 'Classic Grey', 'tectxon' ) => 'bar_grey',
				__( 'Classic Blue', 'tectxon' ) => 'bar_blue',
				__( 'Classic Turquoise', 'tectxon' ) => 'bar_turquoise',
				__( 'Classic Green', 'tectxon' ) => 'bar_green',
				__( 'Classic Orange', 'tectxon' ) => 'bar_orange',
				__( 'Classic Red', 'tectxon' ) => 'bar_red',
				__( 'Classic Black', 'tectxon' ) => 'bar_black',
			) + themetechmount_getVcShared( 'colors-dashed' ) /*+ array(
				__( 'Custom Color', 'tectxon' ) => 'custom',
			)*/,
		'description' => esc_attr__( 'Select single bar background color.', 'tectxon' ),
		'admin_label' => true,
		'param_holder_class' => 'vc_colored-dropdown',
	),
	
	// Show / Hide icon
	array(
		'type'       => 'dropdown',
		'heading'    => esc_attr__( 'Show Icon?', 'tectxon' ),
		'param_name' => 'add_icon',
		'value'      => array(
			esc_attr__( 'Yes', 'tectxon' ) => 'true',
			esc_attr__( 'No', 'tectxon' )  => 'false',
		),
		'std'         => 'true',
		'description' => esc_attr__( 'Want to show icon with the progress bar.', 'tectxon' ),
	)
);



// Merging icon with other options
$param_group = array_merge( $param_group, $icons_params );






$params =  array(
	array(
		'type' => 'textfield',
		'heading' => esc_attr__( 'Widget title', 'tectxon' ),
		'param_name' => 'title',
		'description' => esc_attr__( 'Enter text used as widget title (Note: located above content element).', 'tectxon' ),
	),
	array(
		'type' => 'param_group',
		'heading' => esc_attr__( 'Values', 'tectxon' ),
		'param_name' => 'values',
		'description' => esc_attr__( 'Enter values for graph - value, title and color.', 'tectxon' ),
		'value' => urlencode( json_encode( array(
			array(
				'label' => esc_attr__( 'Development', 'tectxon' ),
				'value' => '90',
			),
			array(
				'label' => esc_attr__( 'Design', 'tectxon' ),
				'value' => '80',
			),
			array(
				'label' => esc_attr__( 'Marketing', 'tectxon' ),
				'value' => '70',
			),
		) ) ),
		'params' => $param_group,
	),
	array(
		'type' => 'textfield',
		'heading' => esc_attr__( 'Units', 'tectxon' ),
		'param_name' => 'units',
		'description' => esc_attr__( 'Enter measurement units (Example: %, px, points, etc. Note: graph value and units will be appended to graph title).', 'tectxon' ),
	),
	array(
		'type' => 'dropdown',
		'heading' => esc_attr__( 'Color', 'tectxon' ),
		'param_name' => 'bgcolor',
		'std' => 'skincolor',
		'value' => array(
				__( 'Classic Grey', 'tectxon' ) => 'bar_grey',
				__( 'Classic Blue', 'tectxon' ) => 'bar_blue',
				__( 'Classic Turquoise', 'tectxon' ) => 'bar_turquoise',
				__( 'Classic Green', 'tectxon' ) => 'bar_green',
				__( 'Classic Orange', 'tectxon' ) => 'bar_orange',
				__( 'Classic Red', 'tectxon' ) => 'bar_red',
				__( 'Classic Black', 'tectxon' ) => 'bar_black',
			) + themetechmount_getVcShared( 'colors-dashed' ) /* + array(
				__( 'Custom Color', 'tectxon' ) => 'custom',
			)*/ ,
		'description' => esc_attr__( 'Select bar background color.', 'tectxon' ),
		'admin_label' => true,
		'param_holder_class' => 'vc_colored-dropdown',
	),
	array(
		'type' => 'checkbox',
		'heading' => esc_attr__( 'Options', 'tectxon' ),
		'param_name' => 'options',
		'value' => array(
			esc_attr__( 'Add stripes', 'tectxon' ) => 'striped',
			esc_attr__( 'Add animation (Note: visible only with striped bar).', 'tectxon' ) => 'animated',
		),
	),
);



$params = array_merge(
	$params,
	array( vc_map_add_css_animation() ),
	array( themetechmount_vc_ele_extra_class_option() ),
	array( themetechmount_vc_ele_css_editor_option() )
);
		


global $tm_sc_params_progressbar;
$tm_sc_params_progressbar = $params;


vc_map( array(
	'name'		=> esc_attr__( 'ThemetechMount Progress Bar', 'tectxon' ),
	'base'		=> 'tm-progress-bar',
	'class'		=> '',
	'icon'		=> 'icon-themetechmount-vc',
	'category'	=> esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	'params'	=> $params
) );
