<?php

/* Options for ThemetechMount Servicebox */
$bgcolor_custom = array();
$bgcolor_custom[__( 'Transparent', 'tectxon' )] = 'transparent';
$bgcolor_custom[__( 'Skin color', 'tectxon' )]  = 'skincolor';
$boxcolor =   array_merge( $bgcolor_custom , themetechmount_getVcShared( 'colors-dashed' ) ) ;

$params = array_merge(
	
	array(
		array(
			'type'        => 'dropdown',
			'heading'     => esc_attr__( 'Icon position', 'tectxon' ),
			'description' => esc_attr__( 'Icon position in the Service box.', 'tectxon' ),
			'param_name'  => 'add_icon',
			'std'         => 'left-spacing',
			'value'       => array(
				esc_attr__( 'Before Heading', 'tectxon' )           => 'before-heading',
				esc_attr__( 'Top Center', 'tectxon' )               => 'top-center',
				esc_attr__( 'Top Left', 'tectxon' )                 => 'top-left',
				esc_attr__( 'Left with spacing', 'tectxon' )        => 'left-spacing',
				esc_attr__( 'Bottom Center', 'tectxon' )            => 'bottom-center',
				esc_attr__( 'Top Right (RTL)', 'tectxon' )          => 'top-right',
				esc_attr__( 'Right with spacing (RTL)', 'tectxon' ) => 'right-spacing',
				esc_attr__( 'After Heading (RTL)', 'tectxon' )      => 'after-heading',
			),
		),
	),
	
	themetechmount_vc_heading_params(),
	array(
		array(
			'type'       => 'textarea_html',
			'heading'    => esc_attr__( 'Text', 'tectxon' ),
			'param_name' => 'content',
			'value'      => esc_attr__( 'I am promo text. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'tectxon' )
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_attr__( 'Background Color', 'tectxon' ),
			'param_name' => 'bgcolor',
			'value'      => array( 'Transparent' => 'transparent' ) + themetechmount_getVcShared('pre-bg-colors'),
			'std'         => 'transparent',
			'description' => esc_attr__( 'Select Service Box display style.', 'tectxon' ),
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_attr__( 'Text Color', 'tectxon' ),
			'param_name' => 'textcolor',
			'value'      => array( esc_attr__('Default', 'tectxon') => '' ) + themetechmount_getVcShared('pre-text-colors'),
			'std'         => '',
			'description' => esc_attr__( 'Select Service Box display style.', 'tectxon' ),
		)
	),
	array(
		array(
			'type'        => 'dropdown',
			'heading'     => esc_attr__( 'Add button', 'tectxon' ) . '?',
			'description' => esc_attr__( 'Add button to Service Box.', 'tectxon' ),
			'param_name'  => 'add_button',
			'value'       => array(
				esc_attr__( 'No', 'tectxon' )  => '',
				esc_attr__( 'Yes', 'tectxon' ) => 'bottom',
			),
			'std' 		  => '',
			
		),
	),
	vc_map_integrate_shortcode( 'tm-btn', 'btn_', esc_attr__( 'Button', 'tectxon' ),
		array(
		'exclude' => array(
			'align',
			'button_block',
			'el_class',
			'css_animation',
			'css',
		),
	),
		array(
			'element' => 'add_button',
			'not_empty' => true,
		)
	),
	
	vc_map_integrate_shortcode( 'tm-icon', 'i_', esc_attr__( 'Icon', 'tectxon' ),
		array(
			'exclude' => array( 'align', 'el_class', 'css_animation', 'link', 'css' ),
		)
	),
	
	array(
		
		array(
			"type"       => "dropdown",
			"heading"    => esc_attr__("Box Hover Effect",'tectxon'),
			"param_name" => "hover",
			"value"      => array(
				esc_attr__('None','tectxon')                   => 'none',
				esc_attr__('Float Shadow','tectxon')           => 'hvr-float-shadow',
				esc_attr__('Grow','tectxon')                   => 'hvr-grow',
				esc_attr__('Shrink','tectxon')                 => 'hvr-shrink',
				esc_attr__('Pulse','tectxon')                  => 'hvr-pulse',
				esc_attr__('Pulse Grow','tectxon')             => 'hvr-pulse-grow',
				esc_attr__('Pulse Shrink','tectxon')           => 'hvr-pulse-shrink',
				esc_attr__('Push','tectxon')                   => 'hvr-push',
				esc_attr__('Pop','tectxon')                    => 'hvr-pop',
				esc_attr__('Bounce In','tectxon')              => 'hvr-bounce-in',
				esc_attr__('Bounce Out','tectxon')             => 'hvr-bounce-out',
				esc_attr__('Rotate','tectxon')                 => 'hvr-rotate',
				esc_attr__('Grow Rotate','tectxon')            => 'hvr-grow-rotate',
				esc_attr__('Float','tectxon')                  => 'hvr-float',
				esc_attr__('Sink','tectxon')                   => 'hvr-sink',
				esc_attr__('Bob','tectxon')                    => 'hvr-bob',
				esc_attr__('Hang','tectxon')                   => 'hvr-hang',
				esc_attr__('Skew','tectxon')                   => 'hvr-skew',
				esc_attr__('Skew Forward','tectxon')           => 'hvr-skew-forward',
				esc_attr__('Wobble Horizontal','tectxon')      => 'hvr-wobble-horizontal',
				esc_attr__('Wobble Vertical','tectxon')        => 'hvr-wobble-vertical',
				esc_attr__('Wobble To Bottom Right','tectxon') => 'hvr-wobble-to-bottom-right',
				esc_attr__('Wobble To Top Right','tectxon')    => 'hvr-wobble-to-top-right',
				esc_attr__('Wobble Top','tectxon')             => 'hvr-wobble-top',
				esc_attr__('Wobble Bottom','tectxon')          => 'hvr-wobble-bottom',
				esc_attr__('Wobble Skew','tectxon')            => 'hvr-wobble-skew',
				esc_attr__('Buzz','tectxon')                   => 'hvr-buzz',
				esc_attr__('Buzz Out','tectxon')               => 'hvr-buzz-out',
			),
			"description"      => esc_attr__("Select hover effect.",'tectxon') . ' <a href="' . esc_url('http://ianlunn.github.io/Hover/') . '" target="_blank">' . esc_attr__("Click here to view sample animation of each.",'tectxon') . '</a>',
			'std'              => 'none',
			'group'            => esc_attr__( 'Animations', 'tectxon' ),
		),
		array(
			"type"       => "dropdown",
			"heading"    => esc_attr__("Box Hover Effect: For Background Image",'tectxon'),
			"param_name" => "hover_bg_effect",
			"value"      => array(
				esc_attr__('None','tectxon')                    => '',
				esc_attr__('Zoom-in image','tectxon')           => 'zoomin',
				esc_attr__('Zoom-out image','tectxon')          => 'zoomout',
			),
			"description" => esc_attr__("Select hover effect for background image only.",'tectxon') . '<br>' . '<strong>' . esc_attr__("NOTE:",'tectxon') . '</strong>' . esc_attr__("This will work with \"Top Center\", \"Top Left\" and \"Top Right\" icon position only.",'tectxon'),
			'dependency'  => array(
				'element'   => 'add_icon',
				'value'     => array( 'top-center', 'top-left', 'top-right', 'bottom-center' ),
			),
			'std'              => '',
			'group'            => esc_attr__( 'Animations', 'tectxon' ),
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_attr__( 'Rotate background on hover?', 'tectxon' ),
			'param_name'       => 'hover_bg_rotate',
			'description'      => esc_attr__( 'Rotate background on hover?', 'tectxon' ),
			"value"      => array(
				esc_attr__('No','tectxon')  => 'no',
				esc_attr__('Yes','tectxon') => 'yes',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'dependency'  => array(
				'element'        => 'hover_bg_effect',
				//'value_not_equal_to' => ''
				'value'          => array('zoomin','zoomout'),
			),
			'group'            => esc_attr__( 'Animations', 'tectxon' ),
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_attr__( 'Blur background on hover?', 'tectxon' ),
			'param_name'       => 'hover_bg_blur',
			'description'      => esc_attr__( 'Blur background on hover?', 'tectxon' ),
			"value"      => array(
				esc_attr__('No','tectxon')  => 'no',
				esc_attr__('Yes','tectxon') => 'yes',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'dependency'  => array(
				'element'            => 'hover_bg_effect',
				'value'          => array('zoomin','zoomout'),
			),
			'group'            => esc_attr__( 'Animations', 'tectxon' ),
		),
		
		array(
			"type"			=> "dropdown",
			"heading"		=> esc_attr__("Box Hover Effect: Select content animation style",'tectxon'),
			"param_name"	=> "box_effect",
			"value"			=> array(
				esc_attr__('None','tectxon')                => '',
				esc_attr__('Animate from bottom','tectxon') => 'one',
			),
			"description"	=> esc_attr__("Select hover effect for content only.",'tectxon') . '<br>' . '<strong>' . esc_attr__("NOTE:",'tectxon') . '</strong> ' . esc_attr__("This will work with \"Top Center\", \"Top Left\" and \"Top Right\" icon position only.",'tectxon'),
			'std'			=> '',
			'group'			=> esc_attr__( 'Animations', 'tectxon' ),
			'dependency'	=> array(
				'element'		=> 'add_icon',
				'value'			=> array('top-center','top-left','top-right', 'bottom-center'),
			),
		),
		
	),
	
	array(
		/// cta3
		vc_map_add_css_animation(),
		themetechmount_vc_ele_extra_class_option(),
		themetechmount_vc_ele_css_editor_option(),
	)
	
	
);

// Changing modifying, adding extra options
$i = 0;
foreach( $params as $param ){
	
	$param_name = (isset($param['param_name'])) ? $param['param_name'] : '' ;
	
	if( $param_name == 'txt_align' ){ // Remove Text Alignment option
		$params[$i]['dependency'] = array(  // This is to hide this option forever
			'element'  => 'btn_style',
			'value'    => array( 'abcdefg' )
		);
		
	} else if( $param_name == 'btn_style' ){
		$style = $param['value'];
		if( is_array($style) ){
			$params[$i]['std']   = 'text';
		}
		
	} else if( $param_name == 'btn_color' ){
		$colors = $param['value'];
		if( is_array($colors) ){
			$params[$i]['std']   = 'skincolor';
		}
	
	} else if( $param_name == 'color' ){
		$colors = $param['value'];
		if( is_array($colors) ){
			$colors = array_reverse($colors);
			$colors[__( 'Skin color', 'tectxon' )] = 'skincolor';
			$params[$i]['value'] = array_reverse($colors);
			$params[$i]['std']   = 'grey';
		}
	
	} else if( $param_name == 'btn_shape' ){
		$params[$i]['dependency'] = array(
			'element'            => 'btn_style',
			'value_not_equal_to' => array( 'text' )
		);
	} else if( $param_name == 'btn_title' ){
		$params[$i]['std'] = esc_attr__( 'Read More', 'tectxon' );
	
	} else if( $param_name == 'btn_add_icon' ){
		$params[$i]['std']   = false;
	
	} else if( $param_name == 'i_background_style' ){
		$params[$i]['value'][__( 'None', 'tectxon' )] = 'none';
		$params[$i]['std'] = 'none';
		
	} else if( $param_name == 'i_background_color' ){
		$params[$i]['value'][__( 'None', 'tectxon' )] = 'none';
		$params[$i]['std'] = 'grey';
		$params[$i]['dependency'] = array(
			'element'               => 'i_background_style',
			'value_not_equal_to'    => array( 'none' )
		);
		
	} else if( $param_name == 'separator' ){
		$params[$i]['dependency'] = array(
			'element'  => 'i_type',
			'value'    => array( 'notavailablevalue' ),
		);
	
	
	} else if( $param_name == 'i_size' ){
		$params[$i]['std'] = 'md';
		
	} else if( $param_name == 'h2_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'h4_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'h2_google_fonts' ){
		$params[$i]['std'] = 'font_family:Arimo%3Aregular%2Citalic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal';
	
	} else if( $param_name == 'h4_google_fonts' ){
		$params[$i]['std'] = 'font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal';
	
	} else if( $param_name == 'css_animation' ){
		$params[$i]['group'] = esc_attr__( 'Animations', 'tectxon' );
	
	}
	
	$i++;
} // Foreach


global $tm_sc_params_servicebox;
$tm_sc_params_servicebox = $params;




vc_map( array(
	'name'        => esc_attr__( 'ThemetechMount Service Box', 'tectxon' ),
	'base'        => 'tm-servicebox',
	"icon"        => "icon-themetechmount-vc",
	'category'    => esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	'params'      => $params,
) );