<?php

/* Options */

// Getting social list
$global_social_list = themetechmount_shared_social_list();

$sociallist = array_merge(
	array('' => esc_attr__('Select service','tectxon')),
	$global_social_list,
	array('rss'     => 'Rss Feed')
);
$sociallist = array_flip($sociallist);


$params = array_merge(
	themetechmount_vc_heading_params(),
	array(
		array(
			'type'        => 'param_group',
			'heading'     => esc_attr__( 'Social Services List', 'tectxon' ),
			'param_name'  => 'socialservices',
			'description' => esc_attr__( 'Select social service and add URL for it.', 'tectxon' ).'<br><strong>'.esc_attr__('NOTE:','tectxon').'</strong> '.esc_attr__("You don't need to add URL if you are selecting 'RSS' in the social service",'tectxon'),
			'group'       => esc_attr__( 'Social Services', 'tectxon' ),
			'params'     => array(
				array( // First social service
					'type'        => 'dropdown',
					'heading'     => esc_attr__( 'Select Social Service', 'tectxon' ),
					'param_name'  => 'servicename',
					'std'         => 'none',
					'value'       => $sociallist,
					'description' => esc_attr__( 'Select social service', 'tectxon' ),
					'group'       => esc_attr__( 'Social Services', 'tectxon' ),
					'admin_label' => true,
					'edit_field_class' => 'vc_col-sm-4 vc_column',
				),
				array(
					'type'        => 'textarea',
					'heading'     => esc_attr__( 'Social URL', 'tectxon' ),
					'param_name'  => 'servicelink',
					'dependency'  => array(
						'element'            => 'servicename',
						'value_not_equal_to' => array( 'rss' )
					),
					'value'       => '',
					'description' => esc_attr__( 'Fill social service URL', 'tectxon' ),
					'group'       => esc_attr__( 'Social Services', 'tectxon' ),
					'admin_label' => true,
					'edit_field_class' => 'vc_col-sm-8 vc_column',
				),
			),
		),
		array( // First social service
			'type'        => 'dropdown',
			'heading'     => esc_attr__( 'Select column', 'tectxon' ),
			'param_name'  => 'column',
			'value'       => array(
				esc_attr__('One column','tectxon')   => 'one',
				esc_attr__('Two column','tectxon')   => 'two',
				esc_attr__('Three column','tectxon') => 'three',
				esc_attr__('Four column','tectxon')  => 'four',
				esc_attr__('Five column','tectxon')  => 'five',
				esc_attr__('Six column','tectxon')   => 'six',
			),
			'std'         => 'six',
			'description' => esc_attr__( 'Select how many column will show the social icons', 'tectxon' ),
			'group'       => esc_attr__( 'Social Services', 'tectxon' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array( // First social service
			'type'        => 'dropdown',
			'heading'     => esc_attr__( 'Social icon size', 'tectxon' ),
			'param_name'  => 'iconsize',
			'std'         => 'large',
			'value'       => array(
				esc_attr__('Small icon','tectxon')  => 'small',
				esc_attr__('Medium icon','tectxon') => 'medium',
				esc_attr__('Large icon','tectxon')  => 'large',
			),
			'description' => esc_attr__( 'Select social icon size', 'tectxon' ),
			'group'       => esc_attr__( 'Social Services', 'tectxon' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
	),
	
	array( vc_map_add_css_animation() ),
	array( themetechmount_vc_ele_extra_class_option() ),
	array( themetechmount_vc_ele_css_editor_option() )
	
);

global $tm_sc_params_socialbox;
$tm_sc_params_socialbox = $params;


vc_map( array(
	'name'        => esc_attr__( 'ThemetechMount Social Box', 'tectxon' ),
	'base'        => 'tm-socialbox',
	"icon"        => "icon-themetechmount-vc",
	'category'    => esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	'params'      => $params,
) );