<?php

/* Options for ThemetechMount Blogbox */

// Team Group
$teamGroupList = array();
if( taxonomy_exists('tm_team_group') ){
	$teamGroups    = get_terms( 'tm_team_group', array( 'hide_empty' => false ) );
	$teamGroupList = array();
	foreach($teamGroups as $teamGroup){
		$name                   = $teamGroup->name.' ('.$teamGroup->count.')';
		$teamGroupList[ $name ] = $teamGroup->slug;
	}
}


// Getting Options
$tectxon_theme_options      = get_option('tectxon_theme_options');
$team_type_title           = ( !empty($tectxon_theme_options['team_type_title']) ) ? $tectxon_theme_options['team_type_title'] : 'Team Members' ;
$team_type_title_singular  = ( !empty($tectxon_theme_options['team_type_title_singular']) ) ? $tectxon_theme_options['team_type_title_singular'] : 'Team Member' ;
$team_group_title          = ( !empty($tectxon_theme_options['team_group_title']) ) ? $tectxon_theme_options['team_group_title'] : 'Team Groups' ;
$team_group_title_singular = ( !empty($tectxon_theme_options['team_group_title_singular']) ) ? $tectxon_theme_options['team_group_title_singular'] : 'Team Group' ;



/**
 * Heading Element
 */
$heading_element = vc_map_integrate_shortcode( 'tm-heading', '', '',
	array(
		'exclude' => array(
			'el_class',
			'css',
			'css_animation'
		),
	)
);

/**
 * Box Design options
 */
$boxParams = themetechmount_box_params();



$allParams = array_merge(

	$heading_element,
	array(
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => sprintf( esc_attr__("Show Sortable %s Links",'tectxon'), $team_group_title ),
			"description" => sprintf( esc_attr__("Show sortable %s links above box items so user can sort by just single click.",'tectxon'), $team_group_title ),
			"param_name"  => "sortable",
			"value"       => array(
				esc_attr__('No','tectxon')  => 'no',
				esc_attr__('Yes','tectxon') => 'yes',
			),
			"std"         => "no",
			'dependency'  => array(
				'element'            => 'boxview',
				'value_not_equal_to' => array( 'carousel' ),
			),
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_attr__( 'Replace ALL word', 'tectxon' ),
			'param_name'  => 'allword',
			'description' => esc_attr__( 'Replace ALL word in sortable group links. Default is ALL word.', 'tectxon' ),
			"std"         => "All",
			'dependency'  => array(
				'element'   => 'sortable',
				'value'     => array( 'yes' ),
			),
		),
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Show Pagination",'tectxon'),
			"description" => sprintf( esc_attr__("Show pagination links below %s boxes.",'tectxon'), $team_type_title_singular ),
			"param_name"  => "pagination",
			"value"       => array(
				esc_attr__('No','tectxon')  => 'no',
				esc_attr__('Yes','tectxon') => 'yes',
			),
			"std"         => "no",
			'dependency'  => array(
				'element'    => 'sortable',
				'value_not_equal_to' => array( 'yes' ),
			),
		),
		array(
			"type"        => "checkbox",
			"heading"     => sprintf( esc_attr__("From %s", "tectxon"), $team_group_title_singular ),
			"param_name"  => "category",
			"description" => sprintf( esc_attr__('If you like to show %1$s from selected %2$s than select the category here.', "tectxon"), $team_type_title, $team_group_title ),
			"value"       => $teamGroupList,
		),
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Order by",'tectxon'),
			"description" => sprintf( esc_attr__("Sort retrieved %s by parameter.",'tectxon'), $team_type_title_singular ),
			"param_name"  => "orderby",
			"value"       => array(
				esc_attr__('No order (none)','tectxon')           => 'none',
				esc_attr__('Order by post id (ID)','tectxon')     => 'ID',
				esc_attr__('Order by author (author)','tectxon')  => 'author',
				esc_attr__('Order by title (title)','tectxon')    => 'title',
				esc_attr__('Order by slug (name)','tectxon')      => 'name',
				esc_attr__('Order by date (date)','tectxon')      => 'date',
				esc_attr__('Order by last modified date (modified)','tectxon') => 'modified',
				esc_attr__('Random order (rand)','tectxon')       => 'rand',
				esc_attr__('Order by number of comments (comment_count)','tectxon') => 'comment_count',
				
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			"std"              => "date",
		),
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Order",'tectxon'),
			"description" => esc_attr__("Designates the ascending or descending order of the 'orderby' parameter.",'tectxon'),
			"param_name"  => "order",
			"value"       => array(
				esc_attr__('Ascending (1, 2, 3; a, b, c)','tectxon')  => 'ASC',
				esc_attr__('Descending (3, 2, 1; c, b, a)','tectxon') => 'DESC',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			"std"              => "DESC",
		),
		array(
			"type"        => "dropdown",
			"heading"     => esc_attr__("Show", "tectxon"),
			"param_name"  => "show",
			"description" => sprintf( esc_attr__("How many %s item you want to show.", "tectxon"), $team_type_title ),
			"value"       => array(
				esc_attr__("All", "tectxon") => "-1",
				esc_attr__("1", "tectxon")  => "1",
				esc_attr__("2", "tectxon") => "2",
				esc_attr__("3", "tectxon") => "3",
				esc_attr__("4", "tectxon") => "4",
				esc_attr__("5", "tectxon") => "5",
				esc_attr__("6", "tectxon") => "6",
				esc_attr__("7", "tectxon") => "7",
				esc_attr__("8", "tectxon") => "8",
				esc_attr__("9", "tectxon") => "9",
				esc_attr__("10", "tectxon") => "10",
			),
			"std"  => "4",
		),
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Box Design",'tectxon'),
			"description" => esc_attr__("Select box design.",'tectxon'),
			"param_name"  => "view",
			"value"       => themetechmount_global_team_member_template_list( true ),
			"std"         => "overlay",
		),
		array(
			"type"        => "dropdown",
			"heading"     => esc_attr__("Box Spacing", "tectxon"),
			"param_name"  => "box_spacing",
			"description" => esc_attr__("Spacing between each box.", "tectxon"),
			"value"       => array(
				esc_attr__("Default", "tectxon")                        => "",
				esc_attr__("0 pixel spacing (joint boxes)", "tectxon")  => "0px",
				esc_attr__("5 pixel spacing", "tectxon")                => "5px",
				esc_attr__("10 pixel spacing", "tectxon")               => "10px",
			),
			"std"  => "",
		)
	),
	$boxParams,
	array(
		themetechmount_vc_ele_css_editor_option(),
	)
	
);





$params = $allParams;



// Changing default values
$i = 0;
foreach( $params as $param ){
	$param_name = (isset($param['param_name'])) ? $param['param_name'] : '' ;
	if( $param_name == 'column' ){
		$params[$i]['std'] = 'four';
		
	} else if( $param_name == 'h2' ){
		$params[$i]['std'] = 'Our Team';
	
	} else if( $param_name == 'h2_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'h4_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
			
	} else if( $param_name == 'txt_align' ){
		$params[$i]['std'] = 'center';
		
	}
	
	$i++;
}



global $tm_sc_params_teambox;
$tm_sc_params_teambox = $params;


vc_map( array(
	"name"     => sprintf( esc_attr__("ThemetechMount %s Box", "tectxon"), $team_type_title_singular ),
	"base"     => "tm-teambox",
	"icon"     => "icon-themetechmount-vc",
	'category' => esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	"params"   => $params,
) );