<?php

/* Options for ThemetechMount Testimonial box */



// Fetching all Testmonial group names
$testimonialGroups = array();
if( taxonomy_exists('tm_testimonial_group') ){
	$testimonial_groups = get_terms( 'tm_testimonial_group', array('hide_empty'=>false) );
	$testimonialGroups  = array();
	foreach( $testimonial_groups as $group ){
		$totalcount = 0;
		if( trim($group->count) > 0 ){
			$totalcount = $group->count;
		}
		$testimonialGroups[ $group->name.' ('.$totalcount.')' ] = $group->slug;
	}
}

/**
 * Heading Element
 */
$heading_element = vc_map_integrate_shortcode( 'tm-heading', '', '',
	array(
		'exclude' => array(
			'el_class',
			'css',
			'css_animation'
		),
	)
);

/**
 * Box Design options
 */
$boxParams = themetechmount_box_params('testimonial');


$allParams = array_merge(

	$heading_element,
	array(
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Show Sortable Category Links",'tectxon'),
			"description" => esc_attr__("Show sortable category links above Testimonial boxes so user can sort by category by just single click.",'tectxon'),
			"param_name"  => "sortable",
			"value"       => array(
				esc_attr__('No','tectxon')  => 'no',
				esc_attr__('Yes','tectxon') => 'yes',
			),
			"std"         => "no",
			'dependency'  => array(
				'element'            => 'boxview',
				'value_not_equal_to' => array( 'carousel' ),
			),
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_attr__( 'Replace ALL word', 'tectxon' ),
			'param_name'  => 'allword',
			'description' => esc_attr__( 'Replace ALL word in sortable category links. Default is ALL word.', 'tectxon' ),
			"std"         => "All",
			'dependency'  => array(
				'element'   => 'sortable',
				'value'     => array( 'yes' ),
			),
		),
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Show Pagination",'tectxon'),
			"description" => esc_attr__("Show pagination links below Testimonial boxes.",'tectxon'),
			"param_name"  => "pagination",
			"value"       => array(
				esc_attr__('No','tectxon')  => 'no',
				esc_attr__('Yes','tectxon') => 'yes',
			),
			"std"         => "no",
			'dependency'  => array(
				'element'            => 'sortable',
				'value_not_equal_to' => array( 'yes' ),
			),
		),
		array(
			"type"        => "checkbox",
			"heading"     => esc_attr__("From Group", "tectxon"),
			"param_name"  => "category",
			"description" => esc_attr__("Select group so it will show Testimonials from selected group only.", "tectxon"),
			"value"       => $testimonialGroups,
			"std"         => "",
		),
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Order by",'tectxon'),
			"description" => esc_attr__("Sort retrieved portfolio by parameter.",'tectxon'),
			"param_name"  => "orderby",
			"value"       => array(
				esc_attr__('No order (none)','tectxon')           => 'none',
				esc_attr__('Order by post id (ID)','tectxon')     => 'ID',
				esc_attr__('Order by author (author)','tectxon')  => 'author',
				esc_attr__('Order by title (title)','tectxon')    => 'title',
				esc_attr__('Order by slug (name)','tectxon')      => 'name',
				esc_attr__('Order by date (date)','tectxon')      => 'date',
				esc_attr__('Order by last modified date (modified)','tectxon') => 'modified',
				esc_attr__('Random order (rand)','tectxon')       => 'rand',
				esc_attr__('Order by number of comments (comment_count)','tectxon') => 'comment_count',
				
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			"std"              => "date",
		),
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Order",'tectxon'),
			"description" => esc_attr__("Designates the ascending or descending order of the 'orderby' parameter.",'tectxon'),
			"param_name"  => "order",
			"value"       => array(
				esc_attr__('Ascending (1, 2, 3; a, b, c)','tectxon')  => 'ASC',
				esc_attr__('Descending (3, 2, 1; c, b, a)','tectxon') => 'DESC',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			"std"              => "DESC",
		),
		array(
			"type"        => "dropdown",
			"heading"     => esc_attr__("Show", "tectxon"),
			"param_name"  => "show",
			"description" => esc_attr__("Total Testimonials you want to show.", "tectxon"),
			"value"       => array(
				esc_attr__("All", "tectxon") => "-1",
				esc_attr__("1", "tectxon")  => "1",
				esc_attr__("2", "tectxon") => "2",
				esc_attr__("3", "tectxon") => "3",
				esc_attr__("4", "tectxon") => "4",
				esc_attr__("5", "tectxon") => "5",
				esc_attr__("6", "tectxon") => "6",
				esc_attr__("7", "tectxon") => "7",
				esc_attr__("8", "tectxon") => "8",
				esc_attr__("9", "tectxon") => "9",
				esc_attr__("10", "tectxon") => "10",
				esc_attr__("11", "tectxon") => "11",
				esc_attr__("12", "tectxon") => "12",
				esc_attr__("13", "tectxon") => "13",
				esc_attr__("14", "tectxon") => "14",
				esc_attr__("15", "tectxon") => "15",
				esc_attr__("16", "tectxon") => "16",
				esc_attr__("17", "tectxon") => "17",
				esc_attr__("18", "tectxon") => "18",
				esc_attr__("19", "tectxon") => "19",
				esc_attr__("20", "tectxon") => "20",
			),
			"std"  => "3",
		),
		array(
			"type"        => "dropdown",
			"holder"      => "div",
			"class"       => "",
			"heading"     => esc_attr__("Box Design",'tectxon'),
			"description" => esc_attr__("Select box design.",'tectxon'),
			"param_name"  => "view",
			"value"       => themetechmount_global_testimonial_template_list( true ),
			"std"         => "top-image",
		),
		array(
			"type"        => "dropdown",
			"heading"     => esc_attr__("Box Spacing", "tectxon"),
			"param_name"  => "box_spacing",
			"description" => esc_attr__("Spacing between each box.", "tectxon"),
			"value"       => array(
				esc_attr__("Default", "tectxon")                        => "",
				esc_attr__("0 pixel spacing (joint boxes)", "tectxon")  => "0px",
				esc_attr__("5 pixel spacing", "tectxon")                => "5px",
				esc_attr__("10 pixel spacing", "tectxon")               => "10px",
			),
			"std"  => "",
		)
	),
	$boxParams,
	array(
		themetechmount_vc_ele_css_editor_option(),
	)

	
);


$params = $allParams;



// Changing default values
$i = 0;
foreach( $params as $param ){
	$param_name = (isset($param['param_name'])) ? $param['param_name'] : '' ;
	if( $param_name == 'h2' ){
		$params[$i]['std'] = 'Testimonials';
		
	} else if( $param_name == 'h2_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
		
	} else if( $param_name == 'h4_use_theme_fonts' ){
		$params[$i]['std'] = 'yes';
			
	} else if( $param_name == 'txt_align' ){
		$params[$i]['std'] = 'center';
		
	} else if( $param_name == 'content' ){
		$params[$i]['std'] = '';
		
	}
	
	$i++;
}



global $tm_sc_params_testimonialbox;
$tm_sc_params_testimonialbox = $params;


vc_map( array(
	"name"     => esc_attr__("ThemetechMount Testimonial Box", "tectxon"),
	"base"     => "tm-testimonialbox",
	"icon"     => "icon-themetechmount-vc",
	'category' => esc_attr__( 'ThemetechMount Special Elements', 'tectxon' ),
	"params"   => $params,
) );